/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.coralApps.main.controller;

import com.coraltele.db.coralapps.main.repository.AgentRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.coralApps.callcenter.queue.model.QueueServicesModel;
import com.coraltele.service.coralApps.main.model.AgentContactModel;
import com.coraltele.service.coralApps.main.model.AgentCreateModel;
import com.coraltele.service.coralApps.main.model.AgentTiersMultipleUpdateModel;
import com.coraltele.service.coralApps.main.model.AgentUserModel;
import com.coraltele.service.coralApps.main.service.AgentService;
import com.coraltele.service.pbx.extension.service.ExtensionsService;
import java.io.IOException;
import java.security.Principal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/agent"})
@RestController
public class AgentController {
    @Autowired
    AgentService agentCreateService;
    @Autowired
    ExtensionsService extensionsService;
    @Autowired
    AgentRepository agentRepository;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> createExtensionAgentByGivenRange(@RequestBody QueueServicesModel data, Principal principal) throws IOException {
        RequestResponse returnValue = this.agentCreateService.createAgentByQueue(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete/{id}"})
    public ResponseEntity<RequestResponse> delete(@PathVariable(value="id") int id) {
        RequestResponse returnValue = this.agentCreateService.deleteAgent(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAgentUserList() {
        RequestResponse returnValue = this.agentCreateService.getAgentUsersDetail();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateAgent(@RequestBody AgentUserModel data) {
        RequestResponse returnValue = this.agentCreateService.updateAgentUser(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/{name}"})
    public ResponseEntity<RequestResponse> getByName(@PathVariable(value="name") String name) {
        RequestResponse returnValue = this.agentCreateService.getByName(name);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list/{queue}"})
    public ResponseEntity<RequestResponse> getAgentUsersDetailsWithoutQueue(@PathVariable(value="queue") String queue, Principal principal) {
        RequestResponse returnValue = this.agentCreateService.getAgentUsersDetailsWithoutQueue(queue, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listOfExtensionPhone/{queue}"})
    public ResponseEntity<RequestResponse> getAgentUsersDetailsWithoutQueue1(@PathVariable(value="queue") String queue, Principal principal) {
        RequestResponse returnValue = this.agentCreateService.getAgentUsersDetailsWithoutQueue1(queue, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listQueue/{queue}"})
    public ResponseEntity<RequestResponse> getAgentUsersDetailsWithQueue(@PathVariable(value="queue") String queue) {
        RequestResponse returnValue = this.agentCreateService.getAgentUsersDetailsWithQueue(queue);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/updateTiers"})
    public ResponseEntity<RequestResponse> updateInTiers(@RequestBody AgentTiersMultipleUpdateModel data) {
        RequestResponse returnValue = this.agentCreateService.createInTiers(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/deleteTiers"})
    public ResponseEntity<RequestResponse> deleteTiersById(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.agentCreateService.deleteTiersById(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/updateTiersAndAgent"})
    public ResponseEntity<RequestResponse> updateInTiersAndAgent(@RequestBody AgentTiersMultipleUpdateModel data) {
        RequestResponse returnValue = this.agentCreateService.updateInTiersAndAgent(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/deleteTiersAndAgent"})
    public ResponseEntity<RequestResponse> deleteTiersAndAgentById(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.agentCreateService.deleteTiersAndAgentById(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/updateAgentContact"})
    public ResponseEntity<RequestResponse> updateAgentContact(@RequestBody AgentContactModel agentContactModel) {
        RequestResponse response = this.agentCreateService.updateAgentContact(agentContactModel);
        if (response.getStatus() == Constants.Error.OK) {
            return ResponseEntity.ok((Object)response);
        }
        return ResponseEntity.badRequest().body((Object)response);
    }

    @PostMapping(value={"queueByAgent/{name}"})
    public ResponseEntity<RequestResponse> getQueueAgainstAgent(@PathVariable(value="name") String name) {
        RequestResponse returnValue = this.agentCreateService.getQueueAgainstAgent(name);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/queueByExtension/{name}"})
    public ResponseEntity<RequestResponse> getQueueAgainstExtension(@PathVariable(value="name") String name) {
        RequestResponse returnValue = this.agentCreateService.getQueueAgainstExtension(name);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"deleteSwitchAcd/{ext}"})
    public ResponseEntity<RequestResponse> deleteSwitchAcd(@PathVariable(value="ext") int ext) {
        RequestResponse returnValue = this.agentCreateService.deleteSwitchAcd(Integer.valueOf(ext));
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAll"})
    public ResponseEntity<RequestResponse> getAllAgentList() {
        RequestResponse returnValue = this.agentCreateService.getAllAgentList();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/createAgent"})
    public ResponseEntity<RequestResponse> create(@RequestBody AgentCreateModel data) {
        RequestResponse returnValue = this.agentCreateService.createDataInAgent(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/updateAgent"})
    public ResponseEntity<RequestResponse> updateById(@RequestBody AgentCreateModel data) {
        RequestResponse returnValue = this.agentCreateService.updateById(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/deleteAgent"})
    public ResponseEntity<RequestResponse> deleteById(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.agentCreateService.deleteAgentById(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/filteredList"})
    public ResponseEntity<RequestResponse> getAllByFilter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.agentCreateService.getAllByFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/updateDialingStatus"})
    public ResponseEntity<RequestResponse> updateDialingStatus(@RequestBody AgentCreateModel data, Principal principal) {
        RequestResponse returnValue = this.agentCreateService.updateDialingStatus(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/checkCallStatus"})
    public ResponseEntity<RequestResponse> getByAgent(Principal principal) {
        RequestResponse returnValue = this.agentCreateService.getAgentCallData(principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listTL/{teamLeader}"})
    public ResponseEntity<RequestResponse> getAgentWithTeamLeader(@PathVariable(value="teamLeader") String teamLeader) {
        RequestResponse returnValue = this.agentCreateService.getAgentWithTeamLeader(teamLeader);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list/agentWithoutTL"})
    public ResponseEntity<RequestResponse> getAgentWithoutTeamLeader() {
        RequestResponse returnValue = this.agentCreateService.getAgentWithoutTeamLeader();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update/reportingHeadBlank"})
    public ResponseEntity<RequestResponse> updateReportingHeadBlank(@RequestBody AgentTiersMultipleUpdateModel data) {
        RequestResponse returnValue = this.agentCreateService.updateReportingHeadBlank(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update/reportingHead"})
    public ResponseEntity<RequestResponse> updateReportingHead(@RequestBody AgentTiersMultipleUpdateModel data) {
        RequestResponse returnValue = this.agentCreateService.updateReportingHead(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

