/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.coralApps.callcenter.evaluation.service;

import com.coraltele.db.coralapps.callcenter.entity.EvaluationMaster;
import com.coraltele.db.coralapps.callcenter.repository.EvaluationMasterRepository;
import com.coraltele.db.coralapps.callcenter.specification.EvaluationMasterSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.coralApps.callcenter.evaluation.model.EvaluationModel;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class EvaluationService {
    private static final Logger logger = LogManager.getLogger(EvaluationService.class);
    @Autowired
    private EvaluationMasterRepository evaluationMasterRepository;

    public RequestResponse createEvaluation(EvaluationModel model, Principal principal) {
        RequestResponse response = new RequestResponse();
        if (model.getQuestion() == null || model.getQuestion().trim().isEmpty()) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Question cannot be empty.");
            return response;
        }
        EvaluationMaster evaluation = new EvaluationMaster();
        evaluation.setQuestion(model.getQuestion().trim());
        evaluation.setScore(model.getScore());
        evaluation.setCreatedby(principal.getName());
        evaluation.setCreatedon(LocalDateTime.now());
        this.evaluationMasterRepository.save((Object)evaluation);
        response.setStatus(Constants.Error.OK);
        response.setMessage("Evaluation created successfully.");
        return response;
    }

    public RequestResponse updateEvaluation(EvaluationModel model, Principal principal) {
        RequestResponse response = new RequestResponse();
        Optional optionalEvaluation = this.evaluationMasterRepository.findById((Object)model.getId());
        if (!optionalEvaluation.isPresent()) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Evaluation not found.");
            return response;
        }
        EvaluationMaster evaluation = (EvaluationMaster)optionalEvaluation.get();
        if (model.getQuestion() != null && !model.getQuestion().trim().isEmpty()) {
            evaluation.setQuestion(model.getQuestion().trim());
        }
        evaluation.setScore(model.getScore());
        evaluation.setUpdateby(principal.getName());
        evaluation.setUpdatedon(LocalDateTime.now());
        this.evaluationMasterRepository.save((Object)evaluation);
        response.setStatus(Constants.Error.OK);
        response.setMessage("Evaluation updated successfully.");
        return response;
    }

    public RequestResponse deleteEvaluation(InputIdModel data) {
        RequestResponse response = new RequestResponse();
        ArrayList toDelete = new ArrayList();
        for (Integer id : data.getIntId()) {
            Optional evaluation = this.evaluationMasterRepository.findById((Object)id);
            if (evaluation.isPresent()) {
                toDelete.add(evaluation.get());
                continue;
            }
            response.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            response.setMessage("Record with ID " + id + " not found.");
            logger.info(response.getMessage());
            return response;
        }
        this.evaluationMasterRepository.deleteAll(toDelete);
        response.setStatus(Constants.Error.OK);
        response.setMessage("Records deleted successfully.");
        logger.info(response.getMessage());
        return response;
    }

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse response = new RequestResponse();
        Specification filters = EvaluationMasterSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if ("asc".equalsIgnoreCase(searchRequestData.getSortDirection())) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy() == null || searchRequestData.getSortBy().isEmpty() ? "id" : searchRequestData.getSortBy()}).ascending();
        } else if ("desc".equalsIgnoreCase(searchRequestData.getSortDirection())) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy() == null || searchRequestData.getSortBy().isEmpty() ? "id" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.evaluationMasterRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.evaluationMasterRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse searchResponse = new SearchResponse();
        searchResponse.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        searchResponse.setPageSize((long)page.getSize());
        searchResponse.setTotalPages((long)page.getTotalPages());
        searchResponse.setTotalRecords(page.getTotalElements());
        searchResponse.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        response.setData((Object)searchResponse);
        response.setMessage("List of Filtered Evaluations.");
        logger.info(response.getMessage());
        return response;
    }

    public List<EvaluationModel> entityToModelConversion(List<EvaluationMaster> evaluations) {
        ArrayList<EvaluationModel> models = new ArrayList<EvaluationModel>();
        if (evaluations == null || evaluations.isEmpty()) {
            return models;
        }
        for (EvaluationMaster evaluation : evaluations) {
            if (evaluation == null) continue;
            EvaluationModel model = new EvaluationModel();
            model.setId(evaluation.getId() != null ? evaluation.getId() : null);
            model.setQuestion(evaluation.getQuestion() != null ? evaluation.getQuestion() : null);
            model.setScore(evaluation.getScore() != null ? evaluation.getScore() : null);
            model.setCreatedby(evaluation.getCreatedby() != null ? evaluation.getCreatedby() : null);
            model.setUpdateby(evaluation.getUpdateby() != null ? evaluation.getUpdateby() : null);
            if (evaluation.getCreatedon() != null) {
                model.setCreatedon(evaluation.getCreatedon());
            } else {
                model.setCreatedon(null);
            }
            if (evaluation.getUpdatedon() != null) {
                model.setUpdatedon(evaluation.getUpdatedon());
            } else {
                model.setUpdatedon(null);
            }
            models.add(model);
        }
        return models;
    }
}

