/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.coralApps.callcenter.campaign.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.coralApps.callcenter.campaign.model.CampaignModel;
import com.coraltele.service.coralApps.callcenter.campaign.service.CampaignService;
import java.security.Principal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/campaign"})
@RestController
public class CampaignController {
    private static final Logger logger = LogManager.getLogger(CampaignController.class);
    @Autowired
    CampaignService campaignService;

    @PostMapping(value={"/listAll/{queue}"})
    public ResponseEntity<RequestResponse> GetAllData(@PathVariable(value="queue") Long queue, @RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.campaignService.getAllCampaignByFilterForCampaignAgainstQueue(searchRequest, queue);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> create(@RequestBody CampaignModel data, Principal principal) {
        RequestResponse returnValue = this.campaignService.createData(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllCampaignByFilter(@RequestBody SearchRequest searchRequest, @PathVariable(value="queue") Long queue) {
        RequestResponse returnValue = this.campaignService.getAllCampaignByFilter(searchRequest, queue);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateById(@RequestBody CampaignModel data) {
        RequestResponse returnValue = this.campaignService.updateById(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteCampaignById(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.campaignService.deleteCampaignById(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

