/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.cliServices.services;

import com.coraltele.db.telephony.pbx.entity.CLIServerCommandLog;
import com.coraltele.db.telephony.pbx.repository.CLIServerCommandLogRepository;
import com.coraltele.db.telephony.pbx.specification.CliServerCommandLogSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.cliServices.model.CLiServerModel;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class CliServerCommandServices {
    private static final Logger logger = LogManager.getLogger(CliServerCommandServices.class);
    private String serverCode = "s";
    private static long lastAccessTime = 0L;
    private Lock lock = new ReentrantLock();
    @Autowired
    private CLIServerCommandLogRepository cliServerCommandLogRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() {
        String fileName = "/etc/coraltelecom/callserver.manager.conf";
        Properties prop = new Properties();
        try (FileInputStream input = new FileInputStream(fileName);){
            prop.load(input);
            this.serverCode = prop.getProperty("servercode", "s");
            input.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.serverCode = "s";
        }
        finally {
            logger.info("Server code is :: {}", (Object)this.serverCode);
        }
    }

    public RequestResponse getAllApprovalCommands(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = CliServerCommandLogSpecification.generateFilters((SearchRequest)searchRequestData, (String)this.serverCode);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.cliServerCommandLogRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.cliServerCommandLogRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<CLiServerModel> entityToModelConversion(List<CLIServerCommandLog> entities) {
        ArrayList<CLiServerModel> models = new ArrayList<CLiServerModel>();
        for (CLIServerCommandLog row : entities) {
            CLiServerModel model = new CLiServerModel();
            model.setId(row.getId());
            model.setRecordCreatedOn(DateFormatUtility.formatToString((LocalDateTime)row.getRecordCreatedOn()));
            model.setRecordCreatedBy(row.getRecordCreatedBy());
            model.setOutputFileName(row.getOutputFileName());
            model.setOutputFilePath(row.getOutputFilePath());
            model.setExecutionStarted(row.getExecutionStarted());
            model.setExecutionStartTime(DateFormatUtility.formatToString((LocalDateTime)row.getExecutionStartTime()));
            model.setExecutionEndTime(DateFormatUtility.formatToString((LocalDateTime)row.getExecutionEndTime()));
            model.setExecutionCommand(row.getExecutionCommand());
            model.setExecutionDoneBy(row.getExecutionDoneBy());
            model.setFileMovedToProcessed(row.getFileMovedToProcessed());
            model.setProcessedFolderPath(row.getProcessedFolderPath());
            model.setIsError(row.getIsError());
            model.setErrorMessage(row.getErrorMessage());
            model.setRemarks(row.getRemarks());
            model.setExecuted("Pending");
            if (row.getCLICommand() != null && !row.getCLICommand().isEmpty()) {
                model.setCLICommand(this.decryptCliServiceContains(row.getCLICommand()));
            } else {
                model.setCLICommand("");
            }
            model.setRecordId(row.getRecordId());
            model.setServerCode(row.getServerCode());
            model.setRecordSource(row.getRecordSource());
            model.setApprovedBy(row.getApprovedBy());
            model.setApprovedOn(DateFormatUtility.formatToString((LocalDateTime)row.getApprovedOn()));
            model.setCommandExecutedByClientIP(row.getCommandExecutedByClientIP());
            model.setCommandExecutedOnServerIP(row.getCommandExecutedOnServerIP());
            model.setRemoteUserType(row.getRemoteUserType());
            model.setRemoteUserIP(row.getRemoteUserIP());
            model.setIsCommandSynced(row.getIsCommandSynced());
            model.setCommonOutputFileName(row.getCommonOutputFileName());
            model.setSourceServerCode(row.getSourceServerCode());
            models.add(model);
        }
        return models;
    }

    public synchronized RequestResponse approveCommand1(InputIdModel input) {
        RequestResponse response = new RequestResponse();
        String systemApprove = "system approval ";
        String apprCmd = "apprcmd";
        if (input == null || input.getStringId() == null || input.getStringId().isEmpty()) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("No command IDs provided for approval!");
            return response;
        }
        try {
            for (String commandToApprove : input.getStringId()) {
                if (commandToApprove == null || commandToApprove.trim().isEmpty()) continue;
                CLIServerCommandLog cliLog = new CLIServerCommandLog();
                cliLog.setRemarks(apprCmd);
                cliLog.setCLICommand(systemApprove + commandToApprove.trim());
                this.cliServerCommandLog2(cliLog);
            }
            response.setStatus(Constants.Error.OK);
            response.setMessage("Execution successful");
            response.setMessageDetail("All commands approved successfully.");
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(Constants.Error.ERROR);
            logger.error("Error while approving command {}", (Object)e.getMessage());
            response.setMessage("Execution successful");
            response.setMessageDetail("Error approving commands: " + e.getMessage());
        }
        return response;
    }

    public synchronized RequestResponse approveCommand(InputIdModel input) {
        RequestResponse response = new RequestResponse();
        String systemApprove = "system approval ";
        String apprCmd = "apprcmd";
        if (input == null || input.getStringId() == null || input.getStringId().isEmpty()) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("No command IDs provided for approval!");
            return response;
        }
        try {
            ArrayList<String> createdCommands = new ArrayList<String>();
            for (String commandToApprove : input.getStringId()) {
                if (commandToApprove == null || commandToApprove.trim().isEmpty()) continue;
                CLIServerCommandLog cliLog = new CLIServerCommandLog();
                cliLog.setRemarks(apprCmd);
                cliLog.setCLICommand(systemApprove + commandToApprove.trim());
                String command = this.cliServerCommandLog2(cliLog);
                createdCommands.add(command);
            }
            for (String command : createdCommands) {
                boolean executed = this.waitUntilExecuted(command, 30000L);
                if (executed) continue;
                response.setStatus(Constants.Error.ERROR);
                response.setMessage("Timeout while waiting for command execution");
                response.setMessageDetail("Command [" + command + "] did not finish in time.");
                return response;
            }
            response.setStatus(Constants.Error.OK);
            response.setMessage("Execution successful");
            response.setMessageDetail("All commands approved and executed successfully.");
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(Constants.Error.ERROR);
            logger.error("Error while approving command {}", (Object)e.getMessage());
            response.setMessage("Error while approving commands");
            response.setMessageDetail("Error approving commands: " + e.getMessage());
        }
        return response;
    }

    private boolean waitUntilExecuted(String outputFileName, long timeoutMillis) {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < timeoutMillis) {
            Optional logOpt = this.cliServerCommandLogRepository.findByOutputFileName(outputFileName);
            if (logOpt.isPresent() && "Y".equalsIgnoreCase(((CLIServerCommandLog)logOpt.get()).getExecuted())) {
                return true;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return false;
    }

    public synchronized RequestResponse rejectCommand(InputIdModel input) {
        RequestResponse response = new RequestResponse();
        String systemReject = "system rejected ";
        if (input == null || input.getStringId() == null || input.getStringId().isEmpty()) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("No command IDs provided for rejection!");
            return response;
        }
        try {
            ArrayList<String> createdCommands = new ArrayList<String>();
            for (String commandToReject : input.getStringId()) {
                if (commandToReject == null || commandToReject.trim().isEmpty()) continue;
                CLIServerCommandLog cliLog = new CLIServerCommandLog();
                cliLog.setCLICommand(systemReject + commandToReject.trim());
                String command = this.cliServerCommandLog2(cliLog);
                createdCommands.add(command);
            }
            for (String command : createdCommands) {
                boolean executed = this.waitUntilExecuted(command, 30000L);
                if (executed) continue;
                response.setStatus(Constants.Error.ERROR);
                response.setMessage("Timeout while waiting for command rejection");
                response.setMessageDetail("Command [" + command + "] did not finish in time.");
                return response;
            }
            response.setStatus(Constants.Error.OK);
            response.setMessage("Execution successful");
            response.setMessageDetail("All commands rejected and processed successfully.");
        }
        catch (Exception e) {
            logger.error("Error while rejecting commands", (Throwable)e);
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Error while rejecting commands");
            response.setMessageDetail("Error rejecting commands: " + e.getMessage());
        }
        return response;
    }

    public String decryptCliServiceContains(String encryptedValue) {
        String rtrVal = "";
        try {
            String privatekey = "9221375a0cd0-5adb3f6d--f6ea-4d1e-81ed-a719175d-1e40-dd24b91a7c87-c5600ed3";
            byte[] key = privatekey.getBytes("UTF-8");
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            key = sha.digest(key);
            key = Arrays.copyOf(key, 16);
            SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(2, secretKey);
            byte[] decodedValue = Base64.getDecoder().decode(encryptedValue);
            byte[] original = cipher.doFinal(decodedValue);
            rtrVal = new String(original, "UTF-8");
        }
        catch (Exception e) {
            logger.error("Decryption failed: {}", (Object)e.getMessage(), (Object)e);
        }
        return rtrVal;
    }

    protected String encryptCliServiceContains(String keyvalue) {
        String rtrVal = "";
        if (!keyvalue.isEmpty()) {
            String privatekey;
            MessageDigest sha = null;
            String passwordkey = privatekey = "9221375a0cd0-5adb3f6d--f6ea-4d1e-81ed-a719175d-1e40-dd24b91a7c87-c5600ed3";
            try {
                byte[] key = passwordkey.getBytes("UTF-8");
                sha = MessageDigest.getInstance("SHA-1");
                key = sha.digest(key);
                key = Arrays.copyOf(key, 16);
                SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
                Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
                cipher.init(1, secretKey);
                byte[] rtv = cipher.doFinal(keyvalue.getBytes("UTF-8"));
                rtrVal = Base64.getEncoder().encodeToString(rtv);
            }
            catch (NoSuchAlgorithmException e) {
                logger.error(e.getMessage());
            }
            catch (UnsupportedEncodingException e) {
                logger.error(e.getMessage());
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        return rtrVal;
    }

    public synchronized String cliServerCommandLog2(CLIServerCommandLog cliServerCommandLog) {
        try {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            String clientIp = CliServerCommandServices.getCurrentUserIp((Authentication)authentication);
            long currentTime = System.currentTimeMillis();
            if (currentTime == lastAccessTime) {
                Thread.sleep(1L);
                logger.info("Time conflict comes but handled");
            }
            lastAccessTime = System.currentTimeMillis();
            String ip = CliServerCommandServices.getLocalIPAddress();
            Long epochValue = lastAccessTime;
            String fileName = epochValue + "-" + this.serverCode;
            CLIServerCommandLog cliServerCommandLog2 = new CLIServerCommandLog();
            cliServerCommandLog2.setRecordCreatedBy(CliServerCommandServices.getCurrentUsername());
            cliServerCommandLog2.setOutputFileName(fileName);
            cliServerCommandLog2.setOutputFilePath("");
            cliServerCommandLog2.setCLICommand(this.encryptCliServiceContains(cliServerCommandLog.getCLICommand()));
            cliServerCommandLog2.setServerCode(this.serverCode);
            if (cliServerCommandLog.getCLICommand().contains("delete")) {
                cliServerCommandLog2.setExecuted("P");
            } else {
                cliServerCommandLog2.setExecuted("N");
            }
            cliServerCommandLog2.setCommandExecutedByClientIP(clientIp);
            cliServerCommandLog2.setCommandExecutedOnServerIP(ip);
            cliServerCommandLog2.setRemarks(cliServerCommandLog.getRemarks());
            CLIServerCommandLog returnCliServerCommand = (CLIServerCommandLog)this.cliServerCommandLogRepository.save((Object)cliServerCommandLog2);
            return returnCliServerCommand.getOutputFileName();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            System.err.println("Thread was interrupted: " + e.getMessage());
            logger.error(e.getMessage());
            return "";
        }
        catch (Exception e) {
            logger.error("Unexpected error while saving CLI command: {}", (Object)e.getMessage(), (Object)e);
            return "";
        }
    }

    public static String getCurrentUsername() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication.isAuthenticated()) {
            return authentication.getName();
        }
        return null;
    }

    public static String getCurrentUserIp(Authentication authentication) {
        if (authentication != null && authentication.getDetails() instanceof WebAuthenticationDetails) {
            WebAuthenticationDetails authDetails = (WebAuthenticationDetails)authentication.getDetails();
            String remoteIP = authDetails.getRemoteAddress();
            return remoteIP != null ? remoteIP : "127.0.0.1";
        }
        return "127.0.0.1";
    }

    public static String getLocalIPAddress() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                if (!networkInterface.isUp() || networkInterface.isLoopback()) continue;
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (!(inetAddress instanceof Inet4Address)) continue;
                    return inetAddress.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return null;
    }

    public RequestResponse createIniFile(String jsonData) {
        RequestResponse response = new RequestResponse();
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            Map data = (Map)objectMapper.readValue(jsonData, LinkedHashMap.class);
            StringBuilder iniContent = new StringBuilder();
            String[] orderedSections = new String[]{"CLUSTER", "IMS-V2", "NMS", "LDAP", "EMAIL", "SMS", "MOBILITY", "PPDR-CONFERENCE", "MAP", "BANDWIDTH", "SNMP-AGENT", "IP-MONITOR"};
            String[] arraySections = new String[]{"CSCF", "NODE", "ROUTE", "WAN", "ISP"};
            LinkedHashMap<String, Integer> arrayCounts = new LinkedHashMap<String, Integer>();
            for (String arraySection : arraySections) {
                Object value = data.get(arraySection);
                if (value instanceof List) {
                    arrayCounts.put(arraySection, ((List)value).size());
                    continue;
                }
                arrayCounts.put(arraySection, 0);
            }
            for (String section : orderedSections) {
                Object sectionData = data.get(section);
                if (sectionData == null) continue;
                iniContent.append("[").append(section).append("]\n");
                if (sectionData instanceof Map) {
                    Map sectionMap = (Map)sectionData;
                    if ("CLUSTER".equals(section)) {
                        for (Map.Entry entry : sectionMap.entrySet()) {
                            String key = (String)entry.getKey();
                            Object value = entry.getValue();
                            if ("Nodes".equals(key) && arrayCounts.containsKey("NODE")) {
                                iniContent.append(key).append("=").append(arrayCounts.get("NODE")).append("\n");
                                continue;
                            }
                            if ("CSCF".equals(key) && arrayCounts.containsKey("CSCF")) {
                                iniContent.append(key).append("=").append(arrayCounts.get("CSCF")).append("\n");
                                continue;
                            }
                            if ("ROUTES".equals(key) && arrayCounts.containsKey("ROUTE")) {
                                iniContent.append(key).append("=").append(arrayCounts.get("ROUTE")).append("\n");
                                continue;
                            }
                            if ("WANS".equals(key) && arrayCounts.containsKey("WAN")) {
                                iniContent.append(key).append("=").append(arrayCounts.get("WAN")).append("\n");
                                continue;
                            }
                            if ("ISP".equals(key) && arrayCounts.containsKey("ISP")) {
                                iniContent.append(key).append("=").append(arrayCounts.get("ISP")).append("\n");
                                continue;
                            }
                            iniContent.append(key).append("=").append(value != null ? value : "").append("\n");
                        }
                    } else {
                        for (Map.Entry entry : sectionMap.entrySet()) {
                            iniContent.append((String)entry.getKey()).append("=").append(entry.getValue() != null ? entry.getValue() : "").append("\n");
                        }
                    }
                }
                iniContent.append("\n");
            }
            for (String arraySection : arraySections) {
                Object arrayData = data.get(arraySection);
                if (!(arrayData instanceof List)) continue;
                List arrayList = (List)arrayData;
                for (int i = 0; i < arrayList.size(); ++i) {
                    Map element = (Map)arrayList.get(i);
                    iniContent.append("[").append(arraySection).append("-").append(i + 1).append("]\n");
                    for (Map.Entry entry : element.entrySet()) {
                        iniContent.append((String)entry.getKey()).append("=").append(entry.getValue() != null ? entry.getValue() : "").append("\n");
                    }
                    iniContent.append("\n");
                }
            }
            String filePath = "/etc/default/coral.wip";
            try (FileWriter writer = new FileWriter(filePath);){
                writer.write(iniContent.toString());
                logger.info("INI file created successfully at: {}", (Object)filePath);
            }
            catch (IOException e) {
                logger.warn("Could not write to file: {}. Returning content in response.", (Object)filePath, (Object)e);
            }
            response.setStatus(Constants.Error.OK);
            response.setMessage("INI file generated successfully");
            LinkedHashMap counts = new LinkedHashMap();
            counts.put("Nodes", arrayCounts.get("NODE"));
            counts.put("CSCF", arrayCounts.get("CSCF"));
            counts.put("ROUTES", arrayCounts.get("ROUTE"));
            counts.put("WANS", arrayCounts.get("WAN"));
            counts.put("ISP", arrayCounts.get("ISP"));
            LinkedHashMap<String, Object> responseData = new LinkedHashMap<String, Object>();
            responseData.put("filePath", filePath);
            responseData.put("content", iniContent.toString());
            responseData.put("counts", counts);
            response.setData(responseData);
        }
        catch (Exception e) {
            logger.error("Error creating INI file", (Throwable)e);
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Error creating INI file: " + e.getMessage());
        }
        return response;
    }

    public RequestResponse readConfigFile() {
        RequestResponse response = new RequestResponse();
        String filePath = "/etc/default/coral.wip";
        try {
            if (!Files.exists(Paths.get(filePath, new String[0]), new LinkOption[0])) {
                response.setStatus(Constants.Error.ERROR);
                response.setMessage("Configuration file not found: " + filePath);
                logger.warn("Configuration file not found: {}", (Object)filePath);
                return response;
            }
            StringBuilder content = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
                String line;
                while ((line = reader.readLine()) != null) {
                    content.append(line).append("\n");
                }
            }
            logger.info("Successfully read configuration file: {}", (Object)filePath);
            response.setStatus(Constants.Error.OK);
            response.setMessage("Configuration file read successfully");
            LinkedHashMap<String, Object> responseData = new LinkedHashMap<String, Object>();
            responseData.put("filePath", filePath);
            responseData.put("content", content.toString());
            responseData.put("lineCount", content.toString().split("\n").length);
            response.setData(responseData);
        }
        catch (IOException e) {
            logger.error("Error reading configuration file: {}", (Object)filePath, (Object)e);
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Error reading configuration file: " + e.getMessage());
        }
        catch (Exception e) {
            logger.error("Unexpected error reading configuration file: {}", (Object)filePath, (Object)e);
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Unexpected error: " + e.getMessage());
        }
        return response;
    }

    public RequestResponse readIniAsJson() {
        RequestResponse response = new RequestResponse();
        String filePath = "/etc/default/coral.wip";
        try {
            String[] arrayOrder;
            String[] orderedSections;
            if (!Files.exists(Paths.get(filePath, new String[0]), new LinkOption[0])) {
                response.setStatus(Constants.Error.ERROR);
                response.setMessage("INI file not found: " + filePath);
                logger.warn("INI file not found: {}", (Object)filePath);
                return response;
            }
            boolean filesAreSame = this.compareIniFiles("/etc/default/coral.wip", "/etc/default/coral");
            LinkedHashMap jsonData = new LinkedHashMap();
            LinkedHashMap regularSections = new LinkedHashMap();
            LinkedHashMap arraySections = new LinkedHashMap();
            String currentSection = null;
            String currentBaseName = null;
            int currentIndex = -1;
            boolean isArraySection = false;
            String[] stringArray = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty() || line.startsWith("#") || line.startsWith(";")) continue;
                    if (line.startsWith("[") && line.endsWith("]")) {
                        currentSection = line.substring(1, line.length() - 1);
                        if (currentSection.matches(".*-\\d+$")) {
                            isArraySection = true;
                            int lastDash = currentSection.lastIndexOf("-");
                            currentBaseName = currentSection.substring(0, lastDash);
                            currentIndex = Integer.parseInt(currentSection.substring(lastDash + 1));
                            if (!arraySections.containsKey(currentBaseName)) {
                                arraySections.put(currentBaseName, new ArrayList());
                            }
                            ((List)arraySections.get(currentBaseName)).add(new LinkedHashMap());
                            continue;
                        }
                        isArraySection = false;
                        currentBaseName = currentSection;
                        regularSections.put(currentSection, new LinkedHashMap());
                        continue;
                    }
                    if (!line.contains("=")) continue;
                    int equalIndex = line.indexOf("=");
                    String key = line.substring(0, equalIndex).trim();
                    String value = line.substring(equalIndex + 1).trim();
                    if (currentSection == null) continue;
                    if (isArraySection) {
                        List arrayList = (List)arraySections.get(currentBaseName);
                        if (arrayList.isEmpty()) continue;
                        ((Map)arrayList.get(arrayList.size() - 1)).put(key, value);
                        continue;
                    }
                    ((Map)regularSections.get(currentSection)).put(key, value);
                }
            }
            catch (Throwable line) {
                stringArray = line;
                throw line;
            }
            for (String section : orderedSections = new String[]{"CLUSTER", "IMS-V2", "NMS", "LDAP", "EMAIL", "SMS", "MOBILITY", "PPDR-CONFERENCE", "MAP", "BANDWIDTH", "SNMP-AGENT", "IP-MONITOR"}) {
                if (!regularSections.containsKey(section)) continue;
                jsonData.put(section, regularSections.get(section));
            }
            if (regularSections.containsKey("CLUSTER")) {
                Map cluster = (Map)regularSections.get("CLUSTER");
                if (arraySections.containsKey("NODE")) {
                    cluster.put("Nodes", String.valueOf(((List)arraySections.get("NODE")).size()));
                }
                if (arraySections.containsKey("CSCF")) {
                    cluster.put("CSCF", String.valueOf(((List)arraySections.get("CSCF")).size()));
                }
                if (arraySections.containsKey("ROUTE")) {
                    cluster.put("ROUTES", String.valueOf(((List)arraySections.get("ROUTE")).size()));
                }
                if (arraySections.containsKey("WAN")) {
                    cluster.put("WANS", String.valueOf(((List)arraySections.get("WAN")).size()));
                }
                if (arraySections.containsKey("ISP")) {
                    cluster.put("ISP", String.valueOf(((List)arraySections.get("ISP")).size()));
                }
            }
            for (String arrayName : arrayOrder = new String[]{"CSCF", "NODE", "ROUTE", "WAN", "ISP"}) {
                if (!arraySections.containsKey(arrayName)) continue;
                jsonData.put(arrayName, arraySections.get(arrayName));
            }
            logger.info("Successfully converted INI file to JSON: {}", (Object)filePath);
            LinkedHashMap<String, Object> metadata = new LinkedHashMap<String, Object>();
            metadata.put("filesAreSame", filesAreSame);
            metadata.put("sourceFile", filePath);
            LinkedHashMap<String, LinkedHashMap<String, Object>> responseData = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
            responseData.put("metadata", metadata);
            responseData.put("currentConfigurations", jsonData);
            response.setStatus(Constants.Error.OK);
            response.setMessage("INI file converted to JSON successfully");
            response.setData(responseData);
        }
        catch (IOException e) {
            logger.error("Error reading INI file: {}", (Object)filePath, (Object)e);
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Error reading INI file: " + e.getMessage());
        }
        catch (Exception e) {
            logger.error("Unexpected error converting INI to JSON: {}", (Object)filePath, (Object)e);
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Unexpected error: " + e.getMessage());
        }
        return response;
    }

    private boolean compareIniFiles(String file1Path, String file2Path) {
        try {
            if (!Files.exists(Paths.get(file1Path, new String[0]), new LinkOption[0]) || !Files.exists(Paths.get(file2Path, new String[0]), new LinkOption[0])) {
                logger.info("One or both files do not exist for comparison");
                return false;
            }
            List<String> file1Lines = Files.readAllLines(Paths.get(file1Path, new String[0]));
            List<String> file2Lines = Files.readAllLines(Paths.get(file2Path, new String[0]));
            List normalizedFile1 = file1Lines.stream().map(String::trim).filter(line -> !line.isEmpty() && !line.startsWith("#") && !line.startsWith(";")).collect(Collectors.toList());
            List normalizedFile2 = file2Lines.stream().map(String::trim).filter(line -> !line.isEmpty() && !line.startsWith("#") && !line.startsWith(";")).collect(Collectors.toList());
            boolean areEqual = normalizedFile1.equals(normalizedFile2);
            logger.info("File comparison result: {} vs {} = {}", (Object)file1Path, (Object)file2Path, (Object)areEqual);
            return areEqual;
        }
        catch (IOException e) {
            logger.error("Error comparing INI files: {} and {}", (Object)file1Path, (Object)file2Path, (Object)e);
            return false;
        }
    }

    public RequestResponse executeNodeControlCommand() {
        RequestResponse response = new RequestResponse();
        try {
            String line;
            logger.info("Executing node-control command: node-control execute --system-function=configure-node");
            ArrayList<String> command = new ArrayList<String>();
            command.add("node-control");
            command.add("execute");
            command.add("--system-function=configure-node");
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            StringBuilder output = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                output.append(line).append("\n");
                logger.info("Command output: {}", (Object)line);
            }
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                logger.info("Node control command executed successfully");
                response.setStatus(Constants.Error.OK);
                response.setMessage("Node control command executed successfully");
                response.setData((Object)output.toString());
            } else {
                logger.error("Node control command failed with exit code: {}", (Object)exitCode);
                response.setStatus(Constants.Error.ERROR);
                response.setMessage("Node control command failed with exit code: " + exitCode);
                response.setData((Object)output.toString());
            }
        }
        catch (IOException e) {
            logger.error("Error executing node control command: {}", (Object)e.getMessage(), (Object)e);
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Error executing command: " + e.getMessage());
        }
        catch (InterruptedException e) {
            logger.error("Node control command was interrupted: {}", (Object)e.getMessage(), (Object)e);
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Command execution was interrupted: " + e.getMessage());
            Thread.currentThread().interrupt();
        }
        return response;
    }
}

