/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.billing.main.fax.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.FileUploadResponse;
import com.coraltele.helper.IVRUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.billing.main.fax.model.FaxTransferDetailsModel;
import com.coraltele.service.billing.main.fax.service.FaxService;
import com.coraltele.service.billing.main.notification.service.NotificationService;
import com.coraltele.service.pbx.emailDetail.model.CustomEmailDetailModel;
import com.coraltele.service.uc.service.FaxTransferDetailsService;
import com.coraltele.service.uc.service.UCService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.text.MessageFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/v2/fax"})
public class FaxController {
    private static final Logger logger = LogManager.getLogger(FaxController.class);
    private static final String CONTROLLER_NAME = "Fax";
    String message;
    @Autowired
    FaxService faxService;
    @Autowired
    UCService ucService;
    @Autowired
    IVRUtility iVRUtility;
    @Autowired
    NotificationService notificationService;
    @Autowired
    FaxTransferDetailsService sendFaxProgressService;

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getList(Authentication authentication, @RequestBody SearchRequest searchRequest) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String dataReceived = objectMapper.writeValueAsString((Object)searchRequest);
            this.message = MessageFormat.format("{1} get list : {0}", CONTROLLER_NAME, dataReceived);
            logger.info(this.message);
            RequestResponse returnValue = this.faxService.getFaxUserData(authentication, searchRequest);
            if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                this.message = MessageFormat.format("{1} data processed successfully for getting list : {0}", CONTROLLER_NAME, dataReceived);
                logger.info(this.message);
                return ResponseEntity.ok((Object)returnValue);
            }
            this.message = MessageFormat.format("{1} unable to process data for getting list: {0}", CONTROLLER_NAME, dataReceived);
            logger.info(this.message);
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
        catch (JsonProcessingException e) {
            RequestResponse returnValue = new RequestResponse();
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Invalid json data");
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateNotification(@RequestBody InputIdModel data) {
        RequestResponse returnValue = this.faxService.readFax(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteData(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.faxService.deleteNotification(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/transfer"})
    public ResponseEntity<RequestResponse> createFaxTransferDetailsController(Authentication authentication, @RequestBody FaxTransferDetailsModel data) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String dataReceived = objectMapper.writeValueAsString((Object)data);
            String message = MessageFormat.format("{1} create : {0}", CONTROLLER_NAME, dataReceived);
            logger.info(message);
            RequestResponse returnValue = this.faxService.createFaxTransferDetailNew(data, authentication);
            if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                message = MessageFormat.format("{1} data processed successfully for creation : {0}", CONTROLLER_NAME, dataReceived);
                logger.info(message);
                return ResponseEntity.ok((Object)returnValue);
            }
            message = MessageFormat.format("{1} unable to process data for creation: {0}", CONTROLLER_NAME, dataReceived);
            logger.info(message);
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
        catch (JsonProcessingException e) {
            RequestResponse returnValue = new RequestResponse();
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Invalid json data");
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
    }

    @PostMapping(value={"/unLoggedUser/list"})
    public ResponseEntity<RequestResponse> getUnLoggedUser(Authentication authentication) {
        RequestResponse returnValue = this.faxService.getUnLoggedUser(authentication.getName());
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/upload"})
    public ResponseEntity<RequestResponse> upload(@RequestParam(value="file") MultipartFile multipartFile, @RequestParam(value="extension") String extension, Authentication authentication) throws IOException {
        long size = multipartFile.getSize();
        String[] data = extension.replace("[", "").replace("]", "").replace("\"", "").split(",");
        RequestResponse returnValue = this.faxService.faxInitiation(multipartFile, authentication.getName(), data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            FileUploadResponse response = new FileUploadResponse();
            response.setFileName((String)returnValue.getData());
            response.setSize(size);
            response.setDownloadUri("/services/api/v2/fax/download/" + response.getFileName());
            returnValue.setData((Object)response);
            return new ResponseEntity((Object)returnValue, HttpStatus.OK);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/mailTransfer"})
    public ResponseEntity<RequestResponse> create(@RequestBody CustomEmailDetailModel data, Authentication authentication) {
        RequestResponse returnValue = this.faxService.emailTransfer(data, authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

