/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.archiving.billingCdrHistorical.controller;

import com.coraltele.db.telephony.pbx.entity.NodeConfiguration;
import com.coraltele.db.telephony.pbx.repository.NodeConfigurationRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.archiving.billingCdrHistorical.model.RestoreResult;
import com.coraltele.service.archiving.billingCdrHistorical.service.TableDumpService;
import com.coraltele.service.archiving.billingCdrHistorical.service.TableRestoreService;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping(value={"/api/v2/node-sync"})
public class NodeSyncController {
    private static final Logger logger = LoggerFactory.getLogger(NodeSyncController.class);
    @Autowired
    private TableDumpService tableDumpService;
    @Autowired
    private TableRestoreService tableRestoreService;
    @Autowired
    private NodeConfigurationRepository nodeConfigurationRepository;

    private Properties loadGitProperties() {
        Properties properties = new Properties();
        try (InputStream input = this.getClass().getClassLoader().getResourceAsStream("git.properties");){
            if (input != null) {
                properties.load(input);
            } else {
                logger.warn("git.properties not found");
            }
        }
        catch (IOException e) {
            logger.error("Error loading git.properties: {}", (Object)e.getMessage());
        }
        return properties;
    }

    @GetMapping(value={"/list"})
    public ResponseEntity<RequestResponse> listDumpedFiles() {
        RequestResponse response = new RequestResponse();
        try {
            Path dumpDirectory = Paths.get(Constants.CONFIG_ARCHIVE_PATH, new String[0]);
            if (!Files.exists(dumpDirectory, new LinkOption[0]) || !Files.isDirectory(dumpDirectory, new LinkOption[0])) {
                response.setStatus(Constants.Error.ERROR);
                response.setMessage("Dump directory does not exist");
                return new ResponseEntity((Object)response, HttpStatus.NOT_FOUND);
            }
            Map fileList = this.tableDumpService.listDumpedFiles(dumpDirectory);
            response.setStatus(Constants.Error.OK);
            response.setData((Object)fileList);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("Error listing dumped files: {}", (Object)e.getMessage(), (Object)e);
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Error listing dumped files: " + e.getMessage());
            return new ResponseEntity((Object)response, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteFile(@RequestParam String filePath) {
        RequestResponse response = new RequestResponse();
        try {
            Path path = Paths.get(filePath, new String[0]);
            if (!Files.exists(path, new LinkOption[0]) || !Files.isRegularFile(path, new LinkOption[0])) {
                response.setStatus(Constants.Error.ERROR);
                response.setMessage("File not found");
                return new ResponseEntity((Object)response, HttpStatus.NOT_FOUND);
            }
            Files.delete(path);
            response.setStatus(Constants.Error.OK);
            response.setMessage("Backup File deleted successfully");
            return ResponseEntity.ok((Object)response);
        }
        catch (IOException e) {
            logger.error("Error deleting file: {}", (Object)e.getMessage(), (Object)e);
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Error deleting file: " + e.getMessage());
            return new ResponseEntity((Object)response, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/commit"})
    public ResponseEntity<RequestResponse> dumpTables(@RequestParam(value="configName", required=false) String configName, @RequestParam(value="syncNow") boolean syncNow) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        String configId = UUID.randomUUID().toString();
        try {
            Path filePath;
            Path directory;
            Properties gitProps = this.loadGitProperties();
            String gitBuildId = gitProps.getProperty("git.commit.id.abbrev", "");
            String gitBuildTime = gitProps.getProperty("git.build.time", "");
            String gitBuildVersion = gitProps.getProperty("git.build.version", "");
            String gitBranch = gitProps.getProperty("git.branch", "");
            String finalBuildId = gitBuildId;
            String outputPath = Constants.CONFIG_ARCHIVE_PATH + "/" + configId + ".json";
            String finalConfigName = configName;
            if (finalConfigName == null || finalConfigName.trim().equals("") || finalConfigName.trim().equals("\"\"")) {
                finalConfigName = "Config_" + System.currentTimeMillis();
            }
            if ((directory = (filePath = Paths.get(outputPath, new String[0])).getParent()) != null && !Files.exists(directory, new LinkOption[0])) {
                Files.createDirectories(directory, new FileAttribute[0]);
                logger.info("Created directory: {}", (Object)directory);
            }
            logger.info("Starting table dump to: {}", (Object)outputPath);
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("configId", configId);
            metadata.put("buildId", finalBuildId);
            metadata.put("buildTime", gitBuildTime);
            metadata.put("buildVersion", gitBuildVersion);
            metadata.put("gitBranch", gitBranch);
            metadata.put("configName", finalConfigName);
            Map dumpResult = this.tableDumpService.dumpAllTables(outputPath, metadata);
            response.put("success", true);
            response.put("message", "Tables dumped successfully");
            response.put("metadata", metadata);
            response.put("outputPath", outputPath);
            response.put("summary", dumpResult);
            if (syncNow) {
                logger.info("SyncNow is true, initiating immediate sync to other nodes.");
                return this.restoreTables(configId, Boolean.valueOf(true));
            }
            RequestResponse returnValue = new RequestResponse();
            returnValue.setStatus(Constants.Error.OK);
            return ResponseEntity.ok((Object)returnValue);
        }
        catch (IOException e) {
            logger.error("Error during table dump: {}", (Object)e.getMessage(), (Object)e);
            response.put("success", false);
            response.put("message", "Error dumping tables: " + e.getMessage());
            response.put("error", e.getClass().getSimpleName());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/apply"})
    public ResponseEntity<RequestResponse> restoreTables(@RequestParam String inputPath, @RequestParam(required=false) Boolean syncOthersOnly) {
        String currentHostName;
        logger.info("Starting configuration restore for input path: {} with syncOthersOnly: {}", (Object)inputPath, (Object)syncOthersOnly);
        RequestResponse response = new RequestResponse();
        try {
            currentHostName = InetAddress.getLocalHost().getHostName();
            logger.info("Received restore request from host: {} for input path: {}", (Object)currentHostName, (Object)inputPath);
        }
        catch (UnknownHostException e) {
            logger.error("Unable to get hostname: {}", (Object)e.getMessage());
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Unable to get hostname: " + e.getMessage());
            return new ResponseEntity((Object)response, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        try {
            String fileName = Constants.CONFIG_ARCHIVE_PATH + "/" + inputPath + ".json";
            Path filePath = Paths.get(fileName, new String[0]);
            if (!Files.exists(filePath, new LinkOption[0])) {
                response.setStatus(Constants.Error.ERROR);
                response.setMessage("Configuration file not found: " + inputPath);
                return new ResponseEntity((Object)response, HttpStatus.NOT_FOUND);
            }
            String jsonContent = new String(Files.readAllBytes(filePath));
            ArrayList nodeResults = new ArrayList();
            ArrayList<String> errors = new ArrayList<String>();
            int successNodes = 0;
            int failedNodes = 0;
            for (NodeConfiguration node : this.nodeConfigurationRepository.findAll()) {
                String errorMsg;
                if (node.getNodeName().equalsIgnoreCase(currentHostName) && Boolean.TRUE.equals(syncOthersOnly)) {
                    logger.info("Skipping local node: {}", (Object)node.getNodeName());
                    continue;
                }
                String nodeIp = node.getNodeIp();
                String nodeName = node.getNodeName();
                logger.info("Pushing configuration to node: {} at IP: {}", (Object)nodeName, (Object)nodeIp);
                HashMap<String, Object> nodeResult = new HashMap<String, Object>();
                nodeResult.put("nodeName", nodeName);
                nodeResult.put("nodeIp", nodeIp);
                try {
                    String restoreUrl = String.format("http://%s/services/api/v2/node-sync/restore-local", nodeIp);
                    HttpHeaders headers = new HttpHeaders();
                    headers.setContentType(MediaType.APPLICATION_JSON);
                    headers.set("Authorization", "Cluster " + Constants.CLUSTER_KEY);
                    HttpEntity entity = new HttpEntity((Object)jsonContent, (MultiValueMap)headers);
                    RestTemplate restTemplate = new RestTemplate();
                    SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
                    factory.setConnectTimeout(30000);
                    factory.setReadTimeout(300000);
                    restTemplate.setRequestFactory((ClientHttpRequestFactory)factory);
                    ResponseEntity nodeResponse = restTemplate.postForEntity(restoreUrl, (Object)entity, Map.class, new Object[0]);
                    if (nodeResponse.getStatusCode().is2xxSuccessful()) {
                        nodeResult.put("success", true);
                        nodeResult.put("response", nodeResponse.getBody());
                        ++successNodes;
                        logger.info("Successfully restored to node: {}", (Object)nodeName);
                    } else {
                        nodeResult.put("success", false);
                        nodeResult.put("error", "HTTP " + nodeResponse.getStatusCodeValue());
                        errors.add("Node " + nodeName + ": HTTP " + nodeResponse.getStatusCodeValue());
                        ++failedNodes;
                    }
                }
                catch (ResourceAccessException e) {
                    errorMsg = "Connection failed: " + e.getMessage();
                    nodeResult.put("success", false);
                    nodeResult.put("error", errorMsg);
                    errors.add("Node " + nodeName + " (" + nodeIp + "): " + errorMsg);
                    ++failedNodes;
                    logger.error("Failed to connect to node {}: {}", (Object)nodeName, (Object)e.getMessage());
                }
                catch (Exception e) {
                    errorMsg = e.getMessage();
                    nodeResult.put("success", false);
                    nodeResult.put("error", errorMsg);
                    errors.add("Node " + nodeName + " (" + nodeIp + "): " + errorMsg);
                    ++failedNodes;
                    logger.error("Failed to restore to node {}: {}", new Object[]{nodeName, e.getMessage(), e});
                }
                nodeResults.add(nodeResult);
            }
            HashMap<String, Object> responseData = new HashMap<String, Object>();
            responseData.put("configId", inputPath);
            responseData.put("sourceNode", currentHostName);
            responseData.put("successNodes", successNodes);
            responseData.put("failedNodes", failedNodes);
            responseData.put("nodeResults", nodeResults);
            if (!errors.isEmpty()) {
                responseData.put("errors", errors);
            }
            if (failedNodes == 0 && successNodes > 0) {
                response.setStatus(Constants.Error.OK);
                response.setMessage("Configuration restored successfully to all nodes");
            } else if (successNodes > 0) {
                response.setStatus(Constants.Error.OK);
                response.setMessage("Configuration restored with some failures");
                response.setMessageDetail(failedNodes + " node(s) failed");
            } else if (successNodes == 0 && failedNodes == 0) {
                response.setStatus(Constants.Error.OK);
                response.setMessage("No remote nodes to restore to");
            } else {
                response.setStatus(Constants.Error.ERROR);
                response.setMessage("Configuration restore failed to all nodes");
                response.setMessageDetail(String.join((CharSequence)"; ", errors.subList(0, Math.min(3, errors.size()))));
            }
            response.setData(responseData);
            return ResponseEntity.ok((Object)response);
        }
        catch (IOException e) {
            logger.error("Failed to read configuration file: {}", (Object)e.getMessage(), (Object)e);
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Failed to read configuration file: " + e.getMessage());
            return new ResponseEntity((Object)response, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            logger.error("Database restore failed with exception", (Throwable)e);
            RequestResponse errorResponse = new RequestResponse();
            errorResponse.setStatus(Constants.Error.ERROR);
            errorResponse.setMessage("Database restore failed: " + e.getMessage());
            return new ResponseEntity((Object)errorResponse, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/restore-local"})
    public ResponseEntity<RequestResponse> restoreTablesLocal(@RequestBody Map<String, Object> dumpData) {
        String hostName;
        RequestResponse response = new RequestResponse();
        try {
            hostName = InetAddress.getLocalHost().getHostName();
            logger.info("Received local restore request on host: {}", (Object)hostName);
        }
        catch (UnknownHostException e) {
            hostName = "unknown";
            logger.warn("Could not determine hostname: {}", (Object)e.getMessage());
        }
        try {
            if (dumpData == null || dumpData.isEmpty()) {
                response.setStatus(Constants.Error.ERROR);
                response.setMessage("No data provided for restore");
                return new ResponseEntity((Object)response, HttpStatus.BAD_REQUEST);
            }
            Map metadata = (Map)dumpData.get("metadata");
            if (metadata != null) {
                logger.info("Restoring configuration: {} (configId: {}, buildVersion: {})", new Object[]{metadata.get("configName"), metadata.get("configId"), metadata.get("buildVersion")});
            }
            RestoreResult result = this.tableRestoreService.restoreAllTablesFromData(dumpData);
            HashMap<String, Object> responseData = new HashMap<String, Object>();
            responseData.put("hostname", hostName);
            responseData.put("ipAddress", result.getIpAddress());
            responseData.put("port", result.getPort());
            responseData.put("connectionSuccess", result.isConnectionSuccess());
            responseData.put("durationMs", result.getDurationMs());
            responseData.put("totalTables", result.getTotalTables());
            responseData.put("successCount", result.getSuccessCount());
            responseData.put("failureCount", result.getFailureCount());
            responseData.put("skippedCount", result.getSkippedCount());
            ArrayList tableDetails = new ArrayList();
            for (RestoreResult.TableRestoreResult tableResult : result.getTableResults()) {
                HashMap<String, Object> tableInfo = new HashMap<String, Object>();
                tableInfo.put("table", tableResult.getFullTableName());
                tableInfo.put("success", tableResult.isSuccess());
                tableInfo.put("insertCount", tableResult.getInsertCount());
                tableInfo.put("updateCount", tableResult.getUpdateCount());
                tableInfo.put("deleteCount", tableResult.getDeleteCount());
                tableInfo.put("skipCount", tableResult.getSkipCount());
                if (tableResult.getErrorMessage() != null) {
                    tableInfo.put("errorMessage", tableResult.getErrorMessage());
                }
                if (tableResult.hasOperationErrors()) {
                    ArrayList opErrors = new ArrayList();
                    for (RestoreResult.OperationError opError : tableResult.getOperationErrors()) {
                        HashMap<String, String> errInfo = new HashMap<String, String>();
                        errInfo.put("operation", opError.getOperationType().name());
                        errInfo.put("recordKey", opError.getRecordKey());
                        errInfo.put("error", opError.getErrorMessage());
                        if (opError.getSqlState() != null) {
                            errInfo.put("sqlState", opError.getSqlState());
                        }
                        opErrors.add(errInfo);
                    }
                    tableInfo.put("operationErrors", opErrors);
                }
                tableDetails.add(tableInfo);
            }
            responseData.put("tables", tableDetails);
            if (!result.getErrors().isEmpty()) {
                responseData.put("errors", result.getErrors());
            }
            if (!result.isConnectionSuccess()) {
                response.setStatus(Constants.Error.ERROR);
                response.setMessage("Local database connection failed");
                response.setMessageDetail(result.getConnectionError());
            } else if (result.getFailureCount() == 0) {
                response.setStatus(Constants.Error.OK);
                response.setMessage("Tables restored successfully to local database");
            } else {
                response.setStatus(Constants.Error.OK);
                response.setMessage("Tables restored with some errors");
                response.setMessageDetail(result.getFailureCount() + " table(s) had errors");
            }
            response.setData(responseData);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("Local database restore failed with exception", (Throwable)e);
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Local database restore failed: " + e.getMessage());
            return new ResponseEntity((Object)response, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

