/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.db.telemetry.main.repository;

import com.coraltele.db.telemetry.main.entity.CustomerCDR;
import com.coraltele.service.telemetry.main.agentCDR.model.QueueProjection;
import com.coraltele.service.telemetry.main.customerCDR.model.CCAgentProjection;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.stereotype.Repository;

@Repository
public interface CustomerCDRRepository
extends CrudRepository<CustomerCDR, String> {
    public Page<CustomerCDR> findAll(Specification var1, Pageable var2);

    public List<CustomerCDR> findAll(Specification var1, Sort var2);

    public List<CustomerCDR> findAll(Specification var1);

    @Query(value="SELECT to_timestamp(start_time / (30 * 60) * (30 * 60)) at time zone 'UTC' as st, to_timestamp(start_time / (30 * 60) * (30 * 60)) at time zone 'UTC' + interval '30 minutes' as et, queue, queue_name, count(*) as calloffered, count(*) FILTER (WHERE status = 'answered') as answered, count(*) FILTER (WHERE status <> 'answered') as noanswer FROM customer_cdr GROUP BY to_timestamp(start_time / (30 * 60) * (30 * 60)) at time zone 'UTC', queue, queue_name", nativeQuery=true)
    public Page<Object[]> getQueueStatistics(Specification var1, Pageable var2);

    @Query(value="SELECT DISTINCT c.queue AS queue, c.queueName AS queueName FROM CustomerCDR c WHERE c.queue IS NOT NULL")
    public List<QueueProjection> findDistinctQueueAndQueueName();

    @Query(value="SELECT DISTINCT c.ccAgent AS ccAgent, c.agentFullName AS agentFullName FROM CustomerCDR c WHERE c.ccAgent IS NOT NULL")
    public List<CCAgentProjection> findDistinctCcAgents();

    @Query(value="SELECT DISTINCT c.queue AS queue, c.queueName AS queueName FROM CustomerCDR c WHERE c.status = 'answered' AND c.queue IS NOT NULL")
    public List<QueueProjection> findDistinctQueueAndQueueNameAnswered();

    @Query(value="SELECT DISTINCT c.ccAgent AS ccAgent, c.agentFullName AS agentFullName FROM CustomerCDR c WHERE c.status = 'answered' AND c.ccAgent IS NOT NULL")
    public List<CCAgentProjection> findDistinctCcAgentsAnswered();
}

