/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.db.telemetry.main.entity.view;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import lombok.Generated;
import org.hibernate.annotations.Subselect;

@Entity
@Subselect(value="SELECT  destination_number AS extension_no,  COUNT(*) AS total_call,  COUNT(CASE WHEN call_connected = 'true' THEN 1 END) AS answered,  COUNT(CASE WHEN call_connected = 'false' THEN 1 END) AS unanswered,  SUM(ring_duration) AS ring_duration,  ROUND(SUM(ring_duration)::numeric / NULLIF(COUNT(*), 0), 2) AS avg_ring_duration,  SUM(talk_duration) AS call_duration,  ROUND(    SUM(talk_duration)::numeric /    NULLIF(COUNT(CASE WHEN call_connected = 'true' THEN 1 END), 0),    2  ) AS avg_call_duration  FROM billing_cdr  WHERE coral_call_direction IN ('IN','INT')    AND (coral_featurecode IS NULL OR coral_featurecode = '')  GROUP BY destination_number ")
public class BillingCdrIncomingSummaryView {
    @Id
    @Column(name="extension_no")
    private String extensionNo;
    @Column(name="total_call")
    private Long totalCall;
    @Column(name="answered")
    private Long answered;
    @Column(name="unanswered")
    private Long unanswered;
    @Column(name="ring_duration")
    private Long ringDuration;
    @Column(name="avg_ring_duration")
    private Double avgRingDuration;
    @Column(name="call_duration")
    private Long callDuration;
    @Column(name="avg_call_duration")
    private Double avgCallDuration;

    @Generated
    public String getExtensionNo() {
        return this.extensionNo;
    }

    @Generated
    public Long getTotalCall() {
        return this.totalCall;
    }

    @Generated
    public Long getAnswered() {
        return this.answered;
    }

    @Generated
    public Long getUnanswered() {
        return this.unanswered;
    }

    @Generated
    public Long getRingDuration() {
        return this.ringDuration;
    }

    @Generated
    public Double getAvgRingDuration() {
        return this.avgRingDuration;
    }

    @Generated
    public Long getCallDuration() {
        return this.callDuration;
    }

    @Generated
    public Double getAvgCallDuration() {
        return this.avgCallDuration;
    }

    @Generated
    public void setExtensionNo(String extensionNo) {
        this.extensionNo = extensionNo;
    }

    @Generated
    public void setTotalCall(Long totalCall) {
        this.totalCall = totalCall;
    }

    @Generated
    public void setAnswered(Long answered) {
        this.answered = answered;
    }

    @Generated
    public void setUnanswered(Long unanswered) {
        this.unanswered = unanswered;
    }

    @Generated
    public void setRingDuration(Long ringDuration) {
        this.ringDuration = ringDuration;
    }

    @Generated
    public void setAvgRingDuration(Double avgRingDuration) {
        this.avgRingDuration = avgRingDuration;
    }

    @Generated
    public void setCallDuration(Long callDuration) {
        this.callDuration = callDuration;
    }

    @Generated
    public void setAvgCallDuration(Double avgCallDuration) {
        this.avgCallDuration = avgCallDuration;
    }

    @Generated
    public BillingCdrIncomingSummaryView() {
    }

    @Generated
    public BillingCdrIncomingSummaryView(String extensionNo, Long totalCall, Long answered, Long unanswered, Long ringDuration, Double avgRingDuration, Long callDuration, Double avgCallDuration) {
        this.extensionNo = extensionNo;
        this.totalCall = totalCall;
        this.answered = answered;
        this.unanswered = unanswered;
        this.ringDuration = ringDuration;
        this.avgRingDuration = avgRingDuration;
        this.callDuration = callDuration;
        this.avgCallDuration = avgCallDuration;
    }
}

