/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.uc.service;

import com.coraltele.db.billing.main.entity.Channel;
import com.coraltele.db.billing.main.entity.view.ViewChannelUCMissedCall;
import com.coraltele.db.billing.main.repository.ChannelRepository;
import com.coraltele.db.billing.main.repository.ViewChannelUCMissedCallRepository;
import com.coraltele.db.billing.main.specification.ViewChannelMissedCallUCSpecification;
import com.coraltele.db.telemetry.main.entity.UCDetails;
import com.coraltele.db.telemetry.main.repository.UCDetailsRepository;
import com.coraltele.db.telemetry.main.specification.UCDetailsMissedCallSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.billing.main.uc_notification.service.UcNotificationService;
import com.coraltele.service.uc.model.ChannelModel;
import com.coraltele.service.uc.model.UCDetailsModel;
import com.coraltele.service.uc.service.UCService;
import com.coraltele.service.uc.service.ViewChannelUCService;
import com.coraltele.service.user.service.UserService;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Component;

@Component
public class ChannelService {
    private static final Logger logger = LogManager.getLogger(ChannelService.class);
    @Autowired
    ChannelRepository channelRepository;
    @Autowired
    UCService ucService;
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    UcNotificationService notificationService;
    @Autowired
    ViewChannelUCService viewChannelUCService;
    @Autowired
    UCDetailsRepository ucDetailsRepository;
    @Autowired
    UserService userService;
    @Autowired
    ViewChannelUCMissedCallRepository ViewChannelUCMissedCallRepository;

    public RequestResponse getAllChannel(SearchRequest searchRequestData, Principal principal) {
        this.notificationService.updateNotificationForMissedCall(principal);
        this.updateMissedCallNotification(principal.getName());
        RequestResponse returnValue = new RequestResponse();
        boolean adminUser = false;
        if (this.userService.checkAdminUser(principal.getName())) {
            adminUser = true;
        }
        if (this.viewChannelUCService.readConfigureUc().equalsIgnoreCase("true")) {
            Specification filters = UCDetailsMissedCallSpecification.generateFilters((SearchRequest)searchRequestData, (String)principal.getName(), (boolean)adminUser);
            Sort sort = null;
            if (searchRequestData.getSortDirection().equals("asc")) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "callReceivedOn" : searchRequestData.getSortBy()}).ascending();
            } else if (searchRequestData.getSortDirection().equals("desc")) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "callReceivedOn" : searchRequestData.getSortBy()}).descending();
            }
            Page page = null;
            page = sort == null ? this.ucDetailsRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.ucDetailsRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
            SearchResponse responseData = new SearchResponse();
            responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
            responseData.setPageSize((long)page.getSize());
            responseData.setTotalPages((long)page.getTotalPages());
            responseData.setTotalRecords(page.getTotalElements());
            responseData.setCurrentPageData((Object)this.entityToModelConversionForMissedCall(page.getContent()));
            returnValue.setData((Object)responseData);
            returnValue.setMessageDetail("filtered list");
            logger.info(returnValue.getMessageDetail());
            return returnValue;
        }
        Specification filters = ViewChannelMissedCallUCSpecification.generateFilters((SearchRequest)searchRequestData, (String)principal.getName(), (boolean)adminUser);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "startStamp" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "startStamp" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.ViewChannelUCMissedCallRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.ViewChannelUCMissedCallRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessageDetail("filtered list");
        logger.info(returnValue.getMessageDetail());
        return returnValue;
    }

    public List<ChannelModel> entityToModelConversion(List<ViewChannelUCMissedCall> channels) {
        ArrayList<ChannelModel> addValue = new ArrayList<ChannelModel>();
        for (ViewChannelUCMissedCall row : channels) {
            ChannelModel data = new ChannelModel();
            data.setId(row.getId());
            data.setEpoch(row.getStartStamp());
            data.setEntityNumber(row.getCallerIdNumber());
            data.setLocalName(row.getCallerIdName());
            if (row.getIsMissedCall() != null && row.getIsMissedCall() == 1) {
                data.setIsMissedCall(Boolean.valueOf(true));
            } else {
                data.setIsMissedCall(Boolean.valueOf(false));
            }
            addValue.add(data);
        }
        return addValue;
    }

    public RequestResponse updateMissedCallNotification(String ucUSer) {
        RequestResponse returnValue = new RequestResponse();
        List list = this.channelRepository.findByUcUserAndUcMissedCall(ucUSer, Integer.valueOf(1));
        if (list != null && !list.isEmpty()) {
            for (Channel row : list) {
                row.setIsNotified(Boolean.valueOf(true));
                this.channelRepository.save((Object)row);
            }
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Data Updated");
        returnValue.setMessageDetail("successfully update notification");
        logger.info(returnValue.getMessageDetail());
        return returnValue;
    }

    public List<UCDetailsModel> entityToModelConversionForMissedCall(List<UCDetails> list) {
        ArrayList<UCDetailsModel> addValue = new ArrayList<UCDetailsModel>();
        for (UCDetails row : list) {
            UCDetailsModel data = new UCDetailsModel();
            data.setUcNumber(row.getUcDialedTo());
            data.setUcUserId(row.getUcUserId());
            data.setCallDirection(row.getCallDirection());
            data.setCallDuration(row.getCallDuration());
            data.setCallReceivedOn(DateFormatUtility.epochToLocalDateTimeAsStringForSecond((Long)row.getCallReceivedOn()));
            data.setId(row.getId());
            data.setUcDialedTo(row.getUcNumber());
            if (row.getIsMissed() != null) {
                data.setIsMissed(row.getIsMissed());
            } else {
                data.setIsMissed(Boolean.valueOf(false));
            }
            addValue.add(data);
        }
        return addValue;
    }
}

