/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.task.service;

import com.coraltele.db.telemetry.main.entity.TaskDetails;
import com.coraltele.db.telemetry.main.entity.view.TaskDelayView;
import com.coraltele.db.telemetry.main.repository.TaskDelayViewRepository;
import com.coraltele.db.telemetry.main.repository.TaskDetailsRepository;
import com.coraltele.db.telemetry.main.repository.TaskRepository;
import com.coraltele.db.telemetry.main.specification.TaskDelayViewSpecification;
import com.coraltele.db.users.main.repository.UserGroupMasterRepository;
import com.coraltele.db.users.main.repository.UserGroupRepository;
import com.coraltele.db.users.main.repository.UserRepository;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.main.task.model.TaskModel;
import com.coraltele.service.telemetry.main.task.service.TaskService;
import com.coraltele.service.user.service.UserService;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class TaskDelayViewService {
    private static final Logger logger = LogManager.getLogger(TaskService.class);
    @Autowired
    private TaskDetailsRepository taskDetailsRepository;
    @Autowired
    private TaskDelayViewRepository taskDelayViewRepository;
    @Autowired
    UserService userService;
    @Autowired
    UserGroupRepository userGroupRepository;
    @Autowired
    UserGroupMasterRepository userGroupMasterRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    TaskRepository taskRepository;

    public RequestResponse getFilterTasks(SearchRequest searchRequestData, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        boolean adminUser = false;
        boolean teamLeaderUser = false;
        boolean dispatcher = false;
        if (this.userService.checkAdminUser(principal.getName())) {
            adminUser = true;
        } else if (this.userService.checkRoleDispatcher(principal.getName())) {
            dispatcher = true;
        } else if (this.userService.checkRoleTaskManager(principal.getName())) {
            teamLeaderUser = true;
        }
        Specification filters = TaskDelayViewSpecification.generateFilters((SearchRequest)searchRequestData, (String)principal.getName(), (boolean)adminUser, (boolean)dispatcher, (boolean)teamLeaderUser, (UserRepository)this.userRepository, (UserGroupRepository)this.userGroupRepository, (UserGroupMasterRepository)this.userGroupMasterRepository, (TaskRepository)this.taskRepository);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "assignedOn" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "assignedOn" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.taskDelayViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.taskDelayViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<TaskModel> entityToModelConversion(List<TaskDelayView> list) {
        ArrayList<TaskModel> addValue = new ArrayList<TaskModel>();
        for (TaskDelayView row : list) {
            TaskModel data = new TaskModel();
            List taskDetails = this.taskDetailsRepository.findByTaskIdOrderByIdDesc(row.getId());
            data.setId(row.getId());
            data.setTasksName(row.getTasksName());
            data.setTaskType(row.getTaskType());
            data.setTaskPriority(row.getTaskPriority());
            data.setTaskDescription(row.getTaskDescription());
            if (row.getAssignedOn() != null) {
                data.setAssignedOn(DateFormatUtility.epochToLocalDateTime((Long)row.getAssignedOn()));
            }
            if (row.getExpectedCompletionDate() != null) {
                data.setExpectedCompletionDate(DateFormatUtility.epochToLocalDateTime((Long)row.getExpectedCompletionDate()));
            }
            if (row.getChangedCompletionOn() != null) {
                data.setChangedCompletionOn(DateFormatUtility.epochToLocalDateTime((Long)row.getChangedCompletionOn()));
            }
            data.setCurrentStats(row.getCurrentStats());
            data.setAssignedGroup(row.getAssignedGroup());
            data.setAssignedUser(row.getAssignedUser());
            if (!taskDetails.isEmpty()) {
                data.setIsDelay(((TaskDetails)taskDetails.get(0)).getIsDelay());
                data.setRemarks(((TaskDetails)taskDetails.get(0)).getRemarks());
            }
            data.setReviewer(row.getReviewer());
            if (row.getTaskCompletedOn() != null) {
                data.setTaskCompletedOn(DateFormatUtility.epochToLocalDateTime((Long)row.getTaskCompletedOn()));
            }
            data.setAssignedTo(row.getAssignedTo());
            data.setFilePath(row.getFilePath());
            addValue.add(data);
        }
        return addValue;
    }
}

