/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.inOutgatewaySummary.controller;

import com.coraltele.db.telemetry.main.repository.BillingCDRRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.telemetry.main.inOutgatewaySummary.model.GatewayInBoundModel;
import com.coraltele.service.telemetry.main.inOutgatewaySummary.model.GatewayOutBoundModel;
import com.coraltele.service.telemetry.main.inOutgatewaySummary.service.GatewaySummaryService;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/gatewaySummary"})
public class GatewaySummaryController {
    private static final Logger logger = LogManager.getLogger(GatewaySummaryController.class);
    @Autowired
    private GatewaySummaryService gatewaySummaryService;
    @Autowired
    private DynamicPdfThreadService dynamicPdfThreadService;
    @Autowired
    private BillingCDRRepository billingCDRRepository;

    private String mapOutboundHeader(String k) {
        switch (k) {
            case "coralGateway": {
                return "Outbound Gateway";
            }
            case "intercomCall": {
                return "Intercom Calls";
            }
            case "intercomCost": {
                return "Intercom Cost";
            }
            case "localCall": {
                return "Local Calls";
            }
            case "localCost": {
                return "Local Cost";
            }
            case "stdCall": {
                return "STD Calls";
            }
            case "stdCost": {
                return "STD Cost";
            }
            case "isdCall": {
                return "ISD Calls";
            }
            case "isdCost": {
                return "ISD Cost";
            }
            case "totalCall": {
                return "Total Calls";
            }
            case "totalCost": {
                return "Total Cost";
            }
        }
        return k;
    }

    private String mapInboundHeader(String c) {
        switch (c) {
            case "coralInboundGateway": {
                return "Inbound Gateway";
            }
            case "totalCall": {
                return "Total Calls";
            }
            case "answered": {
                return "Answered Calls";
            }
            case "unAnswered": {
                return "Unanswered Calls";
            }
            case "ringDuration": {
                return "Ring Time";
            }
            case "avgRingDuration": {
                return "Avg Ring Time";
            }
            case "talkDuration": {
                return "Talk Time";
            }
            case "avgCallDuration": {
                return "Avg Talk Time";
            }
        }
        return c;
    }

    @PostMapping(value={"/listOutBound"})
    public ResponseEntity<RequestResponse> getOutBoundList(@RequestBody SearchRequest request) {
        RequestResponse res = this.gatewaySummaryService.getListOutBound(request);
        if (res.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)res);
        }
        return ResponseEntity.badRequest().body((Object)res);
    }

    @PostMapping(value={"/downloadOutBoundCSV"})
    public ResponseEntity<byte[]> downloadOutBoundCSV(@RequestBody SearchRequest request) {
        try {
            RequestResponse result = this.gatewaySummaryService.getListOutBound(request);
            SearchResponse sr = (SearchResponse)result.getData();
            List data = (List)sr.getCurrentPageData();
            StringWriter writer = new StringWriter();
            CSVPrinter csv = new CSVPrinter((Appendable)writer, CSVFormat.DEFAULT);
            List<String> columns = request.getColumnNames() == null || request.getColumnNames().isEmpty() ? Arrays.asList("coralGateway", "intercomCall", "intercomCost", "localCall", "localCost", "stdCall", "stdCost", "isdCall", "isdCost", "totalCall", "totalCost") : request.getColumnNames();
            List mappedHeaders = columns.stream().map(arg_0 -> this.mapOutboundHeader(arg_0)).collect(Collectors.toList());
            csv.printRecord(mappedHeaders);
            for (GatewayOutBoundModel m : data) {
                ArrayList<Object> row = new ArrayList<Object>();
                Iterator iterator = columns.iterator();
                while (iterator.hasNext()) {
                    String c;
                    switch (c = (String)iterator.next()) {
                        case "coralGateway": {
                            row.add(m.getCoralGateway());
                            break;
                        }
                        case "intercomCall": {
                            row.add(m.getIntercomCall());
                            break;
                        }
                        case "intercomCost": {
                            row.add(m.getIntercomCost());
                            break;
                        }
                        case "localCall": {
                            row.add(m.getLocalCall());
                            break;
                        }
                        case "localCost": {
                            row.add(m.getLocalCost());
                            break;
                        }
                        case "stdCall": {
                            row.add(m.getStdCall());
                            break;
                        }
                        case "stdCost": {
                            row.add(m.getStdCost());
                            break;
                        }
                        case "isdCall": {
                            row.add(m.getIsdCall());
                            break;
                        }
                        case "isdCost": {
                            row.add(m.getIsdCost());
                            break;
                        }
                        case "totalCall": {
                            row.add(m.getTotalCall());
                            break;
                        }
                        case "totalCost": {
                            row.add(m.getTotalCost());
                        }
                    }
                }
                csv.printRecord(row);
            }
            csv.flush();
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=outbound_gateway_summary.csv"})).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)writer.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            logger.error("Outbound CSV failed", (Throwable)e);
            return ResponseEntity.internalServerError().build();
        }
    }

    @PostMapping(value={"/generateAndDownloadOutBoundPdf"})
    public CompletableFuture<ResponseEntity<?>> generateAndDownloadOutboundPdf(@RequestParam String reportType, @RequestBody SearchRequest request, Principal principal) {
        String file = "/tmp/" + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        return this.dynamicPdfThreadService.startGeneratingReportAsync(reportType, id, request, file, principal).thenApply(r -> this.gatewaySummaryService.getPdfFile(file));
    }

    @PostMapping(value={"/inboundList"})
    public ResponseEntity<RequestResponse> getInboundList(@RequestBody SearchRequest request) {
        RequestResponse res = this.gatewaySummaryService.getListInBound(request);
        if (res.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)res);
        }
        return ResponseEntity.badRequest().body((Object)res);
    }

    @PostMapping(value={"/downloadInboundCSV"})
    public ResponseEntity<byte[]> downloadInboundCSV(@RequestBody SearchRequest request) {
        try {
            RequestResponse result = this.gatewaySummaryService.getListInBound(request);
            SearchResponse sr = (SearchResponse)result.getData();
            List data = (List)sr.getCurrentPageData();
            StringWriter writer = new StringWriter();
            CSVPrinter csv = new CSVPrinter((Appendable)writer, CSVFormat.DEFAULT);
            List<String> columns = request.getColumnNames() == null || request.getColumnNames().isEmpty() ? Arrays.asList("coralInboundGateway", "totalCall", "answered", "unAnswered", "talkDuration", "avgCallDuration", "ringDuration", "avgRingDuration") : request.getColumnNames();
            List mappedHeaders = columns.stream().map(arg_0 -> this.mapInboundHeader(arg_0)).collect(Collectors.toList());
            csv.printRecord(mappedHeaders);
            for (GatewayInBoundModel m : data) {
                ArrayList<Object> row = new ArrayList<Object>();
                Iterator iterator = columns.iterator();
                while (iterator.hasNext()) {
                    String c;
                    switch (c = (String)iterator.next()) {
                        case "coralInboundGateway": {
                            row.add(m.getCoralInboundGateway());
                            break;
                        }
                        case "totalCall": {
                            row.add(m.getTotalCall());
                            break;
                        }
                        case "answered": {
                            row.add(m.getAnswered());
                            break;
                        }
                        case "unAnswered": {
                            row.add(m.getUnAnswered());
                            break;
                        }
                        case "ringDuration": {
                            row.add(m.getRingDuration());
                            break;
                        }
                        case "avgRingDuration": {
                            row.add(m.getAvgRingDuration());
                            break;
                        }
                        case "talkDuration": {
                            row.add(m.getTalkDuration());
                            break;
                        }
                        case "avgCallDuration": {
                            row.add(m.getAvgCallDuration());
                        }
                    }
                }
                csv.printRecord(row);
            }
            csv.flush();
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=inbound_gateway_summary.csv"})).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)writer.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            logger.error("Inbound CSV failed", (Throwable)e);
            return ResponseEntity.internalServerError().build();
        }
    }

    @PostMapping(value={"/generateAndDownloadInBoundPdf"})
    public CompletableFuture<ResponseEntity<?>> generateAndDownloadInboundPdf(@RequestParam String reportType, @RequestBody SearchRequest request, Principal principal) {
        String file = "/tmp/" + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        return this.dynamicPdfThreadService.startGeneratingReportAsync(reportType, id, request, file, principal).thenApply(r -> this.gatewaySummaryService.getPdfFile(file));
    }
}

