/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.customerCDR.service;

import com.coraltele.db.coralapps.main.entity.Agent;
import com.coraltele.db.coralapps.main.repository.AgentRepository;
import com.coraltele.db.telemetry.main.entity.CustomerCDR;
import com.coraltele.db.telemetry.main.entity.view.LastAbandonedView;
import com.coraltele.db.telemetry.main.repository.CustomerCDRRepository;
import com.coraltele.db.telemetry.main.repository.LastAbandonedViewRepository;
import com.coraltele.db.telemetry.main.specification.CustomerCDRSpecification;
import com.coraltele.db.telemetry.main.specification.LastAbandonedRecordsSpecification;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.coralApps.callcenter.queueTL.service.QueueTLService;
import com.coraltele.service.telemetry.main.agentCDR.model.QueueProjection;
import com.coraltele.service.telemetry.main.customerCDR.model.CCAgentProjection;
import com.coraltele.service.telemetry.main.customerCDR.model.CustomerCDRModel;
import com.coraltele.service.user.service.UserService;
import java.math.BigDecimal;
import java.security.Principal;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class CustomerCDRService {
    private static final Logger logger = LogManager.getLogger(CustomerCDRService.class);
    @Autowired
    CustomerCDRRepository customerCDRRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    LastAbandonedViewRepository lastAbandonedViewRepository;
    @Autowired
    UserService userService;
    @Autowired
    QueueTLService queueTLService;
    @Autowired
    AgentRepository agentRepository;

    public RequestResponse getAllByFilter(SearchRequest searchRequestData, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        boolean teamLeaderUser = false;
        if (this.userService.checkRoleTL(principal.getName())) {
            teamLeaderUser = true;
        }
        List queueId = null;
        if (teamLeaderUser) {
            queueId = this.queueTLService.getQueueListByTeamLeader(principal.getName());
        }
        Specification filters = CustomerCDRSpecification.generateFilters((SearchRequest)searchRequestData, (boolean)teamLeaderUser, queueId);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "startTime" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "startTime" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.customerCDRRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.customerCDRRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<CustomerCDRModel> entityToModelConversion(List<CustomerCDR> lastAgent) {
        ArrayList<CustomerCDRModel> addValue = new ArrayList<CustomerCDRModel>();
        for (CustomerCDR row : lastAgent) {
            CustomerCDRModel data = new CustomerCDRModel();
            data.setUuid(row.getUuid());
            data.setUuid1(row.getUuid());
            data.setAcdNumber(row.getAcdNumber());
            data.setAgentTalkTime(DateFormatUtility.findLocalTime((Long)row.getAgentTalkTime()));
            data.setAnsweredBy(row.getAnsweredBy());
            data.setAnsweredByName(row.getAnsweredByName());
            data.setCallDirection(row.getCallDirection());
            data.setCallType(row.getCallType());
            data.setCustomerNumber(row.getCustomerNumber());
            data.setCustomerName(row.getCustomerName());
            data.setCost(row.getCost());
            data.setPulse(row.getPulse());
            data.setQueue(row.getQueue());
            data.setQueueStrategy(row.getQueueStrategy());
            if (row.getStartTime() != null) {
                data.setStartTime(DateFormatUtility.epochToLocalDateTimeAsStringForSecond((Long)row.getStartTime()));
            }
            if (row.getAnswerTime() != null) {
                data.setAnswerTime(DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)row.getAnswerTime()));
            }
            if (row.getEndTime() != null) {
                data.setEndTime(DateFormatUtility.epochToLocalDateTimeAsStringForSecond((Long)row.getEndTime()));
            }
            data.setStatus(row.getStatus());
            data.setTransferBy(row.getTransferBy());
            data.setTransferStatus(row.getTransferStatus());
            data.setTransferTo(row.getTransferTo());
            data.setTransferType(row.getTransferType());
            data.setWaitTime(row.getWaitTime());
            data.setQueueType(row.getQueueType());
            data.setRecordingFile(row.getRecordingFile());
            data.setAgentTalkedTo(row.getAgentTalkedTo());
            if (row.getMos() != null) {
                if (row.getMos().compareTo(BigDecimal.valueOf(0.0)) == 0) {
                    data.setMos(BigDecimal.valueOf(4.3));
                } else {
                    data.setMos(row.getMos());
                }
            }
            addValue.add(data);
        }
        return addValue;
    }

    public String getFile(String uuid) {
        Optional list = this.customerCDRRepository.findById((Object)uuid);
        if (list.isPresent()) {
            return ((CustomerCDR)list.get()).getRecordingFile();
        }
        return null;
    }

    public RequestResponse getAllByFilterForCallerCallDataAnalysis(SearchRequest searchRequestData, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        boolean teamLeaderUser = false;
        if (this.userService.checkRoleTL(principal.getName())) {
            teamLeaderUser = true;
        }
        List queueId = null;
        if (teamLeaderUser) {
            queueId = this.queueTLService.getQueueListByTeamLeader(principal.getName());
        }
        Specification filters = CustomerCDRSpecification.generateFilters((SearchRequest)searchRequestData, (boolean)teamLeaderUser, queueId);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "startTime" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "startTime" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.customerCDRRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.customerCDRRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversionForCallerCallDataAnalysis(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<CustomerCDRModel> entityToModelConversionForCallerCallDataAnalysis(List<CustomerCDR> lastAgent) {
        ArrayList<CustomerCDRModel> addValue = new ArrayList<CustomerCDRModel>();
        for (CustomerCDR row : lastAgent) {
            CustomerCDRModel data = new CustomerCDRModel();
            data.setUuid(row.getUuid());
            data.setCcAgent(row.getCcAgent());
            data.setAgentFullName(row.getAgentFullName());
            data.setQueueName(row.getQueueName());
            data.setQueue(row.getQueue());
            data.setCampaign(row.getCampaign());
            data.setCallId(row.getCallId());
            data.setHangupCause(row.getHangupCause());
            data.setAgentTalkTime(DateFormatUtility.findLocalTime((Long)row.getAgentTalkTime()));
            data.setCustomerNumber(row.getCustomerNumber());
            data.setCallDirection(row.getCallDirection());
            data.setAgentTalkedTo(row.getAgentTalkedTo());
            data.setDuration(DateFormatUtility.findLocalTimeForInteger((Integer)row.getDuration()));
            if (row.getIsMissed() != null && row.getIsMissed().booleanValue()) {
                data.setIsMissed("Answered");
            } else {
                data.setIsMissed("Not Answered");
            }
            if (row.getStartTime() != null) {
                data.setStartTime(DateFormatUtility.epochToLocalDateTimeAsStringForSecond((Long)row.getStartTime()));
            }
            if (row.getAnswerTime() != null) {
                data.setAnswerTime(DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)row.getAnswerTime()));
            }
            if (row.getEndTime() != null) {
                data.setEndTime(DateFormatUtility.epochToLocalDateTimeAsStringForSecond((Long)row.getEndTime()));
            }
            data.setRecordingFile(row.getRecordingFile());
            data.setStatus(row.getStatus());
            if (row.getMos() != null) {
                if (row.getMos().compareTo(BigDecimal.valueOf(0.0)) == 0) {
                    data.setMos(BigDecimal.valueOf(4.3));
                } else {
                    data.setMos(row.getMos());
                }
            }
            addValue.add(data);
        }
        return addValue;
    }

    public RequestResponse getAllByFilterForLastAbandonedRecords(SearchRequest searchRequestData, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        boolean teamLeaderUser = false;
        if (this.userService.checkRoleTL(principal.getName())) {
            teamLeaderUser = true;
        }
        List queueId = null;
        if (teamLeaderUser) {
            queueId = this.queueTLService.getQueueListByTeamLeader(principal.getName());
        }
        Specification filters = LastAbandonedRecordsSpecification.generateFilters((SearchRequest)searchRequestData, (boolean)teamLeaderUser, queueId);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "startTime" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "startTime" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.lastAbandonedViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.lastAbandonedViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversionForLastAbandonedRecords(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<CustomerCDRModel> entityToModelConversionForLastAbandonedRecords(List<LastAbandonedView> lastAgent) {
        ArrayList<CustomerCDRModel> addValue = new ArrayList<CustomerCDRModel>();
        for (LastAbandonedView row : lastAgent) {
            CustomerCDRModel data = new CustomerCDRModel();
            data.setUuid(row.getUuid());
            data.setQueue(row.getQueue());
            data.setCampaign(row.getCampaign());
            data.setQueueName(row.getQueueName());
            data.setCallId(row.getCallId());
            data.setCustomerNumber(row.getCustomerNumber());
            if (row.getStartTime() != null) {
                data.setStartTime(DateFormatUtility.epochToLocalDateTimeAsStringForSecond((Long)row.getStartTime()));
            }
            data.setHangupCause(row.getHangupCause());
            data.setDuration(DateFormatUtility.findLocalTimeForInteger((Integer)row.getDuration()));
            if (StringUtils.hasText((String)row.getCcAgent())) {
                Optional agentOptional = this.agentRepository.findByName(row.getCcAgent());
                if (agentOptional.isPresent()) {
                    data.setAgentFullName(((Agent)agentOptional.get()).getAgentFullName());
                } else {
                    data.setAgentFullName("");
                }
            } else {
                data.setAgentFullName("");
            }
            data.setCcAgent(row.getCcAgent());
            addValue.add(data);
        }
        return addValue;
    }

    public RequestResponse getAllByFilterForQueueTimeInterval(SearchRequest searchRequestData, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        boolean teamLeaderUser = false;
        if (this.userService.checkRoleTL(principal.getName())) {
            teamLeaderUser = true;
        }
        List queueId = null;
        if (teamLeaderUser) {
            queueId = this.queueTLService.getQueueListByTeamLeader(principal.getName());
        }
        Specification filters = CustomerCDRSpecification.generateFilters((SearchRequest)searchRequestData, (boolean)teamLeaderUser, queueId);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "queue" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "queue" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.customerCDRRepository.getQueueStatistics(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.customerCDRRepository.getQueueStatistics(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.getAllCustomer(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<CustomerCDRModel> getAllCustomer(List<Object[]> lastAgent) {
        ArrayList<CustomerCDRModel> addValue = new ArrayList<CustomerCDRModel>();
        for (Object[] row : lastAgent) {
            CustomerCDRModel data = new CustomerCDRModel();
            Timestamp startTimestamp = (Timestamp)row[0];
            Timestamp endTimestamp = (Timestamp)row[1];
            LocalDateTime startTime = startTimestamp.toInstant().atZone(ZoneId.of("UTC")).toLocalDateTime();
            LocalDateTime endTime = endTimestamp.toInstant().atZone(ZoneId.of("UTC")).toLocalDateTime();
            data.setStartTime(startTime);
            data.setEndTime(endTime);
            data.setQueue((String)row[2]);
            data.setQueueName((String)row[3]);
            data.setCallOffered(Long.valueOf(((Number)row[4]).longValue()));
            data.setAnswered(Long.valueOf(((Number)row[5]).longValue()));
            data.setNoAnswer(Long.valueOf(((Number)row[6]).longValue()));
            addValue.add(data);
        }
        return addValue;
    }

    public RequestResponse getQueueOfCustomerCDR() {
        RequestResponse response = new RequestResponse();
        List queueList = this.customerCDRRepository.findDistinctQueueAndQueueName();
        if (queueList.isEmpty()) {
            response.setData(Collections.emptyList());
            response.setMessage("No queue found");
            return response;
        }
        ArrayList<CustomerCDRModel> agentCDRModelList = new ArrayList<CustomerCDRModel>();
        for (QueueProjection qp : queueList) {
            CustomerCDRModel model = new CustomerCDRModel();
            model.setQueue(qp.getQueue());
            model.setQueueName(qp.getQueue() + " - " + qp.getQueueName());
            agentCDRModelList.add(model);
        }
        response.setData(agentCDRModelList);
        response.setMessage("List of Queue");
        return response;
    }

    public RequestResponse getDistinctCcAgentList() {
        RequestResponse response = new RequestResponse();
        List agentData = this.customerCDRRepository.findDistinctCcAgents();
        if (agentData.isEmpty()) {
            response.setData(Collections.emptyList());
            response.setMessage("No agents found");
            return response;
        }
        ArrayList<CustomerCDRModel> resultList = new ArrayList<CustomerCDRModel>();
        for (CCAgentProjection row : agentData) {
            CustomerCDRModel customerCDRModel = new CustomerCDRModel();
            customerCDRModel.setCcAgent(row.getCcAgent());
            customerCDRModel.setAgentFullName(row.getAgentFullName());
            resultList.add(customerCDRModel);
        }
        response.setData(resultList);
        response.setMessage("List of distinct CC agents and their full names");
        return response;
    }

    public RequestResponse getQueueOfCustomerCDRAnswered() {
        RequestResponse response = new RequestResponse();
        List queueList = this.customerCDRRepository.findDistinctQueueAndQueueNameAnswered();
        if (queueList.isEmpty()) {
            response.setData(Collections.emptyList());
            response.setMessage("No queue found");
            return response;
        }
        ArrayList<CustomerCDRModel> agentCDRModelList = new ArrayList<CustomerCDRModel>();
        for (QueueProjection qp : queueList) {
            CustomerCDRModel model = new CustomerCDRModel();
            model.setQueue(qp.getQueue());
            model.setQueueName(qp.getQueue() + " - " + qp.getQueueName());
            agentCDRModelList.add(model);
        }
        response.setData(agentCDRModelList);
        response.setMessage("List of Queue");
        return response;
    }

    public RequestResponse getDistinctCcAgentListAnswered() {
        RequestResponse response = new RequestResponse();
        List agentData = this.customerCDRRepository.findDistinctCcAgentsAnswered();
        if (agentData.isEmpty()) {
            response.setData(Collections.emptyList());
            response.setMessage("No agents found");
            return response;
        }
        ArrayList<CustomerCDRModel> resultList = new ArrayList<CustomerCDRModel>();
        for (CCAgentProjection row : agentData) {
            CustomerCDRModel customerCDRModel = new CustomerCDRModel();
            customerCDRModel.setCcAgent(row.getCcAgent());
            customerCDRModel.setAgentFullName(row.getCcAgent() + " - " + row.getAgentFullName());
            resultList.add(customerCDRModel);
        }
        response.setData(resultList);
        response.setMessage("List of distinct CC agents and their full names");
        return response;
    }
}

