/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.agentCDR.service;

import com.coraltele.db.telemetry.main.entity.AgentCDR;
import com.coraltele.db.telemetry.main.repository.AgentCDRRepository;
import com.coraltele.db.telemetry.main.specification.AgentCDRSTokenpecification;
import com.coraltele.db.telemetry.main.specification.AgentCDRSpecification;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.coralApps.callcenter.queueTL.service.QueueTLService;
import com.coraltele.service.telemetry.main.agentCDR.model.AgentCDRModel;
import com.coraltele.service.telemetry.main.agentCDR.model.AgentProjection;
import com.coraltele.service.telemetry.main.agentCDR.model.QueueProjection;
import com.coraltele.service.user.service.UserService;
import java.math.BigDecimal;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class AgentCDRService {
    private static final Logger logger = LogManager.getLogger(AgentCDRService.class);
    @Autowired
    AgentCDRRepository agentCDRRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    UserService userService;
    @Autowired
    QueueTLService queueTLService;

    public RequestResponse getAllByFilter(SearchRequest searchRequestData, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        boolean adminUser = false;
        boolean teamLeaderUser = false;
        boolean agentUser = false;
        boolean managerUser = false;
        if (this.userService.checkAdminUser(principal.getName())) {
            adminUser = true;
        } else if (this.userService.checkRoleTL(principal.getName())) {
            teamLeaderUser = true;
        } else if (this.userService.checkManagerUser(principal.getName())) {
            managerUser = true;
        } else {
            agentUser = true;
        }
        List queueId = null;
        if (teamLeaderUser) {
            queueId = this.queueTLService.getQueueListByTeamLeader(principal.getName());
        }
        Specification filters = AgentCDRSpecification.generateFilters((SearchRequest)searchRequestData, (String)principal.getName(), (boolean)adminUser, (boolean)teamLeaderUser, (boolean)agentUser, (boolean)managerUser, (List)queueId);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "startTime" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "startTime" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.agentCDRRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.agentCDRRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<AgentCDRModel> entityToModelConversion(List<AgentCDR> lastAgent) {
        ArrayList<AgentCDRModel> addValue = new ArrayList<AgentCDRModel>();
        for (AgentCDR row : lastAgent) {
            AgentCDRModel data = new AgentCDRModel();
            data.setUuid(row.getUuid());
            data.setCallId(row.getCallId());
            data.setCampaignName(row.getCampaignName());
            data.setAgentName(row.getAgentName());
            data.setFullName(row.getFullName());
            data.setQueue(row.getQueue());
            data.setQueueName(row.getQueueName());
            data.setHangupCause(row.getHangupCause());
            data.setTalkDuration(DateFormatUtility.findLocalTime((Long)row.getTalkDuration()));
            data.setCustomerNumber(row.getCustomerNumber());
            data.setDuration(DateFormatUtility.findLocalTimeForInteger((Integer)row.getDuration()));
            if (row.getIsMissed() != null && !row.getIsMissed().booleanValue()) {
                data.setIsMissed("Answered");
            } else {
                data.setIsMissed("Not Answered");
            }
            if (row.getStartTime() != null) {
                data.setStartTime(DateFormatUtility.epochToLocalDateTimeAsStringForSecond((Long)row.getStartTime()));
            }
            if (row.getAnswerTime() != null) {
                data.setAnswerTime(DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)row.getAnswerTime()));
            }
            if (row.getEndTime() != null) {
                data.setEndTime(DateFormatUtility.epochToLocalDateTimeAsStringForSecond((Long)row.getEndTime()));
            }
            data.setRecordingFile(row.getRecordingFile());
            data.setAgentTalkedTo(row.getAgentTalkedTo());
            data.setCallDirection(row.getCallDirection());
            data.setLeadName(row.getLeadName());
            data.setSecond10(row.getSecond10());
            data.setSecond20(row.getSecond20());
            data.setSecond30(row.getSecond30());
            data.setSecond40(row.getSecond40());
            data.setSecond50(row.getSecond50());
            data.setSecond60(row.getSecond60());
            if (row.getMos().compareTo(BigDecimal.valueOf(0.0)) == 0) {
                data.setMos(BigDecimal.valueOf(4.3));
            } else {
                data.setMos(row.getMos());
            }
            addValue.add(data);
        }
        return addValue;
    }

    public String getFile(String uuid) {
        Optional list = this.agentCDRRepository.findById((Object)uuid);
        if (list.isPresent()) {
            return ((AgentCDR)list.get()).getRecordingFile();
        }
        return null;
    }

    public RequestResponse getQueueOfAgentCdr() {
        RequestResponse response = new RequestResponse();
        List queueList = this.agentCDRRepository.findDistinctQueues();
        if (queueList.isEmpty()) {
            response.setData(Collections.emptyList());
            response.setMessage("No queue found");
            return response;
        }
        ArrayList<AgentCDRModel> agentCDRModelList = new ArrayList<AgentCDRModel>();
        for (QueueProjection qp : queueList) {
            AgentCDRModel model = new AgentCDRModel();
            model.setQueue(qp.getQueue());
            model.setQueueName(qp.getQueue() + " - " + qp.getQueueName());
            agentCDRModelList.add(model);
        }
        response.setData(agentCDRModelList);
        response.setMessage("List of Queue");
        return response;
    }

    public RequestResponse getAgentOfAgentCdr() {
        RequestResponse response = new RequestResponse();
        ArrayList<AgentCDRModel> agentCDRModelList = new ArrayList<AgentCDRModel>();
        List agents = this.agentCDRRepository.findDistinctAgentNames();
        if (agents.isEmpty()) {
            response.setData(Collections.emptyList());
            response.setMessage("No agent found");
            return response;
        }
        for (AgentProjection agent : agents) {
            AgentCDRModel model = new AgentCDRModel();
            model.setAgentName(agent.getAgentName());
            model.setFullName(agent.getAgentName() + " - " + agent.getFullName());
            agentCDRModelList.add(model);
        }
        response.setData(agentCDRModelList);
        response.setMessage("List of Agents");
        return response;
    }

    public RequestResponse getAllByFilterWithToken(SearchRequest searchRequest) {
        RequestResponse returnValue = new RequestResponse();
        List queueId = null;
        Specification filters = AgentCDRSTokenpecification.generateFilters((SearchRequest)searchRequest, queueId);
        Sort sort = null;
        if (searchRequest.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequest.getSortBy().equals("") || searchRequest.getSortBy() == null ? "startTime" : searchRequest.getSortBy()}).ascending();
        } else if (searchRequest.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequest.getSortBy().equals("") || searchRequest.getSortBy() == null ? "startTime" : searchRequest.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.agentCDRRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequest.getCurrentPage(), (int)(searchRequest.getPageSize() == 0 ? 10 : searchRequest.getPageSize()))) : this.agentCDRRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequest.getCurrentPage(), (int)(searchRequest.getPageSize() == 0 ? 10 : searchRequest.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequest.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequest.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

