/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.ExtensionSummary.controller;

import com.coraltele.db.telemetry.main.repository.BillingCDRRepository;
import com.coraltele.db.telemetry.main.repository.BillingCdrExtensionViewRepository;
import com.coraltele.db.telemetry.main.specification.ExtensionSummaryDetailSpecification;
import com.coraltele.db.telemetry.main.specification.ExtensionSummarySpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DownloadPdfService;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.AdvanceFilter;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.telemetry.main.ExtensionSummary.model.CallerSummaryModel;
import com.coraltele.service.telemetry.main.ExtensionSummary.model.ExtensionWiseReportModel;
import com.coraltele.service.telemetry.main.ExtensionSummary.service.ExtensionSummaryService;
import java.io.File;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/extensionSummary"})
@RestController
public class ExtensionSummaryController {
    private static final Logger logger = LogManager.getLogger(ExtensionSummaryController.class);
    @Autowired
    ExtensionSummaryService extensionCDRService;
    @Autowired
    ExtensionSummarySpecification ExtensionSummarySpecification;
    @Autowired
    private DynamicPdfThreadService dynamicReportThreadService;
    @Autowired
    DownloadPdfService pdfDownloadService;
    @Autowired
    ExtensionSummaryDetailSpecification extensionSummaryDetailSpecification;
    @Autowired
    BillingCDRRepository billingCDRRepository;
    @Autowired
    BillingCdrExtensionViewRepository repositoryView;
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();
    private static final NumberFormat INR_FORMAT;

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllByFilter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.extensionCDRService.getAllByFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredExtensionInCSV(@RequestBody SearchRequest request) {
        try {
            List rawRows;
            LocalDate fromDate = null;
            LocalDate toDate = null;
            String extension = null;
            String callerId = null;
            String callType = null;
            String search = request.getSearch();
            String sortBy = request.getSortBy();
            if (search != null) {
                search = search.trim();
            }
            if (request.getAdvancedFilters() != null) {
                for (AdvanceFilter f : request.getAdvancedFilters()) {
                    if ("date".equalsIgnoreCase(f.getDataType()) && "callDate".equalsIgnoreCase(f.getFieldName())) {
                        if ("from".equalsIgnoreCase(f.getDirection())) {
                            fromDate = LocalDate.parse(f.getValue());
                        }
                        if ("to".equalsIgnoreCase(f.getDirection())) {
                            toDate = LocalDate.parse(f.getValue());
                        }
                    }
                    if (!"extension".equalsIgnoreCase(f.getFieldName())) continue;
                    extension = f.getValue();
                }
            }
            if (search != null && sortBy != null) {
                switch (sortBy) {
                    case "extensionNo": {
                        extension = search;
                        break;
                    }
                    case "calledNo": {
                        callerId = search;
                        break;
                    }
                    case "callType": {
                        callType = search;
                        break;
                    }
                }
            }
            if (extension != null && extension.trim().isEmpty()) {
                extension = null;
            }
            if ((rawRows = this.billingCDRRepository.extensionDetailsIn(fromDate, toDate, extension, callerId, callType)) == null || rawRows.isEmpty()) {
                return ResponseEntity.noContent().build();
            }
            List data = rawRows.stream().map(arg_0 -> this.mapToExtensionWiseReport(arg_0)).collect(Collectors.toList());
            LinkedHashMap<String, String> headerMap = new LinkedHashMap<String, String>();
            headerMap.put("extensionNo", "Extension No");
            headerMap.put("calledNo", "Called Number");
            headerMap.put("callDate", "Call Date");
            headerMap.put("callType", "Call Type");
            headerMap.put("talkDuration", "Talk Time");
            headerMap.put("ringDuration", "Ring Time");
            headerMap.put("connected", "Connected");
            headerMap.put("transferAgent", "Transfer Agent");
            headerMap.put("transfer", "Transfer");
            ArrayList columns = new ArrayList(headerMap.keySet());
            StringWriter writer = new StringWriter();
            CSVPrinter csvPrinter = new CSVPrinter((Appendable)writer, CSVFormat.DEFAULT.withHeader(headerMap.values().toArray(new String[0])));
            for (ExtensionWiseReportModel item : data) {
                ArrayList<String> row = new ArrayList<String>();
                Iterator iterator = columns.iterator();
                while (iterator.hasNext()) {
                    String col;
                    switch (col = (String)iterator.next()) {
                        case "extensionNo": {
                            row.add(this.safe((Object)item.getExtensionNo()));
                            break;
                        }
                        case "calledNo": {
                            row.add(this.safe((Object)item.getCalledNo()));
                            break;
                        }
                        case "callDate": {
                            row.add(this.safe((Object)item.getCallDate()));
                            break;
                        }
                        case "callType": {
                            row.add(this.safe((Object)item.getCallType()));
                            break;
                        }
                        case "talkDuration": {
                            row.add(this.formatSecondsToHHMMSS((Object)item.getTalkDuration()));
                            break;
                        }
                        case "ringDuration": {
                            row.add(this.formatSecondsToHHMMSS((Object)item.getRingDuration()));
                            break;
                        }
                        case "connected": {
                            row.add(this.safe((Object)item.getConnected()));
                            break;
                        }
                        case "transferAgent": {
                            row.add(this.safe((Object)item.getTransferAgent()));
                            break;
                        }
                        case "transfer": {
                            row.add(this.safe((Object)item.getTransfer()));
                        }
                    }
                }
                csvPrinter.printRecord(row);
            }
            csvPrinter.flush();
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=extension_in_report.csv"})).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)writer.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            logger.error("Extension CSV download failed", (Throwable)e);
            return ResponseEntity.internalServerError().build();
        }
    }

    private ExtensionWiseReportModel mapToExtensionWiseReport(Object[] row) {
        return new ExtensionWiseReportModel(this.safe(row[0]), this.safe(row[1]), this.safe(row[2]), this.safe(row[3]), this.safe(row[4]), this.safe(row[5]), this.safe(row[6]), this.safe(row[7]), this.safe(row[8]), this.safe(row[9]), this.safe(row[10]));
    }

    private String safe(Object v) {
        return v != null ? v.toString() : "";
    }

    @PostMapping(value={"/generateAndDownloadPdf"})
    public CompletableFuture<ResponseEntity<?>> generateAndDownloadPdf(@RequestParam String reportType, @RequestBody SearchRequest searchRequestData, Principal principal) {
        String folderPath = "/tmp/";
        File folder = new File(folderPath);
        String fileNamePrefix = reportType + "_";
        File[] files = folder.listFiles((dir, name) -> name.startsWith(fileNamePrefix));
        if (files != null) {
            for (File file : files) {
                if (file.delete()) {
                    logger.info("Deleted existing report: {}" + file.getName());
                    continue;
                }
                logger.error("Failed to delete existing report: {}" + file.getName());
            }
        }
        String filePath = "/tmp/" + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        CompletableFuture generationFuture = this.dynamicReportThreadService.startGeneratingReportAsync(reportType, id, searchRequestData, filePath, principal);
        return generationFuture.thenApply(response -> {
            if (response.getStatus().equals((Object)Constants.Error.OK)) {
                ResponseEntity downloadResponse = this.pdfDownloadService.getPdfFile(filePath);
                if (downloadResponse.getStatusCode().is2xxSuccessful()) {
                    return ResponseEntity.ok().body(downloadResponse.getBody());
                }
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to download PDF. Reason: " + downloadResponse.getStatusCode()));
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(response);
        });
    }

    @PostMapping(value={"/listExtensionDetail"})
    public ResponseEntity<RequestResponse> getAllExtensionDetailByFilter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.extensionCDRService.getCallerSummary(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/downloadCSVextensionSummaryDetail"})
    public ResponseEntity<byte[]> downloadCSVextensionSummaryDetail(@RequestBody SearchRequest request) {
        try {
            List rawRows;
            String search;
            LocalDate fromDate = null;
            LocalDate toDate = null;
            String callerId = null;
            if (request.getSearch() != null && !request.getSearch().trim().isEmpty()) {
                callerId = request.getSearch().trim();
            }
            if (request.getAdvancedFilters() != null) {
                for (AdvanceFilter f : request.getAdvancedFilters()) {
                    if ("date".equalsIgnoreCase(f.getDataType()) && "callDate".equalsIgnoreCase(f.getFieldName())) {
                        if ("from".equalsIgnoreCase(f.getDirection())) {
                            fromDate = LocalDate.parse(f.getValue());
                        }
                        if ("to".equalsIgnoreCase(f.getDirection())) {
                            toDate = LocalDate.parse(f.getValue());
                        }
                    }
                    if (!"callerId".equalsIgnoreCase(f.getFieldName())) continue;
                    callerId = f.getValue();
                }
            }
            if (callerId != null && callerId.trim().isEmpty()) {
                callerId = null;
            }
            if ((search = request.getSearch()) != null) {
                search = search.trim();
            }
            if ((rawRows = this.billingCDRRepository.getCallerSummary(fromDate, toDate, callerId, search)) == null || rawRows.isEmpty()) {
                return ResponseEntity.noContent().build();
            }
            List data = rawRows.stream().map(arg_0 -> this.mapToCallerSummary(arg_0)).collect(Collectors.toList());
            LinkedHashMap headerMap = this.getCsvHeaderMap();
            ArrayList columns = new ArrayList(headerMap.keySet());
            StringWriter writer = new StringWriter();
            CSVPrinter csvPrinter = new CSVPrinter((Appendable)writer, CSVFormat.DEFAULT.withHeader(headerMap.values().toArray(new String[0])));
            for (CallerSummaryModel item : data) {
                ArrayList<String> row = new ArrayList<String>();
                Iterator iterator = columns.iterator();
                while (iterator.hasNext()) {
                    String col;
                    switch (col = (String)iterator.next()) {
                        case "callerId": {
                            row.add(item.getCallerId());
                            break;
                        }
                        case "intercomCall": {
                            row.add(String.valueOf(item.getIntercomCall()));
                            break;
                        }
                        case "intercomCost": {
                            row.add(item.getIntercomCost());
                            break;
                        }
                        case "localCall": {
                            row.add(String.valueOf(item.getLocalCall()));
                            break;
                        }
                        case "localCost": {
                            row.add(item.getLocalCost());
                            break;
                        }
                        case "stdCall": {
                            row.add(String.valueOf(item.getStdCall()));
                            break;
                        }
                        case "stdCost": {
                            row.add(item.getStdCost());
                            break;
                        }
                        case "isdCall": {
                            row.add(String.valueOf(item.getIsdCall()));
                            break;
                        }
                        case "isdCost": {
                            row.add(item.getIsdCost());
                            break;
                        }
                        case "totalCall": {
                            row.add(String.valueOf(item.getTotalCall()));
                            break;
                        }
                        case "totalCost": {
                            row.add(item.getTotalCost());
                        }
                    }
                }
                csvPrinter.printRecord(row);
            }
            csvPrinter.flush();
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=caller_summary.csv"})).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)writer.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            logger.error("CSV download failed", (Throwable)e);
            return ResponseEntity.internalServerError().build();
        }
    }

    private CallerSummaryModel mapToCallerSummary(Object[] row) {
        CallerSummaryModel model = new CallerSummaryModel();
        model.setCallerId(String.valueOf(row[0]));
        model.setIntercomCall(this.toLong(row[1]));
        model.setIntercomCost(this.formatAmount(this.toLong(row[2])));
        model.setLocalCall(this.toLong(row[3]));
        model.setLocalCost(this.formatAmount(this.toLong(row[4])));
        model.setStdCall(this.toLong(row[5]));
        model.setStdCost(this.formatAmount(this.toLong(row[6])));
        model.setIsdCall(this.toLong(row[7]));
        model.setIsdCost(this.formatAmount(this.toLong(row[8])));
        model.setTotalCall(this.toLong(row[9]));
        model.setTotalCost(this.formatAmount(this.toLong(row[10])));
        return model;
    }

    private Long toLong(Object val) {
        return val == null ? 0L : ((Number)val).longValue();
    }

    private Double toDouble(Object val) {
        if (val == null) {
            return 0.0;
        }
        if (val instanceof BigDecimal) {
            return ((BigDecimal)val).doubleValue();
        }
        return ((Number)val).doubleValue();
    }

    private String formatAmount(Long val) {
        Long costInPaise = val != null ? val : 0L;
        double costInRupees = (double)costInPaise.longValue() / 100.0;
        return String.valueOf(costInRupees);
    }

    private LinkedHashMap<String, String> getCsvHeaderMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("callerId", "Extension No");
        map.put("intercomCall", "Intercom Call");
        map.put("intercomCost", "Intercom Cost");
        map.put("localCall", "Local Call");
        map.put("localCost", "Local Cost");
        map.put("stdCall", "STD Call");
        map.put("stdCost", "STD Cost");
        map.put("isdCall", "ISD Call");
        map.put("isdCost", "ISD Cost");
        map.put("totalCall", "Total Call");
        map.put("totalCost", "Total Cost");
        return map;
    }

    @PostMapping(value={"/generateAndDownloadextensionDetailPdf"})
    public CompletableFuture<ResponseEntity<?>> generateAndDownloadextensionDetailPdf(@RequestParam String reportType, @RequestBody SearchRequest searchRequestData, Principal principal) {
        String folderPath = "/tmp/";
        File folder = new File(folderPath);
        String fileNamePrefix = reportType + "_";
        File[] files = folder.listFiles((dir, name) -> name.startsWith(fileNamePrefix));
        if (files != null) {
            for (File file : files) {
                if (file.delete()) {
                    logger.info("Deleted existing report: {}" + file.getName());
                    continue;
                }
                logger.error("Failed to delete existing report: {}" + file.getName());
            }
        }
        String filePath = "/tmp/" + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        CompletableFuture generationFuture = this.dynamicReportThreadService.startGeneratingReportAsync(reportType, id, searchRequestData, filePath, principal);
        return generationFuture.thenApply(response -> {
            if (response.getStatus().equals((Object)Constants.Error.OK)) {
                ResponseEntity downloadResponse = this.pdfDownloadService.getPdfFile(filePath);
                if (downloadResponse.getStatusCode().is2xxSuccessful()) {
                    return ResponseEntity.ok().body(downloadResponse.getBody());
                }
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to download PDF. Reason: " + downloadResponse.getStatusCode()));
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(response);
        });
    }

    private String formatSecondsToHHMMSS(Object value) {
        long seconds;
        if (value == null) {
            return "00:00:00";
        }
        try {
            seconds = Long.parseLong(value.toString());
        }
        catch (NumberFormatException e) {
            return "00:00:00";
        }
        long hrs = seconds / 3600L;
        long mins = seconds % 3600L / 60L;
        long secs = seconds % 60L;
        return String.format("%02d:%02d:%02d", hrs, mins, secs);
    }

    static {
        columnMappings.put("extensionNo", "Extension No");
        columnMappings.put("callDate", "Call Date");
        columnMappings.put("calledNo", "Called Number");
        columnMappings.put("callType", "Call Type");
        columnMappings.put("talkDuration", "Talk Time");
        columnMappings.put("ringDuration", "Ring Time");
        columnMappings.put("coralCallDirection", "Call Direction");
        columnMappings.put("coralFeatureCode", "Feature Code");
        columnMappings.put("connected", "Connected");
        columnMappings.put("transferAgent", "Transfer Agent");
        columnMappings.put("transfer", "Transfer");
        INR_FORMAT = NumberFormat.getCurrencyInstance(new Locale("en", "IN"));
    }
}

