/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.coralnms.widgetType.service;

import com.coraltele.db.telemetry.coralnms.entity.WidgetType;
import com.coraltele.db.telemetry.coralnms.repository.WidgetTypeRepository;
import com.coraltele.db.telemetry.coralnms.specification.WidgetTypeSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.coralnms.widgetType.model.WidgetTypeModel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class WidgetTypeService {
    private static final Logger logger = LogManager.getLogger(WidgetTypeService.class);
    @Autowired
    WidgetTypeRepository widgetTypeRepository;

    public RequestResponse create(WidgetTypeModel data) {
        logger.debug("create new widgetType : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            WidgetType widgetType = new WidgetType();
            widgetType.setCode(data.getCode());
            widgetType.setDescription(data.getDescription());
            widgetType.setExport(data.getExport().booleanValue());
            this.widgetTypeRepository.save((Object)widgetType);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("WidgetType Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable To Create WidgetType");
            returnValue.setMessageDetail("Contact With Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse update(WidgetTypeModel data) {
        WidgetType widgetType;
        logger.debug("Update WidgetType {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional dataFound = this.widgetTypeRepository.findById(data.getId());
        if (dataFound.isPresent()) {
            widgetType = (WidgetType)dataFound.get();
            if (data.getCode() != null) {
                widgetType.setCode(data.getCode());
            }
            if (data.getDescription() != null) {
                widgetType.setDescription(data.getDescription());
            }
            if (data.getExport() != null) {
                widgetType.setExport(data.getExport().booleanValue());
            }
        } else {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found");
            returnValue.setMessageDetail("WidgetType Not Found");
            logger.error(returnValue.getMessage());
            return returnValue;
        }
        this.widgetTypeRepository.save((Object)widgetType);
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("WidgetType Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse delete(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Long id : data.getId()) {
            Optional widgetType = this.widgetTypeRepository.findById(Integer.valueOf(id.intValue()));
            if (!widgetType.isPresent()) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage(MessageFormat.format("Record Not Found With Id => {}", id));
                logger.info(returnValue.getMessage());
                return returnValue;
            }
            addValue.add(widgetType.get());
            this.widgetTypeRepository.deleteAll(addValue);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Has Been Deleted");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getList(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = WidgetTypeSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.widgetTypeRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.widgetTypeRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAll() {
        List list = this.widgetTypeRepository.findByIdNot(Integer.valueOf(9));
        ArrayList<WidgetTypeModel> addValue = new ArrayList<WidgetTypeModel>();
        RequestResponse returnValue = new RequestResponse();
        for (WidgetType widgetType : list) {
            WidgetTypeModel data = new WidgetTypeModel();
            data.setId(widgetType.getId());
            data.setCode(widgetType.getCode());
            data.setDescription(widgetType.getDescription());
            if (widgetType.isExport()) {
                data.setExport(Boolean.valueOf(widgetType.isExport()));
            }
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

