/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.manufacturer.service;

import com.coraltele.db.telephony.pbx.entity.CLIServerCommandLog;
import com.coraltele.db.telephony.pbx.entity.Manufacturer;
import com.coraltele.db.telephony.pbx.repository.ManufacturerRepository;
import com.coraltele.db.telephony.pbx.specification.ManufacturerSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.helper.ReturnField;
import com.coraltele.model.CliCommandData;
import com.coraltele.model.InputAction;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.cLIServerCommandLog.service.CLIServerCommandLogService;
import com.coraltele.service.pbx.manufacturer.model.ManufacturerModel;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class ManufacturerService {
    private static final Logger logger = LogManager.getLogger(ManufacturerService.class);
    @Autowired
    private ManufacturerRepository manufacturerRepository;
    @Autowired
    private CLIServerCommandLogService cLIServerCommandLogService;

    public RequestResponse createManufacturer(ManufacturerModel data) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Manufacturer manufacturer = new Manufacturer();
            manufacturer.setCode(data.getCode());
            manufacturer.setCreatedOn(LocalDateTime.now());
            manufacturer.setDescription(data.getDescription());
            this.manufacturerRepository.save((Object)manufacturer);
            ReturnField field = new ReturnField();
            field.setId(manufacturer.getId().intValue());
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("manufacturer Registered");
            returnValue.setMessageDetail("manufacturer created successfully");
            returnValue.setData((Object)field);
            logger.info("DidMapping saved : {}", (Object)returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("unable to create manufacturer");
            returnValue.setMessageDetail("Contact with administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getById(int id) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional manufacturer = this.manufacturerRepository.findById(Integer.valueOf(id));
            if (manufacturer.isPresent()) {
                ManufacturerModel data = new ManufacturerModel();
                data.setCode(((Manufacturer)manufacturer.get()).getCode());
                data.setCreatedOn(((Manufacturer)manufacturer.get()).getCreatedOn());
                data.setDescription(((Manufacturer)manufacturer.get()).getDescription());
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Manufacturer Found");
                returnValue.setData((Object)data);
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Unable to return value");
                returnValue.setMessageDetail("Records not found");
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to return value");
            returnValue.setMessageDetail("contact with administrator");
        }
        return returnValue;
    }

    public RequestResponse getAll() {
        List list = (List)this.manufacturerRepository.findAll();
        ArrayList<ManufacturerModel> addValue = new ArrayList<ManufacturerModel>();
        RequestResponse returnValue = new RequestResponse();
        for (Manufacturer manufacturer : list) {
            ManufacturerModel data = new ManufacturerModel();
            data.setId(manufacturer.getId());
            data.setCode(manufacturer.getCode());
            data.setDescription(manufacturer.getDescription());
            data.setCreatedOn(manufacturer.getCreatedOn());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        return returnValue;
    }

    public RequestResponse updateManufacturer(HttpServletRequest request, ManufacturerModel data, Authentication authentication) {
        logger.debug("Update InboundCos {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional manufacturer = this.manufacturerRepository.findById(data.getId());
            if (manufacturer.isPresent()) {
                ((Manufacturer)manufacturer.get()).setCode(data.getCode());
                ((Manufacturer)manufacturer.get()).setDescription(data.getDescription());
                this.manufacturerRepository.save(manufacturer.get());
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Updated");
                returnValue.setMessageDetail("Manufacturer Updated successfully");
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("Manufacturer not found");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to update Manufacturer");
            returnValue.setMessageDetail("please Contact to administrator");
            logger.error("error while fetching the data.", (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse deleteManufacturer(int id) {
        RequestResponse returnValue = new RequestResponse();
        Optional manufacturer = this.manufacturerRepository.findById(Integer.valueOf(id));
        if (!manufacturer.isPresent()) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to delete");
            returnValue.setMessageDetail(String.format("Data not found in manufacturer : %s ", id));
        } else {
            this.manufacturerRepository.deleteById((Object)id);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("deleted");
            returnValue.setMessageDetail("Record deleted successfully");
        }
        return returnValue;
    }

    public void saveData(HttpServletRequest request, Manufacturer manufacturer, Authentication authentication) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper().findAndRegisterModules();
        Map newMap = (Map)new ObjectMapper().readValue((InputStream)request.getInputStream(), Map.class);
        Set entrySet = newMap.entrySet();
        Iterator iterator = entrySet.iterator();
        ArrayList<InputAction> addValue = new ArrayList<InputAction>();
        CliCommandData cliCommandData = new CliCommandData();
        try {
            if (manufacturer.getId() != null && this.manufacturerRepository.findById(manufacturer.getId()).isPresent()) {
                Optional oldData = this.manufacturerRepository.findById(manufacturer.getId());
                Map oldMap = (Map)objectMapper.convertValue(oldData.get(), Map.class);
                while (iterator.hasNext()) {
                    Map.Entry mapEntry = iterator.next();
                    InputAction inputValue = new InputAction();
                    inputValue.setFieldName(mapEntry.getKey());
                    inputValue.setNewValue(mapEntry.getValue());
                    for (Map.Entry set : oldMap.entrySet()) {
                        if (!mapEntry.getKey().equals(set.getKey())) continue;
                        inputValue.setOldValue(set.getValue());
                    }
                    addValue.add(inputValue);
                }
                cliCommandData.setData(addValue);
                cliCommandData.setEntity("m_manufacturer");
                String dataReceived = objectMapper.writeValueAsString(addValue);
                CLIServerCommandLog dataLogs = new CLIServerCommandLog();
                dataLogs.setCLICommand(dataReceived);
                dataLogs.setRecordSource("dl");
                dataLogs.setServerCode("");
                dataLogs.setRecordCreatedBy(authentication.getName());
                dataLogs.setRecordCreatedOn(LocalDateTime.now());
                dataLogs.setOutputFileName("Name");
                dataLogs.setOutputFilePath("");
                this.cLIServerCommandLogService.save(dataLogs);
            }
        }
        catch (JsonProcessingException e) {
            logger.info((Object)e);
        }
    }

    public RequestResponse deleteById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional manufacturer = this.manufacturerRepository.findById(ids);
            if (manufacturer.isPresent()) {
                addValue.add(manufacturer.get());
                this.manufacturerRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Manufacturer Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = ManufacturerSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.manufacturerRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.manufacturerRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

