/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.fwdExtension.service;

import com.coraltele.db.billing.main.entity.PdfReportFilters;
import com.coraltele.db.billing.main.repository.PdfReportRepository;
import com.coraltele.db.telephony.pbx.entity.FwdExtension;
import com.coraltele.db.telephony.pbx.repository.FwdExtensionRepository;
import com.coraltele.db.telephony.pbx.specification.FwdExtensionSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.PdfPageNumberEvent;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.AdvanceFilter;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.background.PdfGeneratorService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.itextpdf.text.BadElementException;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Principal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service(value="fwdExtension")
public class FwdExtensionPdf
implements PdfGeneratorService {
    private static final Logger logger = LogManager.getLogger(FwdExtensionPdf.class);
    private static String reportFileName = "Forward Extension";
    private static String reportFileNameDateFormat = "dd_MMMM_yyyy";
    private static String localDateFormat = "dd-MM-yyyy hh:mm:ss a";
    LocalDateTime currentTime = null;
    private static String logoImgPath = "/var/www/html/apple-icon.png";
    private static int noOfColumns = 0;
    @Autowired
    FwdExtensionRepository fwdExtensionRepository;
    @Autowired
    DynamicPdfThreadService generatingReports;
    @Autowired
    private PdfReportRepository pdfReportRepository;
    @Autowired
    PdfPageNumberEvent pageNumberEvent;
    @Autowired
    DateFormatUtility dateFormatUtility;
    private static Font COURIER = new Font(Font.FontFamily.COURIER, 20.0f, 1);
    private static Font COURIER_SMALL = new Font(Font.FontFamily.COURIER, 14.0f, 1);
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();

    public void init(LocalDateTime currentTime) {
        try {
            this.pageNumberEvent.initialize(logoImgPath, reportFileName, localDateFormat, currentTime);
        }
        catch (BadElementException | IOException e) {
            e.printStackTrace();
        }
    }

    public RequestResponse generatePdfReport(SearchRequest searchRequestData, String filePath, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        this.currentTime = LocalDateTime.now();
        this.init(this.currentTime);
        logger.info("Start generating pdf for matched columns:");
        try {
            noOfColumns = searchRequestData.getColumnNames().size();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Document document = noOfColumns > 5 ? new Document(PageSize.A3.rotate()) : new Document(PageSize.A4);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
            writer.setPageEvent((PdfPageEvent)this.pageNumberEvent);
            document.open();
            this.addLogoAndDocTitle(document, searchRequestData, Integer.valueOf(noOfColumns));
            if (searchRequestData.advancedFilters != null && !searchRequestData.advancedFilters.isEmpty()) {
                FwdExtensionPdf.addAdvanceFilterRequest((Document)document, (SearchRequest)searchRequestData);
            }
            document.newPage();
            this.createTable(document, noOfColumns, searchRequestData);
            document.close();
            byte[] pdfBytes = byteArrayOutputStream.toByteArray();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
            String filename = this.getPdfNameWithDate();
            this.savePdfToDestination(pdfBytes, filePath);
            headers.setContentDispositionFormData(filename, filename);
            headers.setCacheControl("must-revalidate, post-check=0, pre-check=0");
            logger.info("PDF generated successfully and saved to: {}", (Object)filePath);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("File generated and saved successfully");
            returnValue.setData((Object)filePath);
            logger.info("NMS report generated and saved successfully");
            return returnValue;
        }
        catch (DocumentException e) {
            e.printStackTrace();
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("failed to download");
            logger.info("NMS report failed to download");
            return returnValue;
        }
    }

    private void addLogoAndDocTitle(Document document, SearchRequest filterRequest, Integer columns) {
        try {
            logger.info("finding logo from location");
            PdfPTable table = new PdfPTable(1);
            table.setWidthPercentage(100.0f);
            PdfPCell logoCell = new PdfPCell();
            logoCell.setHorizontalAlignment(1);
            logoCell.setBorder(0);
            Image img = Image.getInstance((String)logoImgPath);
            if (columns > 5) {
                img.scaleAbsolute(document.getPageSize().getWidth() * 0.5f, document.getPageSize().getHeight() * 0.4f);
                img.setAlignment(1);
                logoCell.addElement((Element)img);
            } else {
                img.scaleAbsolute(document.getPageSize().getWidth() * 0.7f, document.getPageSize().getHeight() * 0.4f);
                img.setAlignment(1);
                logoCell.addElement((Element)img);
            }
            PdfPCell reportNameCell = new PdfPCell();
            reportNameCell.setHorizontalAlignment(1);
            reportNameCell.setBorder(0);
            Paragraph p1 = new Paragraph(reportFileName, COURIER);
            reportNameCell.addElement((Element)p1);
            PdfPCell dateTimeCell = new PdfPCell();
            dateTimeCell.setHorizontalAlignment(1);
            dateTimeCell.setBorder(0);
            String localDateString = this.currentTime.format(DateTimeFormatter.ofPattern(localDateFormat));
            Paragraph p2 = new Paragraph("Report generated on " + localDateString, COURIER_SMALL);
            dateTimeCell.addElement((Element)p2);
            table.addCell(logoCell);
            table.addCell(reportNameCell);
            table.addCell(dateTimeCell);
            document.add((Element)table);
            logger.info("successfully found logo for pdf");
        }
        catch (DocumentException | IOException e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
    }

    private void createTable(Document document, int noOfColumns, SearchRequest searchRequestData) throws DocumentException {
        try {
            logger.info("Starting creation of table for pdf");
            Specification filters = FwdExtensionSpecification.generateFilters((SearchRequest)searchRequestData);
            Sort sort = null;
            if (searchRequestData.sortDirection.equals("asc")) {
                sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
            } else if (searchRequestData.sortDirection.equals("desc")) {
                sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
            }
            List filteredData = sort != null ? this.fwdExtensionRepository.findAll(filters, sort) : this.fwdExtensionRepository.findAll(filters);
            PdfPTable table = new PdfPTable(searchRequestData.getColumnNames().size());
            for (String columnName : searchRequestData.getColumnNames()) {
                BaseColor lightBlue = new BaseColor(2, 111, 194);
                PdfPCell cell = new PdfPCell(new Phrase((String)columnMappings.get(columnName), new Font(Font.FontFamily.HELVETICA, 12.0f, 1, BaseColor.WHITE)));
                cell.setHorizontalAlignment(1);
                cell.setBackgroundColor(lightBlue);
                cell.setBorder(0);
                table.addCell(cell);
            }
            table.setHeaderRows(1);
            this.getDbData(table, filteredData, searchRequestData.getColumnNames());
            document.add((Element)table);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
    }

    private void getDbData(PdfPTable table, List<FwdExtension> filteredData, List<String> columnNames1) {
        try {
            BaseColor lightBackground = new BaseColor(230, 230, 230);
            for (int rowIndex = 0; rowIndex < filteredData.size(); ++rowIndex) {
                FwdExtension fwdExtension = filteredData.get(rowIndex);
                table.setWidthPercentage(100.0f);
                table.getDefaultCell().setHorizontalAlignment(1);
                table.getDefaultCell().setVerticalAlignment(5);
                table.getDefaultCell().setBorder(0);
                if (rowIndex % 2 == 0) {
                    table.getDefaultCell().setBackgroundColor(BaseColor.WHITE);
                } else {
                    table.getDefaultCell().setBackgroundColor(lightBackground);
                }
                Iterator<String> iterator = columnNames1.iterator();
                while (iterator.hasNext()) {
                    String columnName;
                    switch (columnName = iterator.next()) {
                        case "createdOn": {
                            table.addCell(this.getCellValue(fwdExtension.getCreatedOn().toString()));
                            break;
                        }
                        case "createdBy": {
                            table.addCell(this.getCellValue(fwdExtension.getCreatedBy()));
                            break;
                        }
                        case "extension": {
                            table.addCell(this.getCellValue(fwdExtension.getExtension()));
                            break;
                        }
                        case "sunday": {
                            if (fwdExtension.getSunday() != null && fwdExtension.getSunday() == 1) {
                                table.addCell("Yes");
                                break;
                            }
                            table.addCell("No");
                            break;
                        }
                        case "monday": {
                            if (fwdExtension.getMonday() != null && fwdExtension.getMonday() == 1) {
                                table.addCell("Yes");
                                break;
                            }
                            table.addCell("No");
                            break;
                        }
                        case "tuesday": {
                            if (fwdExtension.getTuesday() != null && fwdExtension.getTuesday() == 1) {
                                table.addCell("Yes");
                                break;
                            }
                            table.addCell("No");
                            break;
                        }
                        case "wednesday": {
                            if (fwdExtension.getWednesday() != null && fwdExtension.getWednesday() == 1) {
                                table.addCell("Yes");
                                break;
                            }
                            table.addCell("No");
                            break;
                        }
                        case "thursday": {
                            if (fwdExtension.getThursday() != null && fwdExtension.getThursday() == 1) {
                                table.addCell("Yes");
                                break;
                            }
                            table.addCell("No");
                            break;
                        }
                        case "friday": {
                            if (fwdExtension.getFriday() != null && fwdExtension.getFriday() == 1) {
                                table.addCell("Yes");
                                break;
                            }
                            table.addCell("No");
                            break;
                        }
                        case "saturday": {
                            if (fwdExtension.getSaturday() != null && fwdExtension.getSaturday() == 1) {
                                table.addCell("Yes");
                                break;
                            }
                            table.addCell("No");
                            break;
                        }
                        case "fromTime": {
                            table.addCell(this.getCellValue(fwdExtension.getFromTime().toString()));
                            break;
                        }
                        case "toTime": {
                            table.addCell(this.getCellValue(fwdExtension.getToTime().toString()));
                            break;
                        }
                        case "forwardExtension": {
                            table.addCell(this.getCellValue(fwdExtension.getForwardExtension()));
                            break;
                        }
                        case "updatedOn": {
                            table.addCell(this.getCellValue(fwdExtension.getUpdatedOn().toString()));
                            break;
                        }
                        case "updatedBy": {
                            table.addCell(this.getCellValue(fwdExtension.getUpdatedBy()));
                            break;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
    }

    private String getCellValue(String value) {
        return value != null && !value.isEmpty() ? value : "";
    }

    private static void leaveEmptyLine(Paragraph paragraph, int number) {
        for (int i = 0; i < number; ++i) {
            paragraph.add((Element)new Paragraph(" "));
        }
    }

    private String getPdfNameWithDate() {
        String localDateString = LocalDateTime.now().format(DateTimeFormatter.ofPattern(reportFileNameDateFormat));
        return reportFileName + "-" + localDateString + ".pdf";
    }

    private static void addAdvanceFilterRequest(Document document, SearchRequest searchRequestData) throws DocumentException {
        List advancedFilters = searchRequestData.getAdvancedFilters();
        if (advancedFilters != null && !advancedFilters.isEmpty()) {
            Paragraph advancedFilterParagraph = new Paragraph();
            Font boldFont = new Font(Font.FontFamily.HELVETICA, 14.0f, 1);
            for (AdvanceFilter advanceFilter : advancedFilters) {
                advancedFilterParagraph.setFont(boldFont);
                if ("from".equals(advanceFilter.getDirection())) {
                    advancedFilterParagraph.add("Record on the basis of " + (String)columnMappings.get(advanceFilter.getFieldName()) + ": From " + advanceFilter.getValue());
                    continue;
                }
                if (!"to".equals(advanceFilter.getDirection())) continue;
                advancedFilterParagraph.add(" to " + advanceFilter.getValue());
                advancedFilterParagraph.add((Element)new Paragraph(""));
            }
            document.add((Element)advancedFilterParagraph);
        }
    }

    private void savePdfToDestination(byte[] pdfBytes, String destinationPath) {
        try (FileOutputStream fos = new FileOutputStream(destinationPath);){
            fos.write(pdfBytes);
            logger.info("PDF saved to: {}", (Object)destinationPath);
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("Failed to save PDF to: {}", (Object)destinationPath);
        }
    }

    public void createPdfReportRecord(String id, SearchRequest data, String filePath) {
        try {
            PdfReportFilters pdfReportFilters = new PdfReportFilters();
            ObjectMapper objectMapper = new ObjectMapper();
            pdfReportFilters.setId(id);
            pdfReportFilters.setReportName(reportFileName);
            pdfReportFilters.setFilterParameters(objectMapper.writeValueAsString((Object)data));
            pdfReportFilters.setCreatedOnDate(this.currentTime);
            pdfReportFilters.setPdfLocation(filePath);
            pdfReportFilters.setStatus("InProgress");
            this.pdfReportRepository.save((Object)pdfReportFilters);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

    static {
        columnMappings.put("createdOn", "Created On");
        columnMappings.put("createdBy", "Created By");
        columnMappings.put("extension", "Extension");
        columnMappings.put("sunday", "Sunday");
        columnMappings.put("monday", "Monday");
        columnMappings.put("tuesday", "Tuesday");
        columnMappings.put("wednesday", "Wednesday");
        columnMappings.put("thursday", "Thursday");
        columnMappings.put("friday", "Friday");
        columnMappings.put("saturday", "Saturday");
        columnMappings.put("fromTime", "From Time");
        columnMappings.put("toTime", "To Time");
        columnMappings.put("forwardExtension", "Forward Extension");
        columnMappings.put("updatedOn", "Updated On");
        columnMappings.put("updatedBy", "Updated By");
    }
}

