/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.coralApps.main.whatsAppHistory.service;

import com.coraltele.db.coralapps.main.entity.WhatsAppHistory;
import com.coraltele.db.coralapps.main.entity.WhatsAppMember;
import com.coraltele.db.coralapps.main.repository.WhatsAppHistoryRepository;
import com.coraltele.db.coralapps.main.repository.WhatsAppMemberRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.coralApps.main.whatsAppHistory.model.AgentMsgModel;
import com.coraltele.service.coralApps.main.whatsAppHistory.model.CustomerMsgModel;
import com.coraltele.service.coralApps.main.whatsAppHistory.model.WhatsAppHistoryModel;
import com.coraltele.service.coralApps.main.whatsAppHistory.service.CustomerMsgService;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WhatsAppHistoryService {
    private static final Logger logger = LogManager.getLogger(WhatsAppHistoryService.class);
    @Autowired
    WhatsAppHistoryRepository whatsAppHistoryRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    CustomerMsgService customerMsgService;
    @Autowired
    WhatsAppMemberRepository whatsAppMemberRepository;

    public RequestResponse getByCustomerNumber(String customerNumber) {
        RequestResponse returnValue = new RequestResponse();
        List listOfMsg = this.whatsAppHistoryRepository.findByCustomerNumberOrderByMessageEpochAsc(customerNumber);
        ArrayList<WhatsAppHistoryModel> addValue = new ArrayList<WhatsAppHistoryModel>();
        if (!listOfMsg.isEmpty()) {
            for (WhatsAppHistory row : listOfMsg) {
                WhatsAppHistoryModel data = new WhatsAppHistoryModel();
                data.setAgentId(row.getAgentId());
                data.setMessageEpoch(Long.valueOf(row.getMessageEpoch()));
                data.setMessage(row.getMessages());
                data.setType(row.getResponseType());
                data.setCustomerNumber(row.getCustomerNumber());
                addValue.add(data);
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("data retrieved successfully");
            returnValue.setMessageDetail("list of messages");
            returnValue.setData(addValue);
            logger.info("data get successfully of customer number");
        } else {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("not any message");
            returnValue.setMessageDetail("Records not found");
            logger.info("Record is not present for customer:{}", (Object)customerNumber);
        }
        return returnValue;
    }

    public RequestResponse msgByCustomer(CustomerMsgModel data) {
        RequestResponse returnValue = new RequestResponse();
        String agent = "agent31";
        String sessionId = UUID.randomUUID().toString();
        if (!this.customerMsgService.createSession(data, sessionId, agent)) {
            Optional whatsAppMember = this.whatsAppMemberRepository.findByServingAgent(agent);
            sessionId = ((WhatsAppMember)whatsAppMember.get()).getSessionUuid();
        }
        WhatsAppHistory record = new WhatsAppHistory();
        record.setAgentName(agent);
        record.setAgentId(agent);
        record.setCustomerNumber(data.getCustomerNumber());
        record.setMessageEpoch(Long.valueOf(System.currentTimeMillis()));
        record.setMessages(data.getMessage());
        record.setResponseType("customer");
        record.setQueue(data.getQueue());
        record.setSessionUuid(sessionId);
        this.whatsAppHistoryRepository.save((Object)record);
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("message sent successfully");
        logger.info("message sent from:{} ,to:{}", (Object)data.getCustomerNumber(), (Object)agent);
        return returnValue;
    }

    public RequestResponse msgByAgent(AgentMsgModel data) {
        RequestResponse returnValue = new RequestResponse();
        String agent = "agent31";
        String sessionId = "";
        Optional whatsAppMember = this.whatsAppMemberRepository.findByServingAgent(agent);
        if (whatsAppMember.isPresent()) {
            sessionId = ((WhatsAppMember)whatsAppMember.get()).getSessionUuid();
            WhatsAppHistory record = new WhatsAppHistory();
            record.setAgentName(agent);
            record.setAgentId(agent);
            record.setCustomerNumber(((WhatsAppMember)whatsAppMember.get()).getCustomerNumber());
            record.setMessageEpoch(Long.valueOf(System.currentTimeMillis()));
            record.setMessages(data.getMessage());
            record.setResponseType("agent");
            record.setQueue(((WhatsAppMember)whatsAppMember.get()).getQueue());
            record.setSessionUuid(sessionId);
            this.whatsAppHistoryRepository.save((Object)record);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("message sent successfully");
        } else {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Not any session present");
            logger.error("Not any pending message by customer or session");
        }
        return returnValue;
    }

    public RequestResponse sessionClose(String agent) {
        RequestResponse returnValue = new RequestResponse();
        String agent1 = "agent31";
        Optional whatsAppMember = this.whatsAppMemberRepository.findByServingAgent(agent1);
        if (whatsAppMember.isPresent()) {
            this.whatsAppMemberRepository.delete(whatsAppMember.get());
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("session closed successfully");
        } else {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("No any session present");
            logger.error("Not any pending session");
        }
        return returnValue;
    }
}

