/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.billing.main.broadcastMessageDetail.service;

import com.coraltele.db.billing.main.entity.BroadcastMessageDetail;
import com.coraltele.db.billing.main.repository.BroadcastMessageDetailRepository;
import com.coraltele.db.telephony.uc.entity.CustomerAccount;
import com.coraltele.db.telephony.uc.repository.CustomerAccountRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.ObjectTraverse;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.billing.main.broadcastMessageDetail.model.BroadcastMessageDetailModel;
import com.coraltele.service.billing.main.notification.service.NotificationService;
import com.coraltele.service.billing.main.uc_notification.service.UcNotificationService;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class BroadcastMessageDetailService {
    private static final Logger logger = LogManager.getLogger(BroadcastMessageDetailService.class);
    @Autowired
    BroadcastMessageDetailRepository broadcastMessageDetailRepository;
    @Autowired
    NotificationService notificationService;
    @Autowired
    UcNotificationService ucNotificationService;
    @Autowired
    CustomerAccountRepository customerAccountRepository;
    @Autowired
    ObjectTraverse objectTraverse;
    String message;

    public RequestResponse broadCastMessage(BroadcastMessageDetailModel data, Authentication authentication) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<String> ucUsers = new ArrayList<String>();
        for (Integer row : data.getDestinationUser()) {
            Optional customerAccountOptional = this.customerAccountRepository.findById((Object)row);
            if (customerAccountOptional.isPresent()) {
                ucUsers.add(((CustomerAccount)customerAccountOptional.get()).getProfileId());
                continue;
            }
            returnValue.setStatus(Constants.Error.BAD_INPUT_DATA);
            String message = MessageFormat.format("User => {0} Does Not Exist", row);
            returnValue.setMessage(message);
            returnValue.setMessageDetail("Kindly Enter Valid User");
            logger.error(message);
            return returnValue;
        }
        try {
            BroadcastMessageDetail broadcastMessageDetail = new BroadcastMessageDetail();
            broadcastMessageDetail.setSourceUser(authentication.getName());
            broadcastMessageDetail.setDestinationUser(this.objectTraverse.conversion(data.getDestinationUser()));
            broadcastMessageDetail.setMessage(data.getMessage());
            broadcastMessageDetail.setBroadcastType("_selection");
            broadcastMessageDetail.setCreatedOn(LocalDateTime.now());
            broadcastMessageDetail.setUuid(UUID.randomUUID().toString());
            this.broadcastMessageDetailRepository.save((Object)broadcastMessageDetail);
            this.notificationService.createNotification(data.getDestinationUser(), authentication.getName());
            this.ucNotificationService.updateMessageCount(ucUsers);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("BroadcastMessageDetail created");
            returnValue.setMessageDetail("Created successfully");
            logger.info(returnValue.getMessageDetail());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_INPUT_DATA);
            returnValue.setMessage("Unable to create");
            returnValue.setMessageDetail("Contact the administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }
}

