/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.billing.main.agentStatus.service;

import com.coraltele.db.billing.main.entity.AgentStatus;
import com.coraltele.db.billing.main.repository.AgentStatusRepository;
import com.coraltele.db.coralapps.main.entity.Agent;
import com.coraltele.db.coralapps.main.entity.Tiers;
import com.coraltele.db.coralapps.main.repository.AgentRepository;
import com.coraltele.db.coralapps.main.repository.TiersRepository;
import com.coraltele.db.telephony.pbx.repository.AgentQueueRepository;
import com.coraltele.db.users.main.entity.User;
import com.coraltele.db.users.main.entity.UserRole;
import com.coraltele.db.users.main.repository.UserRepository;
import com.coraltele.db.users.main.repository.UserRoleRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.billing.main.agentStatus.model.AgentStatusModel;
import com.coraltele.service.billing.main.agentStatus.model.AgentStatusReturn;
import com.coraltele.service.user.service.UserService;
import java.security.Principal;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AgentStatusService {
    private static final Logger logger = LogManager.getLogger(AgentStatusService.class);
    @Autowired
    AgentStatusRepository statusRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    AgentRepository agentRepository;
    @Autowired
    AgentQueueRepository agentQueueRepository;
    @Autowired
    TiersRepository tiersRepository;
    @Autowired
    UserRoleRepository userRoleRepository;
    @Autowired
    private UserService userService;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RequestResponse createData(AgentStatusModel data, Principal principal, HttpServletRequest request) {
        logger.debug("Create new AgentStatus : {} ", (Object)data);
        logger.info("status: {} ", (Object)data.getStatus());
        RequestResponse returnValue = new RequestResponse();
        try {
            block64: {
                Optional agentName;
                block57: {
                    Iterator iterator;
                    String defaultQueue;
                    Optional user;
                    block63: {
                        Optional agent;
                        block48: {
                            Iterator iterator2;
                            String defaultQueue2;
                            block54: {
                                block55: {
                                    block62: {
                                        block61: {
                                            block60: {
                                                block59: {
                                                    block58: {
                                                        block56: {
                                                            block46: {
                                                                Optional userInfo;
                                                                block53: {
                                                                    block52: {
                                                                        block51: {
                                                                            block50: {
                                                                                block49: {
                                                                                    block47: {
                                                                                        List userRole;
                                                                                        AgentStatus status = new AgentStatus();
                                                                                        userInfo = this.userRepository.findByUsername(principal.getName());
                                                                                        status.setUsername(principal.getName());
                                                                                        status.setStatus(data.getStatus());
                                                                                        status.setCurrentTime(LocalDateTime.now());
                                                                                        status.setCurrentTimeEpoch(Long.valueOf(this.getEpochSeconds(status.getCurrentTime())));
                                                                                        String clientIp = AgentStatusService.getClientIp((HttpServletRequest)request);
                                                                                        if (userInfo.isPresent()) {
                                                                                            if ("Login".equalsIgnoreCase(data.getStatus())) {
                                                                                                ((User)userInfo.get()).setIpAddress(clientIp);
                                                                                            } else if ("Logout".equalsIgnoreCase(data.getStatus())) {
                                                                                                ((User)userInfo.get()).setIpAddress("");
                                                                                                ((User)userInfo.get()).setUuidSecurity("");
                                                                                            }
                                                                                            this.userRepository.save(userInfo.get());
                                                                                        }
                                                                                        if (!(userRole = this.userRoleRepository.findByUser((User)userInfo.get())).isEmpty()) {
                                                                                            for (UserRole row : userRole) {
                                                                                                if (row.getRole().getShortCode().equalsIgnoreCase("ROLE_AGENT") || row.getRole().getShortCode().equalsIgnoreCase("ROLE_OCADMIN")) {
                                                                                                    status.setShowInReport("Y");
                                                                                                    continue;
                                                                                                }
                                                                                                status.setShowInReport("N");
                                                                                            }
                                                                                        }
                                                                                        if (((User)userInfo.get()).getContactNo() != null) {
                                                                                            status.setExtensionNo(((User)userInfo.get()).getContactNo());
                                                                                        }
                                                                                        if (((User)userInfo.get()).getDescription() != null) {
                                                                                            status.setUserFullname(((User)userInfo.get()).getDescription());
                                                                                        }
                                                                                        if (data.getStatus().equalsIgnoreCase("Login")) {
                                                                                            status.setUuid(UUID.randomUUID());
                                                                                            status.setPreviousTime(null);
                                                                                        } else {
                                                                                            List previousDataTime = this.statusRepository.findByUsernameOrderByIdDesc(principal.getName());
                                                                                            List uuid = this.statusRepository.findByUsernameAndStatusOrderByIdDesc(principal.getName(), "Login");
                                                                                            if (previousDataTime.size() != 0) {
                                                                                                AgentStatus pastData = (AgentStatus)previousDataTime.get(0);
                                                                                                status.setUuid(((AgentStatus)uuid.get(0)).getUuid());
                                                                                                status.setPreviousTime(pastData.getCurrentTime());
                                                                                                status.setPreviousTimeEpoch(pastData.getCurrentTimeEpoch());
                                                                                            }
                                                                                        }
                                                                                        if (data.getIsDataSynced() != null) {
                                                                                            status.setIsDataSynced(data.getIsDataSynced());
                                                                                        } else {
                                                                                            status.setIsDataSynced(Integer.valueOf(0));
                                                                                        }
                                                                                        if (!"Auto Dial".equalsIgnoreCase(data.getStatus())) {
                                                                                            this.statusRepository.save((Object)status);
                                                                                        }
                                                                                        user = this.userRepository.findByUsername(principal.getName());
                                                                                        if (data.getStatus() != null) {
                                                                                            ((User)user.get()).setStatus(data.getStatus());
                                                                                        }
                                                                                        this.userRepository.save(user.get());
                                                                                        agent = this.agentRepository.findByName(principal.getName());
                                                                                        if (!agent.isPresent()) break block46;
                                                                                        if (!data.getStatus().equalsIgnoreCase("Login")) break block47;
                                                                                        ((Agent)agent.get()).setStatus("Logged In");
                                                                                        ((Agent)agent.get()).setState("Idle");
                                                                                        break block48;
                                                                                    }
                                                                                    if (!data.getStatus().equals("Start Call")) break block49;
                                                                                    if (((User)user.get()).getIsOnDemand() == null || ((User)user.get()).getIsOnDemand().equals(false)) {
                                                                                        ((Agent)agent.get()).setStatus("Available");
                                                                                    } else {
                                                                                        ((Agent)agent.get()).setStatus("Available (On Demand)");
                                                                                    }
                                                                                    ((Agent)agent.get()).setState("Waiting");
                                                                                    break block48;
                                                                                }
                                                                                if (!data.getStatus().equals("Available For Call")) break block50;
                                                                                ((Agent)agent.get()).setStatus("Available");
                                                                                ((Agent)agent.get()).setState("Waiting");
                                                                                break block48;
                                                                            }
                                                                            if (!data.getStatus().equalsIgnoreCase("Logout")) break block51;
                                                                            ((Agent)agent.get()).setStatus("Logged Out");
                                                                            ((Agent)agent.get()).setState("Waiting");
                                                                            break block48;
                                                                        }
                                                                        if (!data.getStatus().equalsIgnoreCase("Off-Hook")) break block52;
                                                                        ((Agent)agent.get()).setStatus("Off-Hook");
                                                                        break block48;
                                                                    }
                                                                    if (!data.getStatus().equals("Manual Dial")) break block53;
                                                                    defaultQueue2 = ((Agent)agent.get()).getDefaultQueue();
                                                                    logger.info("defaultQueue:{}", (Object)defaultQueue2);
                                                                    if (!StringUtils.hasText((String)defaultQueue2)) {
                                                                        returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                                                                        returnValue.setMessage("Not Found");
                                                                        returnValue.setMessageDetail("Default Queue is not assigned to Agent");
                                                                        return returnValue;
                                                                    }
                                                                    List list = this.tiersRepository.findByAgent(((User)userInfo.get()).getContactNo());
                                                                    if (list.isEmpty()) break block48;
                                                                    iterator2 = list.iterator();
                                                                    break block54;
                                                                }
                                                                if (data.getStatus().equals("Auto Dial")) {
                                                                    defaultQueue2 = ((Agent)agent.get()).getDefaultQueue();
                                                                    logger.info("defaultQueue:{}", (Object)defaultQueue2);
                                                                    if (!StringUtils.hasText((String)defaultQueue2)) {
                                                                        returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                                                                        returnValue.setMessage("Not Found");
                                                                        returnValue.setMessageDetail("Default Queue is not assigned to Agent");
                                                                        return returnValue;
                                                                    }
                                                                    List list = this.tiersRepository.findByAgent(((User)userInfo.get()).getContactNo());
                                                                    if (!list.isEmpty()) {
                                                                        for (Tiers tiers : list) {
                                                                            if (!tiers.getQueue().equals(defaultQueue2)) {
                                                                                tiers.setState("Ready");
                                                                            }
                                                                            this.tiersRepository.save((Object)tiers);
                                                                        }
                                                                    }
                                                                    break block48;
                                                                } else {
                                                                    ((Agent)agent.get()).setStatus("On Break");
                                                                    ((Agent)agent.get()).setState("Waiting");
                                                                }
                                                                break block48;
                                                            }
                                                            agentName = this.agentRepository.findByName(((User)user.get()).getContactNo());
                                                            if (!agentName.isPresent()) break block55;
                                                            if (!data.getStatus().equalsIgnoreCase("Login")) break block56;
                                                            ((Agent)agentName.get()).setStatus("Logged In");
                                                            ((Agent)agentName.get()).setState("Idle");
                                                            break block57;
                                                        }
                                                        if (!data.getStatus().equals("Start Call")) break block58;
                                                        if (((User)user.get()).getIsOnDemand() == null || ((User)user.get()).getIsOnDemand().equals(false)) {
                                                            ((Agent)agentName.get()).setStatus("Available");
                                                        } else {
                                                            ((Agent)agentName.get()).setStatus("Available (On Demand)");
                                                        }
                                                        ((Agent)agentName.get()).setState("Waiting");
                                                        break block57;
                                                    }
                                                    if (!data.getStatus().equals("Available For Call")) break block59;
                                                    ((Agent)agentName.get()).setStatus("Available");
                                                    ((Agent)agentName.get()).setState("Waiting");
                                                    break block57;
                                                }
                                                if (!data.getStatus().equalsIgnoreCase("Logout")) break block60;
                                                ((Agent)agentName.get()).setStatus("Logged Out");
                                                ((Agent)agentName.get()).setState("Waiting");
                                                break block57;
                                            }
                                            if (!data.getStatus().equalsIgnoreCase("Off-Hook")) break block61;
                                            ((Agent)agentName.get()).setStatus("Off-Hook");
                                            break block57;
                                        }
                                        if (!data.getStatus().equals("Manual Dial")) break block62;
                                        defaultQueue = ((Agent)agentName.get()).getDefaultQueue();
                                        logger.info("defaultQueue:{}", (Object)defaultQueue);
                                        if (!StringUtils.hasText((String)defaultQueue)) {
                                            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                                            returnValue.setMessage("Not Found");
                                            returnValue.setMessageDetail("Default Queue is not assigned to Agent");
                                            return returnValue;
                                        }
                                        List list = this.tiersRepository.findByAgent(((Agent)agentName.get()).getName());
                                        if (list.isEmpty()) break block57;
                                        iterator = list.iterator();
                                        break block63;
                                    }
                                    if (data.getStatus().equals("Auto Dial")) {
                                        String defaultQueue3 = ((Agent)agentName.get()).getDefaultQueue();
                                        logger.info("defaultQueue:{}", (Object)defaultQueue3);
                                        if (!StringUtils.hasText((String)defaultQueue3)) {
                                            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                                            returnValue.setMessage("Not Found");
                                            returnValue.setMessageDetail("Default Queue is not assigned to Agent");
                                            return returnValue;
                                        }
                                        List list = this.tiersRepository.findByAgent(((Agent)agentName.get()).getName());
                                        if (!list.isEmpty()) {
                                            for (Tiers tiers : list) {
                                                if (!tiers.getQueue().equals(defaultQueue3)) {
                                                    tiers.setState("Ready");
                                                }
                                                this.tiersRepository.save((Object)tiers);
                                            }
                                        }
                                        break block57;
                                    } else {
                                        ((Agent)agentName.get()).setStatus("On Break");
                                        ((Agent)agentName.get()).setState("Waiting");
                                    }
                                    break block57;
                                }
                                returnValue.setStatus(Constants.Error.OK);
                                returnValue.setMessage("OK");
                                returnValue.setMessageDetail("AgentStatus Created Successfully");
                                break block64;
                            }
                            while (iterator2.hasNext()) {
                                Tiers tiers = (Tiers)iterator2.next();
                                if (tiers.getQueue().equals(defaultQueue2)) {
                                    tiers.setState("Ready");
                                } else {
                                    tiers.setState("Standby");
                                }
                                this.tiersRepository.save((Object)tiers);
                            }
                            if (((User)user.get()).getIsOnDemand() != null && ((User)user.get()).getIsOnDemand().equals(true)) {
                                ((Agent)agent.get()).setStatus("Available (On Demand) for manual");
                            } else {
                                ((Agent)agent.get()).setStatus("Available for manual");
                            }
                            ((Agent)agent.get()).setState("Waiting");
                        }
                        this.agentRepository.save(agent.get());
                        returnValue.setStatus(Constants.Error.OK);
                        returnValue.setMessage("OK");
                        returnValue.setMessageDetail("AgentStatus Created Successfully");
                        break block64;
                    }
                    while (iterator.hasNext()) {
                        Tiers tiers = (Tiers)iterator.next();
                        if (tiers.getQueue().equals(defaultQueue)) {
                            tiers.setState("Ready");
                        } else {
                            tiers.setState("Standby");
                        }
                        this.tiersRepository.save((Object)tiers);
                    }
                    if (((User)user.get()).getIsOnDemand() != null && ((User)user.get()).getIsOnDemand().equals(true)) {
                        ((Agent)agentName.get()).setStatus("Available (On Demand) for manual");
                    } else {
                        ((Agent)agentName.get()).setStatus("Available for manual");
                    }
                    ((Agent)agentName.get()).setState("Waiting");
                }
                this.agentRepository.save(agentName.get());
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("OK");
                returnValue.setMessageDetail("AgentStatus Created Successfully");
            }
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable To Create AgentStatus");
            returnValue.setMessageDetail("Contact With Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    private long getEpochSeconds(LocalDateTime localDateTime) {
        return localDateTime.toEpochSecond(ZoneOffset.UTC);
    }

    public RequestResponse getAgentList() {
        RequestResponse response = new RequestResponse();
        try {
            List users = this.userRepository.findAllByOrderById();
            ArrayList<AgentStatusReturn> agentList = new ArrayList<AgentStatusReturn>();
            for (User user : users) {
                if (!this.userService.checkAgentUser(user.getUsername())) continue;
                agentList.add(new AgentStatusReturn(user.getUsername()));
            }
            response.setStatus(Constants.Error.OK);
            response.setMessage("Agent list fetched successfully.");
            response.setData(agentList);
        }
        catch (Exception e) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Failed to fetch agent list: " + e.getMessage());
            response.setData(null);
        }
        return response;
    }

    public static String getClientIp(HttpServletRequest request) {
        String clientIp = request.getHeader("X-Forwarded-For");
        if (clientIp == null || clientIp.isEmpty() || "unknown".equalsIgnoreCase(clientIp)) {
            clientIp = request.getRemoteAddr();
        }
        return clientIp;
    }
}

