/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.billing.log.service;

import com.coraltele.db.billing.main.entity.PdfReportFilters;
import com.coraltele.db.billing.main.entity.view.ViewChannels;
import com.coraltele.db.billing.main.repository.PdfReportRepository;
import com.coraltele.db.billing.main.repository.ViewChannelsRepository;
import com.coraltele.db.billing.main.specification.ViewChannelsSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.PdfPageNumberEvent;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.AdvanceFilter;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.background.PdfGeneratorService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.itextpdf.text.BadElementException;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.security.Principal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service(value="billingPdf")
public class BillingPdfService
implements PdfGeneratorService {
    private static final Logger logger = LogManager.getLogger(BillingPdfService.class);
    private static String reportFileName = "Billing-CDR Data";
    private static String reportFileNameDateFormat = "dd_MMMM_yyyy";
    private static String localDateFormat = "dd-MM-yyyy hh:mm:ss a";
    private static String logoImgPath = "/var/www/html/apple-icon.png";
    LocalDateTime currentTime = null;
    private static int noOfColumns = 0;
    @Autowired
    private ViewChannelsRepository repository;
    @Autowired
    DynamicPdfThreadService generatingReports;
    @Autowired
    private PdfReportRepository pdfReportRepository;
    @Autowired
    PdfPageNumberEvent pageNumberEvent;
    @Autowired
    DateFormatUtility dateFormatUtility;
    private static Font COURIER = new Font(Font.FontFamily.COURIER, 20.0f, 1);
    private static Font COURIER_SMALL = new Font(Font.FontFamily.COURIER, 14.0f, 1);
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();

    public void init(LocalDateTime currentTime) {
        try {
            this.pageNumberEvent.initialize(logoImgPath, reportFileName, localDateFormat, currentTime);
        }
        catch (BadElementException | IOException e) {
            e.printStackTrace();
        }
    }

    public RequestResponse generatePdfReport(SearchRequest searchRequestData, String filePath, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        this.currentTime = LocalDateTime.now();
        this.init(this.currentTime);
        logger.info("Start generating pdf for matched columns:");
        try {
            noOfColumns = searchRequestData.getColumnNames().size();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Document document = noOfColumns > 5 ? new Document(PageSize.A3.rotate()) : new Document(PageSize.A4);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
            writer.setPageEvent((PdfPageEvent)this.pageNumberEvent);
            document.open();
            this.addLogoAndDocTitle(document, searchRequestData, Integer.valueOf(noOfColumns));
            if (searchRequestData.advancedFilters != null && !searchRequestData.advancedFilters.isEmpty()) {
                BillingPdfService.addAdvanceFilterRequest((Document)document, (SearchRequest)searchRequestData);
            }
            document.newPage();
            this.createTable(document, noOfColumns, searchRequestData);
            document.close();
            byte[] pdfBytes = byteArrayOutputStream.toByteArray();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
            String filename = this.getPdfNameWithDate();
            this.savePdfToDestination(pdfBytes, filePath);
            headers.setContentDispositionFormData(filename, filename);
            headers.setCacheControl("must-revalidate, post-check=0, pre-check=0");
            logger.info("PDF generated successfully and saved to: {}", (Object)filePath);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("File generated and saved successfully");
            returnValue.setData((Object)filePath);
            logger.info("NMS report generated and saved successfully");
            return returnValue;
        }
        catch (DocumentException e) {
            e.printStackTrace();
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("failed to download");
            logger.info("NMS report failed to download");
            return returnValue;
        }
    }

    private void addLogoAndDocTitle(Document document, SearchRequest filterRequest, Integer columns) {
        try {
            logger.info("finding logo from location");
            PdfPTable table = new PdfPTable(1);
            table.setWidthPercentage(100.0f);
            PdfPCell logoCell = new PdfPCell();
            logoCell.setHorizontalAlignment(1);
            logoCell.setBorder(0);
            Image img = Image.getInstance((String)logoImgPath);
            if (columns > 5) {
                img.scaleAbsolute(document.getPageSize().getWidth() * 0.5f, document.getPageSize().getHeight() * 0.4f);
                img.setAlignment(1);
                logoCell.addElement((Element)img);
            } else {
                img.scaleAbsolute(document.getPageSize().getWidth() * 0.7f, document.getPageSize().getHeight() * 0.4f);
                img.setAlignment(1);
                logoCell.addElement((Element)img);
            }
            PdfPCell reportNameCell = new PdfPCell();
            reportNameCell.setHorizontalAlignment(1);
            reportNameCell.setBorder(0);
            Paragraph p1 = new Paragraph(reportFileName, COURIER);
            reportNameCell.addElement((Element)p1);
            PdfPCell dateTimeCell = new PdfPCell();
            dateTimeCell.setHorizontalAlignment(1);
            dateTimeCell.setBorder(0);
            String localDateString = this.currentTime.format(DateTimeFormatter.ofPattern(localDateFormat));
            Paragraph p2 = new Paragraph("Report generated on " + localDateString, COURIER_SMALL);
            dateTimeCell.addElement((Element)p2);
            table.addCell(logoCell);
            table.addCell(reportNameCell);
            table.addCell(dateTimeCell);
            document.add((Element)table);
            logger.info("successfully found logo for pdf");
        }
        catch (DocumentException | IOException e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
    }

    private void createTable(Document document, int noOfColumns, SearchRequest searchRequestData) throws DocumentException {
        try {
            logger.info("Starting creation of table for pdf");
            Specification filters = ViewChannelsSpecification.generateFilters((SearchRequest)searchRequestData);
            Sort sort = null;
            if (searchRequestData.sortDirection.equals("asc")) {
                sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
            } else if (searchRequestData.sortDirection.equals("desc")) {
                sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
            }
            List filteredData = sort != null ? this.repository.findAll(filters, sort) : this.repository.findAll(filters);
            PdfPTable table = new PdfPTable(searchRequestData.getColumnNames().size());
            for (String columnName : searchRequestData.getColumnNames()) {
                BaseColor lightBlue = new BaseColor(2, 111, 194);
                PdfPCell cell = new PdfPCell(new Phrase((String)columnMappings.get(columnName), new Font(Font.FontFamily.HELVETICA, 12.0f, 1, BaseColor.WHITE)));
                cell.setHorizontalAlignment(1);
                cell.setBackgroundColor(lightBlue);
                cell.setBorder(0);
                table.addCell(cell);
            }
            table.setHeaderRows(1);
            this.getDbData(table, filteredData, searchRequestData.getColumnNames());
            document.add((Element)table);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
    }

    private void getDbData(PdfPTable table, List<ViewChannels> filteredData, List<String> columnNames1) {
        try {
            BaseColor lightBackground = new BaseColor(230, 230, 230);
            for (int rowIndex = 0; rowIndex < filteredData.size(); ++rowIndex) {
                ViewChannels viewChannels = filteredData.get(rowIndex);
                table.setWidthPercentage(100.0f);
                table.getDefaultCell().setHorizontalAlignment(1);
                table.getDefaultCell().setVerticalAlignment(5);
                table.getDefaultCell().setBorder(0);
                if (rowIndex % 2 == 0) {
                    table.getDefaultCell().setBackgroundColor(BaseColor.WHITE);
                } else {
                    table.getDefaultCell().setBackgroundColor(lightBackground);
                }
                Iterator<String> iterator = columnNames1.iterator();
                while (iterator.hasNext()) {
                    String columnName;
                    switch (columnName = iterator.next()) {
                        case "id": {
                            table.addCell(this.getCellValue(viewChannels.getId().toString()));
                            break;
                        }
                        case "uuid": {
                            table.addCell(this.getCellValue(viewChannels.getUuid()));
                            break;
                        }
                        case "callerIdNumber": {
                            table.addCell(this.getCellValue(viewChannels.getCallerIdNumber()));
                            break;
                        }
                        case "callerIdName": {
                            table.addCell(this.getCellValue(viewChannels.getCallerIdName()));
                            break;
                        }
                        case "didNumber": {
                            table.addCell(this.getCellValue(viewChannels.getDidNumber()));
                            break;
                        }
                        case "dodNumber": {
                            table.addCell(this.getCellValue(viewChannels.getDodNumber()));
                            break;
                        }
                        case "direction": {
                            table.addCell(this.getCellValue(String.valueOf(viewChannels.getDirection())));
                            break;
                        }
                        case "destinationNumber": {
                            table.addCell(this.getCellValue(viewChannels.getDestinationNumber()));
                            break;
                        }
                        case "startStamp": {
                            table.addCell(this.getCellValue(DateFormatUtility.dateAndTimeFormatterForSeconds((LocalDateTime)viewChannels.getStartStamp())));
                            break;
                        }
                        case "answerStamp": {
                            table.addCell(this.getCellValue(DateFormatUtility.dateAndTimeFormatterForSeconds((LocalDateTime)viewChannels.getAnswerStamp())));
                            break;
                        }
                        case "endStamp": {
                            table.addCell(this.getCellValue(DateFormatUtility.dateAndTimeFormatterForSeconds((LocalDateTime)viewChannels.getEndStamp())));
                            break;
                        }
                        case "billSec": {
                            table.addCell(this.getCellValue(viewChannels.getBillSec().toString()));
                            break;
                        }
                        case "formattedDuration": {
                            table.addCell(this.getCellValue(viewChannels.getFormattedDuration()));
                            break;
                        }
                        case "callType": {
                            table.addCell(this.getCellValue(viewChannels.getCallType()));
                            break;
                        }
                        case "pulse": {
                            table.addCell(this.getCellValue(viewChannels.getPulse().toString()));
                            break;
                        }
                        case "callCost": {
                            table.addCell(this.getCellValue(viewChannels.getCallCost().toString()));
                            break;
                        }
                        case "billingUuid": {
                            table.addCell(this.getCellValue(viewChannels.getBillingUuid()));
                            break;
                        }
                        case "status": {
                            table.addCell(this.getCellValue(viewChannels.getStatus()));
                            break;
                        }
                        case "mos": {
                            if (viewChannels.getMos().compareTo(BigDecimal.valueOf(0.0)) == 0) {
                                table.addCell("4.3");
                                break;
                            }
                            table.addCell(this.getCellValue(viewChannels.getMos().toString()));
                            break;
                        }
                        case "rtpJitterMinVariance": {
                            if (viewChannels.getRtpJitterMinVariance() == null || viewChannels.getRtpJitterMinVariance().compareTo(BigDecimal.ZERO) == 0) {
                                table.addCell("0.000");
                                break;
                            }
                            table.addCell(this.getCellValue(viewChannels.getRtpJitterMinVariance().toString()));
                            break;
                        }
                        case "rtpJitterMaxVariance": {
                            if (viewChannels.getRtpJitterMaxVariance() == null || viewChannels.getRtpJitterMaxVariance().compareTo(BigDecimal.ZERO) == 0) {
                                table.addCell("0.000");
                                break;
                            }
                            table.addCell(this.getCellValue(viewChannels.getRtpJitterMaxVariance().toString()));
                            break;
                        }
                        case "rtpJitterLossRate": {
                            if (viewChannels.getRtpJitterLossRate() == null || viewChannels.getRtpJitterLossRate().compareTo(BigDecimal.ZERO) == 0) {
                                table.addCell("0.000");
                                break;
                            }
                            table.addCell(this.getCellValue(viewChannels.getRtpJitterLossRate().toString()));
                            break;
                        }
                        case "destinationName": {
                            table.addCell(this.getCellValue(viewChannels.getDestinationName()));
                            break;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
    }

    private String getCellValue(String value) {
        return value != null && !value.isEmpty() ? value : "";
    }

    private static void leaveEmptyLine(Paragraph paragraph, int number) {
        for (int i = 0; i < number; ++i) {
            paragraph.add((Element)new Paragraph(" "));
        }
    }

    private String getPdfNameWithDate() {
        String localDateString = LocalDateTime.now().format(DateTimeFormatter.ofPattern(reportFileNameDateFormat));
        return reportFileName + "-" + localDateString + ".pdf";
    }

    private static void addAdvanceFilterRequest(Document document, SearchRequest searchRequestData) throws DocumentException {
        List advancedFilters = searchRequestData.getAdvancedFilters();
        if (advancedFilters != null && !advancedFilters.isEmpty()) {
            Paragraph advancedFilterParagraph = new Paragraph();
            Font boldFont = new Font(Font.FontFamily.HELVETICA, 14.0f, 1);
            for (AdvanceFilter advanceFilter : advancedFilters) {
                advancedFilterParagraph.setFont(boldFont);
                if ("from".equals(advanceFilter.getDirection())) {
                    advancedFilterParagraph.add("Record on the basis of " + (String)columnMappings.get(advanceFilter.getFieldName()) + ": From " + advanceFilter.getValue());
                    continue;
                }
                if (!"to".equals(advanceFilter.getDirection())) continue;
                advancedFilterParagraph.add(" to " + advanceFilter.getValue());
                advancedFilterParagraph.add((Element)new Paragraph(""));
            }
            document.add((Element)advancedFilterParagraph);
        }
    }

    private void savePdfToDestination(byte[] pdfBytes, String destinationPath) {
        try (FileOutputStream fos = new FileOutputStream(destinationPath);){
            fos.write(pdfBytes);
            logger.info("PDF saved to: {}", (Object)destinationPath);
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("Failed to save PDF to: {}", (Object)destinationPath);
        }
    }

    public void createPdfReportRecord(String id, SearchRequest data, String filePath) {
        try {
            PdfReportFilters pdfReportFilters = new PdfReportFilters();
            ObjectMapper objectMapper = new ObjectMapper();
            pdfReportFilters.setId(id);
            pdfReportFilters.setReportName(reportFileName);
            pdfReportFilters.setFilterParameters(objectMapper.writeValueAsString((Object)data));
            pdfReportFilters.setCreatedOnDate(this.currentTime);
            pdfReportFilters.setPdfLocation(filePath);
            pdfReportFilters.setStatus("InProgress");
            this.pdfReportRepository.save((Object)pdfReportFilters);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

    static {
        columnMappings.put("uuid", "uuid");
        columnMappings.put("id", "id");
        columnMappings.put("callerIdNumber", "Caller Number");
        columnMappings.put("callerIdName", "Caller Name");
        columnMappings.put("didNumber", "Did Number");
        columnMappings.put("dodNumber", "Dod Number");
        columnMappings.put("direction", "Direction");
        columnMappings.put("destinationNumber", "Destination Number");
        columnMappings.put("startStamp", "Start Time");
        columnMappings.put("answerStamp", "Answer Time");
        columnMappings.put("endStamp", "End Time");
        columnMappings.put("billSec", "TalkTime");
        columnMappings.put("formattedDuration", "Duration (HH:MM:SS)");
        columnMappings.put("callType", "Call Type");
        columnMappings.put("pulse", "Pulse");
        columnMappings.put("callCost", "Call Cost");
        columnMappings.put("billingUuid", "Billing Uuid");
        columnMappings.put("mos", "MOS");
        columnMappings.put("rtpJitterMinVariance", "RtpJitter Min Variance");
        columnMappings.put("rtpJitterMaxVariance", "RtpJitter Max Variance");
        columnMappings.put("rtpJitterLossRate", "RtpJitter Loss Rate");
        columnMappings.put("status", "Status");
        columnMappings.put("destinationName", "Destination Name");
    }
}

