/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.archiving.billingCdrHistorical.service;

import com.coraltele.db.telephony.archiving.entity.BillingCdrHistorical;
import com.coraltele.db.telephony.archiving.entity.CdrHistorical;
import com.coraltele.db.telephony.archiving.repository.BillingCdrHistoricalRepository;
import com.coraltele.db.telephony.archiving.repository.CdrHistoryRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.archiving.billingCdrHistorical.model.BillingCdrHistoricalModel;
import com.coraltele.service.archiving.billingCdrHistorical.model.CdrHistoryInputModel;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BillingCdrHistoricalService {
    private static final Logger logger = LogManager.getLogger(BillingCdrHistoricalService.class);
    @Autowired
    BillingCdrHistoricalRepository billingCdrHistoricalRepository;
    @Autowired
    CdrHistoryRepository cdrHistoricalRepository;
    @Autowired
    private ObjectMapper objectMapper;

    public RequestResponse getAllJson(BillingCdrHistoricalModel data) {
        List list = (List)this.billingCdrHistoricalRepository.findAll();
        ArrayList<Map> filteredData = new ArrayList<Map>();
        RequestResponse returnValue = new RequestResponse();
        logger.info("Received startEpoch: {}, endEpoch: {}", (Object)data.getStartEpoch(), (Object)data.getEndEpoch());
        boolean shouldFilter = data.getStartEpoch() != null && data.getEndEpoch() != null;
        for (BillingCdrHistorical billingCdrHistorical : list) {
            try {
                boolean matchesFilter = true;
                if (shouldFilter) {
                    Long recordStartEpoch = billingCdrHistorical.getStartEpoch();
                    logger.info("Record Start Epoch: {}", (Object)recordStartEpoch);
                    boolean bl = matchesFilter = recordStartEpoch >= data.getStartEpoch() && recordStartEpoch <= data.getEndEpoch();
                }
                if (!matchesFilter || billingCdrHistorical.getJsonData() == null) continue;
                JsonNode jsonNode = this.objectMapper.readTree(billingCdrHistorical.getJsonData());
                Map jsonDataMap = (Map)this.objectMapper.convertValue((Object)jsonNode, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                filteredData.add(jsonDataMap);
            }
            catch (Exception e) {
                logger.error("Error parsing JSON data: ", (Throwable)e);
            }
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(filteredData);
        logger.info("Filtered Data Size: {}", (Object)filteredData.size());
        return returnValue;
    }

    public RequestResponse getData(CdrHistoryInputModel cdrHIstoryInputModel) {
        RequestResponse response = new RequestResponse();
        List cdrEntities = cdrHIstoryInputModel.getStartEpoch() == null || cdrHIstoryInputModel.getEndEpoch() == null ? (List)this.cdrHistoricalRepository.findAll() : this.cdrHistoricalRepository.findByStartEpochBetween(cdrHIstoryInputModel.getStartEpoch(), cdrHIstoryInputModel.getEndEpoch());
        ArrayList<Map> filteredData = new ArrayList<Map>();
        for (CdrHistorical entity : cdrEntities) {
            try {
                if (entity.getJsonData() != null && !entity.getJsonData().isEmpty()) {
                    JsonNode jsonNode = this.objectMapper.readTree(entity.getJsonData());
                    Map jsonDataMap = (Map)this.objectMapper.convertValue((Object)jsonNode, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                    filteredData.add(jsonDataMap);
                    continue;
                }
                logger.warn("Entity with ID {} has null or empty JSON data.", (Object)entity.getId());
            }
            catch (Exception e) {
                logger.error("Error parsing JSON data for entity with ID {}: {}", (Object)entity.getId(), (Object)e.getMessage());
            }
        }
        response.setStatus(Constants.Error.OK);
        response.setMessage("Data fetched successfully.");
        response.setData(filteredData);
        return response;
    }
}

