/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.messaging;

import com.coraltele.db.telephony.pbx.entity.CLIServerCommandLog;
import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.repository.CLIServerCommandLogRepository;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.helper.Constants;
import com.coraltele.messaging.SubscribedMessage;
import com.coraltele.model.messaging.IMSIMessageModel;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MessagingService {
    private static final Logger logger = LogManager.getLogger(MessagingService.class);
    @Autowired
    ExtensionsRepository extensionsRepository;
    @Autowired
    CLIServerCommandLogRepository cliServerCommandLogRepository;

    public MessagingService() {
        logger.info("Started");
        Constants.messagingService = this;
    }

    public void imsiConnected(SubscribedMessage message) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        String messageData = objectMapper.writeValueAsString(message.getData());
        logger.info("Data received : UE Connected {}", (Object)messageData);
        IMSIMessageModel data = (IMSIMessageModel)objectMapper.readValue(messageData, IMSIMessageModel.class);
        data.setUe(data.getUe().replace("imsi-", ""));
        List extensions = this.extensionsRepository.findByIMSI(data.getUe());
        if (!extensions.isEmpty()) {
            Extension extension = (Extension)extensions.get(0);
            data.setExtensionNumber(extension.getExtension());
            data.setExtensionName(extension.getName());
        } else {
            data.setExtensionNumber("N/A");
            data.setExtensionName("Not Assigned");
        }
        SubscribedMessage sendData = new SubscribedMessage();
        sendData.setHostName(Constants.hostName);
        sendData.setEvent(Constants.Message.UE_ATTACH_UPDATE);
        sendData.setData((Object)data);
        Constants.redisMessagePublisher.publish(objectMapper.writeValueAsString((Object)sendData));
        this.executeCommand("extension update " + data.getExtensionNumber() + " rlu " + Constants.SERVER_RLU_CODE);
    }

    public void imsiDisconnected(SubscribedMessage message) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        String messageData = objectMapper.writeValueAsString(message.getData());
        logger.info("Data received : UE Disconnected {}", (Object)messageData);
        IMSIMessageModel data = (IMSIMessageModel)objectMapper.readValue(messageData, IMSIMessageModel.class);
        data.setUe(data.getUe().replace("imsi-", ""));
        List extensions = this.extensionsRepository.findByIMSI(data.getUe());
        if (!extensions.isEmpty()) {
            Extension extension = (Extension)extensions.get(0);
            data.setExtensionNumber(extension.getExtension());
            data.setExtensionName(extension.getName());
        } else {
            data.setExtensionNumber("N/A");
            data.setExtensionName("Not Assigned");
        }
        SubscribedMessage sendData = new SubscribedMessage();
        sendData.setHostName(Constants.hostName);
        sendData.setEvent(Constants.Message.UE_DETACH_UPDATE);
        sendData.setData((Object)data);
        Constants.redisMessagePublisher.publish(objectMapper.writeValueAsString((Object)sendData));
    }

    public void executeCommand(String cliCommand) {
        String outputFilename = "";
        Properties prop = new Properties();
        FileInputStream input = null;
        String serverCode = "";
        String fileName = "/etc/coraltelecom/callserver.manager.conf";
        String encryptedCommand = "";
        try {
            input = new FileInputStream(fileName);
            prop.load(input);
            if (prop.getProperty("servercode") != null && prop.getProperty("servercode").length() > 0) {
                serverCode = prop.getProperty("servercode");
            }
        }
        catch (Exception e) {
            logger.error("Unable to execute command {}", (Object)cliCommand);
        }
        long epochTime = System.currentTimeMillis();
        outputFilename = epochTime + "-" + serverCode;
        encryptedCommand = this.encryptContains(cliCommand);
        CLIServerCommandLog commandLog = new CLIServerCommandLog();
        commandLog.setRecordCreatedBy("control-command");
        commandLog.setOutputFileName(outputFilename);
        commandLog.setOutputFilePath("");
        commandLog.setCLICommand(encryptedCommand);
        commandLog.setServerCode(serverCode);
        commandLog.setExecuted("N");
        commandLog.setCommandExecutedByClientIP("localhost");
        commandLog.setCommandExecutedOnServerIP(this.getServerIP());
        this.cliServerCommandLogRepository.save((Object)commandLog);
    }

    public String encryptContains(String keyvalue) {
        byte[] rtrVal = null;
        if (!keyvalue.isEmpty()) {
            String privateKey;
            MessageDigest sha = null;
            String passwordKey = privateKey = "9221375a0cd0-5adb3f6d--f6ea-4d1e-81ed-a719175d-1e40-dd24b91a7c87-c5600ed3";
            try {
                byte[] key = passwordKey.getBytes("UTF-8");
                sha = MessageDigest.getInstance("SHA-1");
                key = sha.digest(key);
                key = Arrays.copyOf(key, 16);
                SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
                Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
                cipher.init(1, secretKey);
                byte[] rtv = cipher.doFinal(keyvalue.getBytes("UTF-8"));
                rtrVal = Base64.getEncoder().encode(rtv);
            }
            catch (NoSuchAlgorithmException e) {
                logger.error(e.getMessage());
            }
            catch (UnsupportedEncodingException e) {
                logger.error(e.getMessage());
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        return new String(rtrVal);
    }

    public String getServerIP() {
        String eth0 = "";
        try {
            String interfaceName = "eth0";
            NetworkInterface networkInterface = NetworkInterface.getByName(interfaceName);
            if (networkInterface != null) {
                List<InterfaceAddress> inetAddressAll = networkInterface.getInterfaceAddresses();
                for (InterfaceAddress address : inetAddressAll) {
                    InetAddress currentAddress = address.getAddress();
                    if (!(currentAddress instanceof Inet4Address) || currentAddress.isLoopbackAddress() || address.getBroadcast().toString().startsWith("0")) continue;
                    eth0 = currentAddress.toString().replace("/", "");
                }
            }
        }
        catch (Exception ex) {
            logger.error("Error at getserverip : ", (Throwable)ex);
        }
        return eth0;
    }
}

