/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.db.telemetry.main.specification;

import com.coraltele.db.telemetry.main.entity.CustomerCDR;
import com.coraltele.model.Filter;
import com.coraltele.model.SearchResultModel;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.jpa.domain.Specification;

public class CustomerCDRSpecificationNew {
    private static final Logger logger = LogManager.getLogger(CustomerCDRSpecificationNew.class);

    private CustomerCDRSpecificationNew() {
    }

    public static Specification<CustomerCDR> buildSpecification(SearchResultModel request) {
        return (Specification & Serializable)(root, query, criteriaBuilder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            for (Filter filter : request.getFilters()) {
                String datatype = filter.getDataType();
                String field = filter.getField();
                String operator = filter.getOperator();
                String value1 = filter.getValue1();
                String value2 = filter.getValue2();
                List value3 = filter.getValue3();
                switch (operator.toLowerCase()) {
                    case "between": {
                        DateTimeFormatter formatter;
                        if ("date".equalsIgnoreCase(datatype)) {
                            formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm");
                            LocalDateTime fromDateTime = LocalDateTime.parse(value1, formatter);
                            LocalDateTime toDateTime = LocalDateTime.parse(value2, formatter);
                            long fromEpochSecond = fromDateTime.atZone(ZoneId.systemDefault()).toEpochSecond();
                            long toEpochSecond = toDateTime.atZone(ZoneId.systemDefault()).toEpochSecond();
                            predicates.add(criteriaBuilder.between((Expression)root.get(field), (Comparable)Long.valueOf(fromEpochSecond), (Comparable)Long.valueOf(toEpochSecond)));
                        }
                        if ("integer".equalsIgnoreCase(datatype)) {
                            Integer from = Integer.parseInt(value1);
                            Integer to = Integer.parseInt(value2);
                            predicates.add(criteriaBuilder.between((Expression)root.get(field), (Comparable)from, (Comparable)to));
                        }
                        if (!"string".equalsIgnoreCase(datatype)) break;
                        predicates.add(criteriaBuilder.between((Expression)root.get(field), (Comparable)((Object)value1), (Comparable)((Object)value2)));
                        break;
                    }
                    case "is": {
                        LocalDateTime dateTime;
                        DateTimeFormatter formatter;
                        if ("date".equalsIgnoreCase(datatype) && value1 != null && !value1.isEmpty()) {
                            formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm");
                            dateTime = LocalDateTime.parse(value1, formatter);
                            LocalDate date = dateTime.toLocalDate();
                            long startEpoch = date.atStartOfDay(ZoneId.systemDefault()).toEpochSecond();
                            long endEpoch = date.atTime(LocalTime.MAX).atZone(ZoneId.systemDefault()).toEpochSecond();
                            predicates.add(criteriaBuilder.between((Expression)root.get(field), (Comparable)Long.valueOf(startEpoch), (Comparable)Long.valueOf(endEpoch)));
                        }
                        if ("integer".equalsIgnoreCase(datatype) && value3 != null && !value3.isEmpty()) {
                            List intValues = value3.stream().map(Integer::parseInt).collect(Collectors.toList());
                            predicates.add(root.get(field).in(intValues));
                        }
                        if (!"string".equalsIgnoreCase(datatype) || value3 == null || value3.isEmpty()) break;
                        List lowerValues = value3.stream().map(String::toLowerCase).collect(Collectors.toList());
                        Expression fieldExpr = criteriaBuilder.lower((Expression)root.get(field));
                        predicates.add(fieldExpr.in(lowerValues));
                        break;
                    }
                    case "greaterthan": {
                        LocalDateTime dateTime;
                        DateTimeFormatter formatter;
                        if ("date".equalsIgnoreCase(datatype)) {
                            formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm");
                            dateTime = LocalDateTime.parse(value1, formatter);
                            long epoch = dateTime.atZone(ZoneId.systemDefault()).toEpochSecond();
                            predicates.add(criteriaBuilder.gt((Expression)root.get(field), (Number)epoch));
                            break;
                        }
                        if (!"integer".equalsIgnoreCase(datatype)) break;
                        Integer intValue = Integer.parseInt(value1);
                        predicates.add(criteriaBuilder.gt((Expression)root.get(field), (Number)intValue));
                        break;
                    }
                    case "lessthan": {
                        LocalDateTime dateTime;
                        DateTimeFormatter formatter;
                        if ("date".equalsIgnoreCase(datatype)) {
                            formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm");
                            dateTime = LocalDateTime.parse(value1, formatter);
                            long epoch = dateTime.atZone(ZoneId.systemDefault()).toEpochSecond();
                            predicates.add(criteriaBuilder.lt((Expression)root.get(field), (Number)epoch));
                            break;
                        }
                        if (!"integer".equalsIgnoreCase(datatype)) break;
                        Integer intValue = Integer.parseInt(value1);
                        predicates.add(criteriaBuilder.lt((Expression)root.get(field), (Number)intValue));
                    }
                }
            }
            if (!request.getSorts().isEmpty()) {
                List orders = request.getSorts().stream().map(sort -> {
                    String column = sort.getColumn();
                    Path path = root.get(column);
                    return "descending".equalsIgnoreCase(sort.getDirection()) ? criteriaBuilder.desc((Expression)path) : criteriaBuilder.asc((Expression)path);
                }).collect(Collectors.toList());
                query.orderBy(orders);
            }
            return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
        };
    }
}

