CREATE OR REPLACE VIEW public.v_epvoicepicker
    AS
 SELECT COALESCE(channels.actuallocaluser, channels.localuser) AS caller_id_number,
    channels.localname AS callername,
    COALESCE(channels.actualremoteuser, channels.remoteuser) AS destination_number,
    COALESCE(channels.hungupcause, ''::text::character varying) AS hangup_cause,
    to_timestamp((channels.ringepoch / 1000)::double precision) AS filetime,
    to_timestamp((channels.ringepoch / 1000)::double precision) AS start_stamp,
    to_timestamp((channels.endepoch / 1000)::double precision) AS end_stamp,
    COALESCE(channels.calldirection, ''::character varying) AS direction,
    channels.recording_file AS cc_record_filename,
    channels.id,
    ''::text AS column3,
        CASE
            WHEN channels.answerepoch > 0 THEN ceiling((channels.endepoch - channels.answerepoch)::double precision / 1000::double precision)
            ELSE 0::bigint::double precision
        END AS duration,
    ''::text AS cc_agent,
        CASE
            WHEN channels.answerepoch > 0 THEN ceiling((channels.endepoch - channels.answerepoch)::double precision / 1000::double precision)
            ELSE 0::bigint::double precision
        END AS billsec,
    channels.id AS cdrid,
    COALESCE(channels.sourceip, ''::character varying) AS remote_caller_ip,
    'Recording'::text AS coral_app,
    COALESCE(channels.destinationip, ''::character varying) AS remote_callee_ip,
        CASE
            WHEN channels.answerepoch = '0'::bigint THEN NULL::timestamp with time zone
            ELSE to_timestamp((channels.answerepoch / 1000)::double precision)
        END AS answer_stamp,
    COALESCE(channels.hostname, ''::text::character varying) AS location,
    COALESCE(channels.remotename, ''::character varying) AS dest_name
   FROM channels
  WHERE COALESCE(channels.recording_file, ''::text::character varying)::text <> ''::text;