DO $$
BEGIN
    -- 🗂️ t_sendfaxprogress table
    IF EXISTS (
        SELECT 1 FROM information_schema.tables
        WHERE table_schema = 'public'
          AND table_name = 't_sendfaxprogress'
    ) THEN
        -- 📌 mailsent column
        IF EXISTS (
            SELECT 1 FROM information_schema.columns
            WHERE table_schema = 'public'
              AND table_name = 't_sendfaxprogress'
              AND column_name = 'mailsent'
        ) THEN
            IF NOT EXISTS (
                SELECT 1 FROM information_schema.columns
                WHERE table_schema = 'public'
                  AND table_name = 't_sendfaxprogress'
                  AND column_name = 'mailsent'
                  AND column_default = '''NOTSENT''::character varying'
            ) THEN
                ALTER TABLE public.t_sendfaxprogress
                ALTER COLUMN mailsent SET DEFAULT 'NOTSENT';

                UPDATE public.t_sendfaxprogress
                SET mailsent = 'NOTSENT'
                WHERE mailsent IS NULL;
            END IF;
        END IF;

        -- 📌 nooftry column
        IF EXISTS (
            SELECT 1 FROM information_schema.columns
            WHERE table_schema = 'public'
              AND table_name = 't_sendfaxprogress'
              AND column_name = 'nooftry'
        ) THEN
            IF NOT EXISTS (
                SELECT 1 FROM information_schema.columns
                WHERE table_schema = 'public'
                  AND table_name = 't_sendfaxprogress'
                  AND column_name = 'nooftry'
                  AND column_default = '0'
            ) THEN
                ALTER TABLE public.t_sendfaxprogress
                ALTER COLUMN nooftry SET DEFAULT 0;

                UPDATE public.t_sendfaxprogress
                SET nooftry = 0
                WHERE nooftry IS NULL;
            END IF;
        END IF;
    END IF;

    -- 🗂️ voicemail_msgs table
    IF EXISTS (
        SELECT 1 FROM information_schema.tables
        WHERE table_schema = 'public'
          AND table_name = 'voicemail_msgs'
    ) THEN
        -- 📌 nooftry column
        IF EXISTS (
            SELECT 1 FROM information_schema.columns
            WHERE table_schema = 'public'
              AND table_name = 'voicemail_msgs'
              AND column_name = 'nooftry'
        ) THEN
            IF NOT EXISTS (
                SELECT 1 FROM information_schema.columns
                WHERE table_schema = 'public'
                  AND table_name = 'voicemail_msgs'
                  AND column_name = 'nooftry'
                  AND column_default = '0'
            ) THEN
                ALTER TABLE public.voicemail_msgs
                ALTER COLUMN nooftry SET DEFAULT 0;

                UPDATE public.voicemail_msgs
                SET nooftry = 0
                WHERE nooftry IS NULL;
            END IF;
        END IF;

        -- 📌 mailsent column
        IF EXISTS (
            SELECT 1 FROM information_schema.columns
            WHERE table_schema = 'public'
              AND table_name = 'voicemail_msgs'
              AND column_name = 'mailsent'
        ) THEN
            IF NOT EXISTS (
                SELECT 1 FROM information_schema.columns
                WHERE table_schema = 'public'
                  AND table_name = 'voicemail_msgs'
                  AND column_name = 'mailsent'
                  AND column_default = '0'
            ) THEN
                ALTER TABLE public.voicemail_msgs
                ALTER COLUMN mailsent SET DEFAULT 0;

                UPDATE public.voicemail_msgs
                SET mailsent = 0
                WHERE mailsent IS NULL;
            END IF;
        END IF;
    END IF;
END $$;