/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.queuePerformance.service;

import com.coraltele.db.billing.main.entity.PdfReportFilters;
import com.coraltele.db.billing.main.repository.PdfReportRepository;
import com.coraltele.db.telemetry.main.entity.AgentCDR;
import com.coraltele.db.telemetry.main.entity.QueuePerformance;
import com.coraltele.db.telemetry.main.repository.AgentCDRRepository;
import com.coraltele.db.telemetry.main.repository.QueuePerformanceRepository;
import com.coraltele.db.telemetry.main.specification.QueuePerformanceSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.PdfPageNumberEvent;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.AdvanceFilter;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.background.PdfGeneratorService;
import com.coraltele.service.coralApps.callcenter.queueTL.service.QueueTLService;
import com.coraltele.service.telemetry.main.queuePerformance.service.QueuePerformancePdf;
import com.coraltele.service.telemetry.main.queuePerformance.service.QueuePerformanceSummaryPDF;
import com.coraltele.service.user.service.UserService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.itextpdf.text.BadElementException;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Principal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service(value="queuePerformanceSummariesPdf")
public class QueuePerformanceSummaryPDF
implements PdfGeneratorService {
    private static String reportFileName = "Queue Performance Summary";
    private static String reportFileNameDateFormat = "dd_MMMM_yyyy";
    private static String localDateFormat = "dd-MM-yyyy hh:mm:ss a";
    LocalDateTime currentTime = null;
    private static String logoImgPath = "/var/www/html/apple-icon.png";
    private static int noOfColumns = 0;
    private static final Logger logger = LogManager.getLogger(QueuePerformancePdf.class);
    @Autowired
    QueuePerformanceRepository queuePerformanceRepository;
    @Autowired
    DynamicPdfThreadService generatingReports;
    @Autowired
    private PdfReportRepository pdfReportRepository;
    @Autowired
    PdfPageNumberEvent pageNumberEvent;
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    UserService userService;
    @Autowired
    QueueTLService queueTLService;
    @Autowired
    AgentCDRRepository agentCDRRepository;
    private static Font COURIER = new Font(Font.FontFamily.COURIER, 20.0f, 1);
    private static Font COURIER_SMALL = new Font(Font.FontFamily.COURIER, 14.0f, 1);
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();

    public void init(LocalDateTime currentTime) {
        try {
            this.pageNumberEvent.initialize(logoImgPath, reportFileName, localDateFormat, currentTime);
        }
        catch (BadElementException | IOException e) {
            e.printStackTrace();
        }
    }

    public RequestResponse generatePdfReport(SearchRequest searchRequestData, String filePath, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        this.currentTime = LocalDateTime.now();
        this.init(this.currentTime);
        logger.info("Start generating pdf for matched columns:");
        try {
            List queueId = null;
            if (this.userService.checkRoleTL(principal.getName())) {
                queueId = this.queueTLService.getQueueListByTeamLeader(principal.getName());
            }
            noOfColumns = searchRequestData.getColumnNames().size();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Document document = noOfColumns > 5 ? new Document(PageSize.A3.rotate()) : new Document(PageSize.A4);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
            writer.setPageEvent((PdfPageEvent)this.pageNumberEvent);
            document.open();
            this.addLogoAndDocTitle(document, searchRequestData, Integer.valueOf(noOfColumns));
            if (searchRequestData.advancedFilters != null && !searchRequestData.advancedFilters.isEmpty()) {
                QueuePerformanceSummaryPDF.addAdvanceFilterRequest((Document)document, (SearchRequest)searchRequestData);
            }
            document.newPage();
            this.createTable(document, noOfColumns, searchRequestData, queueId);
            document.close();
            byte[] pdfBytes = byteArrayOutputStream.toByteArray();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
            String filename = this.getPdfNameWithDate();
            this.savePdfToDestination(pdfBytes, filePath);
            headers.setContentDispositionFormData(filename, filename);
            headers.setCacheControl("must-revalidate, post-check=0, pre-check=0");
            logger.info("PDF generated successfully and saved to: {}", (Object)filePath);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("File generated and saved successfully");
            returnValue.setData((Object)filePath);
            logger.info("NMS report generated and saved successfully");
            return returnValue;
        }
        catch (DocumentException e) {
            e.printStackTrace();
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("failed to download");
            logger.info("NMS report failed to download");
            return returnValue;
        }
    }

    private void addLogoAndDocTitle(Document document, SearchRequest filterRequest, Integer columns) {
        try {
            logger.info("finding logo from location");
            PdfPTable table = new PdfPTable(1);
            table.setWidthPercentage(100.0f);
            PdfPCell logoCell = new PdfPCell();
            logoCell.setHorizontalAlignment(1);
            logoCell.setBorder(0);
            Image img = Image.getInstance((String)logoImgPath);
            if (columns > 5) {
                img.scaleAbsolute(document.getPageSize().getWidth() * 0.5f, document.getPageSize().getHeight() * 0.4f);
                img.setAlignment(1);
                logoCell.addElement((Element)img);
            } else {
                img.scaleAbsolute(document.getPageSize().getWidth() * 0.7f, document.getPageSize().getHeight() * 0.4f);
                img.setAlignment(1);
                logoCell.addElement((Element)img);
            }
            PdfPCell reportNameCell = new PdfPCell();
            reportNameCell.setHorizontalAlignment(1);
            reportNameCell.setBorder(0);
            Paragraph p1 = new Paragraph(reportFileName, COURIER);
            reportNameCell.addElement((Element)p1);
            PdfPCell dateTimeCell = new PdfPCell();
            dateTimeCell.setHorizontalAlignment(1);
            dateTimeCell.setBorder(0);
            String localDateString = this.currentTime.format(DateTimeFormatter.ofPattern(localDateFormat));
            Paragraph p2 = new Paragraph("Report generated on " + localDateString, COURIER_SMALL);
            dateTimeCell.addElement((Element)p2);
            table.addCell(logoCell);
            table.addCell(reportNameCell);
            table.addCell(dateTimeCell);
            document.add((Element)table);
            logger.info("successfully found logo for pdf");
        }
        catch (DocumentException | IOException e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
    }

    private void createTable(Document document, int noOfColumns, SearchRequest searchRequestData, List<String> queueId) throws DocumentException {
        try {
            logger.info("Starting creation of table for pdf");
            Specification filters = QueuePerformanceSpecification.generateFilters((SearchRequest)searchRequestData, queueId);
            Sort sort = null;
            if (searchRequestData.sortDirection.equals("asc")) {
                sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
            } else if (searchRequestData.sortDirection.equals("desc")) {
                sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
            }
            List filteredData = sort != null ? this.queuePerformanceRepository.findAll(filters, sort) : this.queuePerformanceRepository.findAll(filters);
            Map agentCountMap = this.getAgentCountMapByDate();
            Map aggregatedData = this.aggregateDataByQueue(filteredData, agentCountMap);
            PdfPTable table = new PdfPTable(searchRequestData.getColumnNames().size());
            for (String columnName : searchRequestData.getColumnNames()) {
                BaseColor lightBlue = new BaseColor(2, 111, 194);
                PdfPCell cell = new PdfPCell(new Phrase((String)columnMappings.get(columnName), new Font(Font.FontFamily.HELVETICA, 12.0f, 1, BaseColor.WHITE)));
                cell.setHorizontalAlignment(1);
                cell.setBackgroundColor(lightBlue);
                cell.setBorder(0);
                table.addCell(cell);
            }
            table.setHeaderRows(1);
            this.getDbData(table, aggregatedData, searchRequestData.getColumnNames());
            document.add((Element)table);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
    }

    private Map<String, QueuePerformanceAggregated> aggregateDataByQueue(List<QueuePerformance> data, Map<String, Integer> agentCountMap) {
        ConcurrentHashMap<String, QueuePerformanceAggregated> aggregatedMap = new ConcurrentHashMap<String, QueuePerformanceAggregated>();
        HashMap<String, Integer> agentSum = new HashMap<String, Integer>();
        HashMap<String, Integer> countPerCompositeKey = new HashMap<String, Integer>();
        for (QueuePerformance item : data) {
            long avgAnsWaitTime;
            String queue = item.getQueue();
            String callDirection = item.getCallDirection();
            String compositeKey = queue + "|" + callDirection;
            LocalDate date = this.dateFormatUtility.epochToLocalDateForLocalTimeZone(item.getRecordEpoch());
            String dateStr = date.toString();
            String agentKey = dateStr + "|" + queue + "|" + callDirection;
            int agentCount = agentCountMap.getOrDefault(agentKey, 0);
            QueuePerformanceAggregated aggregated = aggregatedMap.getOrDefault(compositeKey, new QueuePerformanceAggregated(null));
            aggregated.queue = item.getQueue();
            aggregated.queueName = item.getQueueName();
            aggregated.callDirection = item.getCallDirection();
            aggregated.recordEpoch = this.dateFormatUtility.epochToLocalDateForLocalTimeZone(item.getRecordEpoch());
            agentSum.put(compositeKey, agentSum.getOrDefault(compositeKey, 0) + agentCount);
            countPerCompositeKey.put(compositeKey, countPerCompositeKey.getOrDefault(compositeKey, 0) + 1);
            aggregated.totalJoined = aggregated.totalJoined + (item.getTotalJoined() != null ? (long)item.getTotalJoined().intValue() : 0L);
            aggregated.totalConnectedWithAgent = aggregated.totalConnectedWithAgent + (item.getTotalConnectedWithAgent() != null ? (long)item.getTotalConnectedWithAgent().intValue() : 0L);
            aggregated.totalAbandonedAtQueue = aggregated.totalAbandonedAtQueue + (item.getTotalAbandonedAtQueue() != null ? (long)item.getTotalAbandonedAtQueue().intValue() : 0L);
            aggregated.totalCustomerAgentTalkTime = aggregated.totalCustomerAgentTalkTime + (item.getTotalCustomerAgentTalkTime() != null ? item.getTotalCustomerAgentTalkTime() : 0L);
            aggregated.totalCustomerTime = aggregated.totalCustomerTime + (item.getTotalCustomerTime() != null ? item.getTotalCustomerTime() : 0L);
            aggregated.totalNoContact = aggregated.totalNoContact + (item.getTotalNoContact() != null ? (long)item.getTotalNoContact().intValue() : 0L);
            aggregated.totalWaitTime = aggregated.totalWaitTime + (item.getTotalWaitTime() != null ? item.getTotalWaitTime() : 0L);
            aggregated.totalAbandonedAtAgent = aggregated.totalAbandonedAtAgent + (item.getTotalAbandonedAtAgent() != null ? (long)item.getTotalAbandonedAtAgent().intValue() : 0L);
            aggregated.answerWaitSecond10 = aggregated.answerWaitSecond10 + (item.getAnswerWaitSecond10() != null ? item.getAnswerWaitSecond10() : 0);
            aggregated.answerWaitSecond20 = aggregated.answerWaitSecond20 + (item.getAnswerWaitSecond20() != null ? item.getAnswerWaitSecond20() : 0);
            aggregated.answerWaitSecond30 = aggregated.answerWaitSecond30 + (item.getAnswerWaitSecond30() != null ? item.getAnswerWaitSecond30() : 0);
            aggregated.answerWaitSecond40 = aggregated.answerWaitSecond40 + (item.getAnswerWaitSecond40() != null ? item.getAnswerWaitSecond40() : 0);
            aggregated.answerWaitSecond50 = aggregated.answerWaitSecond50 + (item.getAnswerWaitSecond50() != null ? item.getAnswerWaitSecond50() : 0);
            aggregated.answerWaitSecond60 = aggregated.answerWaitSecond60 + (item.getAnswerWaitSecond60() != null ? item.getAnswerWaitSecond60() : 0);
            aggregated.greaterAnswerWaitSecond60 = aggregated.greaterAnswerWaitSecond60 + (item.getGreaterAnswerWaitSecond60() != null ? item.getGreaterAnswerWaitSecond60() : 0);
            aggregated.abandonedWaitSecond10 = aggregated.abandonedWaitSecond10 + (item.getAbandonedWaitSecond10() != null ? item.getAbandonedWaitSecond10() : 0);
            aggregated.abandonedWaitSecond20 = aggregated.abandonedWaitSecond20 + (item.getAbandonedWaitSecond20() != null ? item.getAbandonedWaitSecond20() : 0);
            aggregated.abandonedWaitSecond30 = aggregated.abandonedWaitSecond30 + (item.getAbandonedWaitSecond30() != null ? item.getAbandonedWaitSecond30() : 0);
            aggregated.abandonedWaitSecond40 = aggregated.abandonedWaitSecond40 + (item.getAbandonedWaitSecond40() != null ? item.getAbandonedWaitSecond40() : 0);
            aggregated.abandonedWaitSecond50 = aggregated.abandonedWaitSecond50 + (item.getAbandonedWaitSecond50() != null ? item.getAbandonedWaitSecond50() : 0);
            aggregated.abandonedWaitSecond60 = aggregated.abandonedWaitSecond60 + (item.getAbandonedWaitSecond60() != null ? item.getAbandonedWaitSecond60() : 0);
            aggregated.greaterAbandonedWaitSecond60 = aggregated.greaterAbandonedWaitSecond60 + (item.getGreaterAbandonedWaitSecond60() != null ? item.getGreaterAbandonedWaitSecond60() : 0);
            aggregated.totalAbandonedWaitTime = aggregated.totalAbandonedWaitTime + (item.getTotalAbandonedWaitTime() != null ? item.getTotalAbandonedWaitTime() : 0L);
            aggregated.totalAnswerWaitTime = aggregated.totalAnswerWaitTime + (item.getTotalAnswerWaitTime() != null ? item.getTotalAnswerWaitTime() : 0L);
            aggregated.averageAnswerWaitTime = avgAnsWaitTime = aggregated.totalConnectedWithAgent != 0L ? aggregated.totalWaitTime / aggregated.totalConnectedWithAgent : 0L;
            aggregated.averageAbandonedWaitTime = aggregated.totalAbandonedAtAgent + aggregated.totalAbandonedAtQueue != 0L ? aggregated.totalAbandonedWaitTime / (aggregated.totalAbandonedAtAgent + aggregated.totalAbandonedAtQueue) : 0L;
            aggregated.averageTalkTime = aggregated.totalConnectedWithAgent != 0L ? aggregated.totalCustomerAgentTalkTime / aggregated.totalConnectedWithAgent : 0L;
            aggregated.abandonedPercentage = aggregated.totalJoined != 0L ? (double)(aggregated.totalAbandonedAtAgent + aggregated.totalAbandonedAtQueue) * 100.0 / (double)aggregated.totalJoined : 0.0;
            aggregated.servicePercentage = aggregated.totalJoined != 0L ? (double)aggregated.totalConnectedWithAgent * 100.0 / (double)aggregated.totalJoined : 0.0;
            aggregatedMap.put(compositeKey, aggregated);
        }
        for (String key : aggregatedMap.keySet()) {
            int totalAgents;
            ((QueuePerformanceAggregated)aggregatedMap.get((Object)key)).averageNumberAgent = totalAgents = agentSum.getOrDefault(key, 0).intValue();
        }
        return aggregatedMap;
    }

    private void getDbData(PdfPTable table, Map<String, QueuePerformanceAggregated> aggregatedData, List<String> columnNames1) {
        try {
            BaseColor lightBackground = new BaseColor(230, 230, 230);
            for (Map.Entry<String, QueuePerformanceAggregated> entry : aggregatedData.entrySet()) {
                String queue = entry.getKey();
                QueuePerformanceAggregated aggregated = entry.getValue();
                table.setWidthPercentage(100.0f);
                table.getDefaultCell().setHorizontalAlignment(1);
                table.getDefaultCell().setVerticalAlignment(5);
                table.getDefaultCell().setBorder(0);
                table.getDefaultCell().setBackgroundColor(table.getRows().size() % 2 == 0 ? BaseColor.WHITE : lightBackground);
                Iterator<String> iterator = columnNames1.iterator();
                while (iterator.hasNext()) {
                    String columnName;
                    switch (columnName = iterator.next()) {
                        case "queue": {
                            table.addCell(this.getCellValue(aggregated.queue));
                            break;
                        }
                        case "queueName": {
                            table.addCell(this.getCellValue(aggregated.queueName));
                            break;
                        }
                        case "callDirection": {
                            table.addCell(this.getCellValue(aggregated.callDirection));
                            break;
                        }
                        case "recordEpoch": {
                            table.addCell(this.getCellValue(String.valueOf(aggregated.recordEpoch)));
                            break;
                        }
                        case "totalJoined": {
                            table.addCell(this.getCellValue(String.valueOf(aggregated.totalJoined)));
                            break;
                        }
                        case "totalConnectedWithAgent": {
                            table.addCell(this.getCellValue(String.valueOf(aggregated.totalConnectedWithAgent)));
                            break;
                        }
                        case "totalAbandonedAtQueue": {
                            table.addCell(this.getCellValue(String.valueOf(aggregated.totalAbandonedAtQueue)));
                            break;
                        }
                        case "totalCustomerAgentTalkTime": {
                            table.addCell(DateFormatUtility.findLocalTime((Long)aggregated.totalCustomerAgentTalkTime));
                            break;
                        }
                        case "totalCustomerTime": {
                            table.addCell(DateFormatUtility.findLocalTime((Long)aggregated.totalCustomerTime));
                            break;
                        }
                        case "totalNoContact": {
                            table.addCell(this.getCellValue(String.valueOf(aggregated.totalNoContact)));
                            break;
                        }
                        case "totalWaitTime": {
                            table.addCell(this.getCellValue(String.valueOf(aggregated.totalWaitTime)));
                            break;
                        }
                        case "totalAbandonedAtAgent": {
                            table.addCell(this.getCellValue(String.valueOf(aggregated.totalAbandonedAtAgent)));
                            break;
                        }
                        case "answerWaitSecond10": {
                            table.addCell(this.getCellValue(String.valueOf(aggregated.answerWaitSecond10)));
                            break;
                        }
                        case "answerWaitSecond20": {
                            table.addCell(this.getCellValue(String.valueOf(aggregated.answerWaitSecond20)));
                            break;
                        }
                        case "answerWaitSecond30": {
                            table.addCell(this.getCellValue(String.valueOf(aggregated.answerWaitSecond30)));
                            break;
                        }
                        case "answerWaitSecond40": {
                            table.addCell(this.getCellValue(String.valueOf(aggregated.answerWaitSecond40)));
                            break;
                        }
                        case "answerWaitSecond50": {
                            table.addCell(this.getCellValue(String.valueOf(aggregated.answerWaitSecond50)));
                            break;
                        }
                        case "answerWaitSecond60": {
                            table.addCell(this.getCellValue(String.valueOf(aggregated.answerWaitSecond60)));
                            break;
                        }
                        case "greaterAnswerWaitSecond60": {
                            table.addCell(this.getCellValue(String.valueOf(aggregated.greaterAnswerWaitSecond60)));
                            break;
                        }
                        case "abandonedWaitSecond10": {
                            table.addCell(this.getCellValue(String.valueOf(aggregated.abandonedWaitSecond10)));
                            break;
                        }
                        case "abandonedWaitSecond20": {
                            table.addCell(this.getCellValue(String.valueOf(aggregated.abandonedWaitSecond20)));
                            break;
                        }
                        case "abandonedWaitSecond30": {
                            table.addCell(this.getCellValue(String.valueOf(aggregated.abandonedWaitSecond30)));
                            break;
                        }
                        case "abandonedWaitSecond40": {
                            table.addCell(this.getCellValue(String.valueOf(aggregated.abandonedWaitSecond40)));
                            break;
                        }
                        case "abandonedWaitSecond50": {
                            table.addCell(this.getCellValue(String.valueOf(aggregated.abandonedWaitSecond50)));
                            break;
                        }
                        case "abandonedWaitSecond60": {
                            table.addCell(this.getCellValue(String.valueOf(aggregated.abandonedWaitSecond60)));
                            break;
                        }
                        case "greaterAbandonedWaitSecond60": {
                            table.addCell(this.getCellValue(String.valueOf(aggregated.greaterAbandonedWaitSecond60)));
                            break;
                        }
                        case "averageNumberAgent": {
                            table.addCell(this.getCellValue(String.valueOf(aggregated.averageNumberAgent)));
                            break;
                        }
                        case "averageAnswerWaitTime": {
                            table.addCell(DateFormatUtility.findLocalTime((Long)aggregated.averageAnswerWaitTime));
                            break;
                        }
                        case "totalAbandonedWaitTime": {
                            table.addCell(DateFormatUtility.findLocalTime((Long)aggregated.totalAbandonedWaitTime));
                            break;
                        }
                        case "totalAnswerWaitTime": {
                            table.addCell(DateFormatUtility.findLocalTime((Long)aggregated.totalAnswerWaitTime));
                            break;
                        }
                        case "averageAbandonedWaitTime": {
                            table.addCell(DateFormatUtility.findLocalTime((Long)aggregated.averageAbandonedWaitTime));
                            break;
                        }
                        case "averageTalkTime": {
                            table.addCell(DateFormatUtility.findLocalTime((Long)aggregated.averageTalkTime));
                            break;
                        }
                        case "servicePercentage": {
                            table.addCell(this.getCellValue(String.valueOf(aggregated.servicePercentage)));
                            break;
                        }
                        case "abandonedPercentage": {
                            table.addCell(this.getCellValue(String.valueOf(aggregated.abandonedPercentage)));
                            break;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
    }

    private String getCellValue(String value) {
        return value != null && !value.isEmpty() ? value : "";
    }

    private static void leaveEmptyLine(Paragraph paragraph, int number) {
        for (int i = 0; i < number; ++i) {
            paragraph.add((Element)new Paragraph(" "));
        }
    }

    private String getPdfNameWithDate() {
        String localDateString = LocalDateTime.now().format(DateTimeFormatter.ofPattern(reportFileNameDateFormat));
        return reportFileName + "-" + localDateString + ".pdf";
    }

    private static void addAdvanceFilterRequest(Document document, SearchRequest searchRequestData) throws DocumentException {
        List advancedFilters = searchRequestData.getAdvancedFilters();
        if (advancedFilters != null && !advancedFilters.isEmpty()) {
            Paragraph advancedFilterParagraph = new Paragraph();
            Font boldFont = new Font(Font.FontFamily.HELVETICA, 14.0f, 1);
            for (AdvanceFilter advanceFilter : advancedFilters) {
                advancedFilterParagraph.setFont(boldFont);
                if ("from".equals(advanceFilter.getDirection())) {
                    advancedFilterParagraph.add("Record on the basis of " + (String)columnMappings.get(advanceFilter.getFieldName()) + ": From " + advanceFilter.getValue());
                    continue;
                }
                if (!"to".equals(advanceFilter.getDirection())) continue;
                advancedFilterParagraph.add(" to " + advanceFilter.getValue());
                advancedFilterParagraph.add((Element)new Paragraph(""));
            }
            document.add((Element)advancedFilterParagraph);
        }
    }

    private void savePdfToDestination(byte[] pdfBytes, String destinationPath) {
        try (FileOutputStream fos = new FileOutputStream(destinationPath);){
            fos.write(pdfBytes);
            logger.info("PDF saved to: {}", (Object)destinationPath);
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("Failed to save PDF to: {}", (Object)destinationPath);
        }
    }

    public void createPdfReportRecord(String id, SearchRequest data, String filePath) {
        try {
            PdfReportFilters pdfReportFilters = new PdfReportFilters();
            ObjectMapper objectMapper = new ObjectMapper();
            pdfReportFilters.setId(id);
            pdfReportFilters.setReportName(reportFileName);
            pdfReportFilters.setFilterParameters(objectMapper.writeValueAsString((Object)data));
            pdfReportFilters.setCreatedOnDate(this.currentTime);
            pdfReportFilters.setPdfLocation(filePath);
            pdfReportFilters.setStatus("InProgress");
            this.pdfReportRepository.save((Object)pdfReportFilters);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

    private Map<String, Integer> getAgentCountMapByDate() {
        List allAgentCDRs = (List)this.agentCDRRepository.findAll();
        HashMap<String, Set> groupedAgents = new HashMap<String, Set>();
        for (AgentCDR cdr : allAgentCDRs) {
            if (cdr.getStartTime() == null || cdr.getQueue() == null || cdr.getCallDirection() == null || cdr.getAgentName() == null) continue;
            LocalDate date = Instant.ofEpochSecond(cdr.getStartTime()).atZone(ZoneId.systemDefault()).toLocalDate();
            String key = date.toString() + "|" + cdr.getQueue() + "|" + cdr.getCallDirection();
            groupedAgents.computeIfAbsent(key, k -> new HashSet()).add(cdr.getAgentName());
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (Map.Entry entry : groupedAgents.entrySet()) {
            result.put((String)entry.getKey(), ((Set)entry.getValue()).size());
        }
        return result;
    }

    static {
        columnMappings.put("queue", "Queue ID");
        columnMappings.put("queueName", "Queue Name");
        columnMappings.put("callDirection", "Call Direction");
        columnMappings.put("recordEpoch", "Record DateTime");
        columnMappings.put("totalJoined", "Total Call Offered");
        columnMappings.put("totalConnectedWithAgent", "Total Call Answered");
        columnMappings.put("totalAbandonedAtQueue", "ABD At ACD");
        columnMappings.put("totalCustomerAgentTalkTime", "Total Talk Time");
        columnMappings.put("totalCustomerTime", "Total Customer Time");
        columnMappings.put("totalNoContact", "Total No Answered");
        columnMappings.put("totalWaitTime", "Total Wait Time");
        columnMappings.put("totalAbandonedAtAgent", "ABD At Agent");
        columnMappings.put("answerWaitSecond10", "Ans Wait 10 Second");
        columnMappings.put("answerWaitSecond20", "Ans Wait 20 Second");
        columnMappings.put("answerWaitSecond30", "Ans Wait 30 Second");
        columnMappings.put("answerWaitSecond40", "Ans Wait 40 Second");
        columnMappings.put("answerWaitSecond50", "Ans Wait 50 Second");
        columnMappings.put("answerWaitSecond60", "Ans Wait 60 Second");
        columnMappings.put("greaterAnswerWaitSecond60", "Ans Wait >60 Second");
        columnMappings.put("abandonedWaitSecond10", "ABD Wait 10 Second");
        columnMappings.put("abandonedWaitSecond20", "ABD Wait 20 Second");
        columnMappings.put("abandonedWaitSecond30", "ABD Wait 30 Second");
        columnMappings.put("abandonedWaitSecond40", "ABD Wait 40 Second");
        columnMappings.put("abandonedWaitSecond50", "ABD Wait 50 Second");
        columnMappings.put("abandonedWaitSecond60", "ABD Wait 60 Second");
        columnMappings.put("greaterAbandonedWaitSecond60", "ABD Wait >60 Second");
        columnMappings.put("averageNumberAgent", "Avg No of Agent");
        columnMappings.put("averageAnswerWaitTime", "Avg Ans Wait Time");
        columnMappings.put("totalAbandonedWaitTime", "Total ABD Wait Time");
        columnMappings.put("totalAnswerWaitTime", "Total Ans Wait Time");
        columnMappings.put("averageAbandonedWaitTime", "Avg ABD Wait Time");
        columnMappings.put("averageTalkTime", "Avg Talk Time");
        columnMappings.put("servicePercentage", "Service %");
        columnMappings.put("abandonedPercentage", "Abandoned %");
    }
}

