/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.queuePerformance.controller;

import com.coraltele.db.telemetry.main.entity.AgentCDR;
import com.coraltele.db.telemetry.main.entity.QueuePerformance;
import com.coraltele.db.telemetry.main.repository.AgentCDRRepository;
import com.coraltele.db.telemetry.main.repository.QueuePerformanceRepository;
import com.coraltele.db.telemetry.main.specification.QueuePerformanceSpecification;
import com.coraltele.db.telemetry.main.specification.QueuePerformanceSpecificationNew;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.DownloadPdfService;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResultModel;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.coralApps.callcenter.queueTL.service.QueueTLService;
import com.coraltele.service.telemetry.main.queuePerformance.controller.QueuePerformanceController;
import com.coraltele.service.telemetry.main.queuePerformance.model.QueuePerformanceSummaryModel;
import com.coraltele.service.telemetry.main.queuePerformance.service.QueuePerformanceSummaryService;
import com.coraltele.service.user.service.UserService;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/queuePerformanceSummary"})
@RestController
public class QueuePerformanceSummaryController {
    private static final Logger logger = LogManager.getLogger(QueuePerformanceController.class);
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    QueuePerformanceRepository queuePerformanceRepository;
    @Autowired
    DownloadPdfService pdfDownloadService;
    @Autowired
    private DynamicPdfThreadService dynamicReportThreadServiceTest;
    @Autowired
    QueuePerformanceSummaryService queuePerformanceSummaryService;
    @Autowired
    UserService userService;
    @Autowired
    QueueTLService queueTLService;
    @Autowired
    private AgentCDRRepository agentCDRRepository;
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllByFilterForSummation(@RequestBody SearchRequest searchRequest, Principal principal) {
        RequestResponse returnValue = this.queuePerformanceSummaryService.getAllByFilterForSummation(searchRequest, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSV(@RequestBody SearchRequest searchRequestData, Principal principal) {
        try {
            logger.info("CSV file download started for queue performance--");
            List queueId = null;
            if (this.userService.checkRoleTL(principal.getName())) {
                queueId = this.queueTLService.getQueueListByTeamLeader(principal.getName());
            }
            Specification filters = QueuePerformanceSpecification.generateFilters((SearchRequest)searchRequestData, queueId);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "queue" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "queue" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.queuePerformanceRepository.findAll(filters, sort) : this.queuePerformanceRepository.findAll(filters);
            List allAgentCdrs = (List)this.agentCDRRepository.findAll();
            Map<String, Integer> agentCountMap = allAgentCdrs.stream().filter(cdr -> cdr.getStartTime() != null && cdr.getQueue() != null && cdr.getCallDirection() != null && cdr.getAgentName() != null).collect(Collectors.groupingBy(cdr -> {
                LocalDate date = Instant.ofEpochSecond(cdr.getStartTime()).atZone(ZoneId.systemDefault()).toLocalDate();
                return date + "|" + cdr.getQueue() + "|" + cdr.getCallDirection();
            }, Collectors.collectingAndThen(Collectors.mapping(AgentCDR::getAgentName, Collectors.toSet()), Set::size)));
            Map aggregatedData = this.aggregateDataByQueue(filteredData, agentCountMap);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (QueuePerformanceSummaryModel item : aggregatedData.values()) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValue(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for queue performance csv", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading queue performance  CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Map<String, QueuePerformanceSummaryModel> aggregateDataByQueue(List<QueuePerformance> filteredData, Map<String, Integer> agentCountMap) {
        HashMap<String, QueuePerformanceSummaryModel> summaryMap = new HashMap<String, QueuePerformanceSummaryModel>();
        for (QueuePerformance row : filteredData) {
            String queue = row.getQueue();
            String callDirection = row.getCallDirection();
            String compositeKey = queue + "|" + callDirection;
            QueuePerformanceSummaryModel data = summaryMap.getOrDefault(compositeKey, new QueuePerformanceSummaryModel());
            LocalDate recordDate = Instant.ofEpochSecond(row.getRecordEpoch()).atZone(ZoneId.systemDefault()).toLocalDate();
            String dateKey = recordDate + "|" + queue + "|" + callDirection;
            int agentsForDate = agentCountMap.getOrDefault(dateKey, 0);
            data.setAverageNumberAgent(Integer.valueOf((data.getAverageNumberAgent() != null ? data.getAverageNumberAgent() : 0) + agentsForDate));
            data.setCallDirection(row.getCallDirection());
            data.setQueue(queue);
            data.setQueueName(row.getQueueName());
            data.setRecordEpoch(this.dateFormatUtility.epochToLocalDateForLocalTimeZone(row.getRecordEpoch()));
            int totalAbdAtAgent = (data.getTotalAbandonedAtAgent() != null ? data.getTotalAbandonedAtAgent() : 0) + (row.getTotalAbandonedAtAgent() != null ? row.getTotalAbandonedAtAgent() : 0);
            int totalAbdAtQueue = (data.getTotalAbandonedAtQueue() != null ? data.getTotalAbandonedAtQueue() : 0) + (row.getTotalAbandonedAtQueue() != null ? row.getTotalAbandonedAtQueue() : 0);
            int totalConnectedWithAgent = (data.getTotalConnectedWithAgent() != null ? data.getTotalConnectedWithAgent() : 0) + (row.getTotalConnectedWithAgent() != null ? row.getTotalConnectedWithAgent() : 0);
            int totalJoined = (data.getTotalJoined() != null ? data.getTotalJoined() : 0) + (row.getTotalJoined() != null ? row.getTotalJoined() : 0);
            long waitTime1 = this.toLong(data.getTotalWaitTime());
            long waitTime2 = this.toLong((Object)row.getTotalWaitTime());
            long totalWaitTime = waitTime1 + waitTime2;
            Long abdWaitTime1 = this.toLong(data.getTotalAbandonedWaitTime());
            Long abdWaitTime2 = this.toLong((Object)row.getTotalAbandonedWaitTime());
            long totalAbdWaitTime = abdWaitTime1 + abdWaitTime2;
            long totalCustomerAgentTalkTimeSeconds = this.getDurationInSeconds(data.getTotalCustomerAgentTalkTime()) + this.getDurationInSeconds(DateFormatUtility.findLocalTime((Long)this.getDurationOrZero(Long.valueOf(row.getTotalCustomerAgentTalkTime()))));
            long avgTalkTime = totalConnectedWithAgent != 0 ? totalCustomerAgentTalkTimeSeconds / (long)totalConnectedWithAgent : 0L;
            long avgAnsWaitTime = totalConnectedWithAgent != 0 ? totalWaitTime / (long)totalConnectedWithAgent : 0L;
            double svcPercentage = totalJoined != 0 ? (double)totalConnectedWithAgent * 100.0 / (double)totalJoined : 0.0;
            double abdPercentage = totalJoined != 0 ? (double)(totalAbdAtAgent + totalAbdAtQueue) * 100.0 / (double)totalJoined : 0.0;
            long avgAbdWaitTime = totalAbdAtAgent + totalAbdAtQueue != 0 ? totalAbdWaitTime / (long)(totalAbdAtAgent + totalAbdAtQueue) : 0L;
            data.setTotalAbandonedAtAgent(Integer.valueOf(totalAbdAtAgent));
            data.setTotalAbandonedAtQueue(Integer.valueOf(totalAbdAtQueue));
            data.setTotalConnectedWithAgent(Integer.valueOf(totalConnectedWithAgent));
            data.setTotalCustomerAgentTalkTime(DateFormatUtility.findLocalTime((Long)totalCustomerAgentTalkTimeSeconds));
            long totalCustomerTimeSeconds = this.getDurationInSeconds(data.getTotalCustomerTime()) + this.getDurationInSeconds(DateFormatUtility.findLocalTime((Long)this.getDurationOrZero(Long.valueOf(row.getTotalCustomerTime()))));
            data.setTotalCustomerTime(DateFormatUtility.findLocalTime((Long)totalCustomerTimeSeconds));
            data.setTotalJoined(Integer.valueOf(totalJoined));
            data.setTotalNoContact(Integer.valueOf((data.getTotalNoContact() != null ? data.getTotalNoContact() : 0) + (row.getTotalNoContact() != null ? row.getTotalNoContact() : 0)));
            data.setTotalWaitTime((Object)DateFormatUtility.findLocalTime((Long)totalWaitTime));
            data.setAnswerWaitSecond10(Integer.valueOf((data.getAnswerWaitSecond10() != null ? data.getAnswerWaitSecond10() : 0) + (row.getAnswerWaitSecond10() != null ? row.getAnswerWaitSecond10() : 0)));
            data.setAnswerWaitSecond20(Integer.valueOf((data.getAnswerWaitSecond20() != null ? data.getAnswerWaitSecond20() : 0) + (row.getAnswerWaitSecond20() != null ? row.getAnswerWaitSecond20() : 0)));
            data.setAnswerWaitSecond30(Integer.valueOf((data.getAnswerWaitSecond30() != null ? data.getAnswerWaitSecond30() : 0) + (row.getAnswerWaitSecond30() != null ? row.getAnswerWaitSecond30() : 0)));
            data.setAnswerWaitSecond40(Integer.valueOf((data.getAnswerWaitSecond40() != null ? data.getAnswerWaitSecond40() : 0) + (row.getAnswerWaitSecond40() != null ? row.getAnswerWaitSecond40() : 0)));
            data.setAnswerWaitSecond50(Integer.valueOf((data.getAnswerWaitSecond50() != null ? data.getAnswerWaitSecond50() : 0) + (row.getAnswerWaitSecond50() != null ? row.getAnswerWaitSecond50() : 0)));
            data.setAnswerWaitSecond60(Integer.valueOf((data.getAnswerWaitSecond60() != null ? data.getAnswerWaitSecond60() : 0) + (row.getAnswerWaitSecond60() != null ? row.getAnswerWaitSecond60() : 0)));
            data.setGreaterAnswerWaitSecond60(Integer.valueOf((data.getGreaterAnswerWaitSecond60() != null ? data.getGreaterAnswerWaitSecond60() : 0) + (row.getGreaterAnswerWaitSecond60() != null ? row.getGreaterAnswerWaitSecond60() : 0)));
            data.setAbandonedWaitSecond10(Integer.valueOf((data.getAbandonedWaitSecond10() != null ? data.getAbandonedWaitSecond10() : 0) + (row.getAbandonedWaitSecond10() != null ? row.getAbandonedWaitSecond10() : 0)));
            data.setAbandonedWaitSecond20(Integer.valueOf((data.getAbandonedWaitSecond20() != null ? data.getAbandonedWaitSecond20() : 0) + (row.getAbandonedWaitSecond20() != null ? row.getAbandonedWaitSecond20() : 0)));
            data.setAbandonedWaitSecond30(Integer.valueOf((data.getAbandonedWaitSecond30() != null ? data.getAbandonedWaitSecond30() : 0) + (row.getAbandonedWaitSecond30() != null ? row.getAbandonedWaitSecond30() : 0)));
            data.setAbandonedWaitSecond40(Integer.valueOf((data.getAbandonedWaitSecond40() != null ? data.getAbandonedWaitSecond40() : 0) + (row.getAbandonedWaitSecond40() != null ? row.getAbandonedWaitSecond40() : 0)));
            data.setAbandonedWaitSecond50(Integer.valueOf((data.getAbandonedWaitSecond50() != null ? data.getAbandonedWaitSecond50() : 0) + (row.getAbandonedWaitSecond50() != null ? row.getAbandonedWaitSecond50() : 0)));
            data.setAbandonedWaitSecond60(Integer.valueOf((data.getAbandonedWaitSecond60() != null ? data.getAbandonedWaitSecond60() : 0) + (row.getAbandonedWaitSecond60() != null ? row.getAbandonedWaitSecond60() : 0)));
            data.setGreaterAbandonedWaitSecond60(Integer.valueOf((data.getGreaterAbandonedWaitSecond60() != null ? data.getGreaterAbandonedWaitSecond60() : 0) + (row.getGreaterAbandonedWaitSecond60() != null ? row.getGreaterAbandonedWaitSecond60() : 0)));
            Long answerWaitTime1 = this.toLong(data.getTotalAnswerWaitTime());
            Long answerWaitTime2 = this.toLong((Object)row.getTotalAnswerWaitTime());
            long totalAnsWaitTime = answerWaitTime1 + answerWaitTime2;
            data.setTotalAnswerWaitTime((Object)DateFormatUtility.findLocalTime((Long)totalAnsWaitTime));
            data.setTotalAbandonedWaitTime((Object)DateFormatUtility.findLocalTime((Long)totalAbdWaitTime));
            data.setAverageAbandonedWaitTime(DateFormatUtility.findLocalTime((Long)avgAbdWaitTime));
            data.setAverageTalkTime(DateFormatUtility.findLocalTime((Long)avgTalkTime));
            data.setAverageAnswerWaitTime(DateFormatUtility.findLocalTime((Long)avgAnsWaitTime));
            data.setServicePercentage(Double.valueOf(svcPercentage));
            data.setAbandonedPercentage(Double.valueOf(abdPercentage));
            summaryMap.put(compositeKey, data);
        }
        return summaryMap;
    }

    private Object getColumnValue(QueuePerformanceSummaryModel item, String columnName) {
        switch (columnName) {
            case "queue": {
                return this.checkNull((Object)item.getQueue());
            }
            case "queueName": {
                return this.checkNull((Object)item.getQueueName());
            }
            case "callDirection": {
                return this.checkNull((Object)item.getCallDirection());
            }
            case "recordEpoch": {
                return this.checkNull((Object)item.getRecordEpoch());
            }
            case "totalJoined": {
                return this.checkNull((Object)item.getTotalJoined());
            }
            case "totalConnectedWithAgent": {
                return this.checkNull((Object)item.getTotalConnectedWithAgent());
            }
            case "totalAbandonedAtQueue": {
                return this.checkNull((Object)item.getTotalAbandonedAtQueue());
            }
            case "totalCustomerAgentTalkTime": {
                return this.checkNull((Object)item.getTotalCustomerAgentTalkTime());
            }
            case "totalCustomerTime": {
                return this.checkNull((Object)item.getTotalCustomerTime());
            }
            case "totalNoContact": {
                return this.checkNull((Object)item.getTotalNoContact());
            }
            case "totalWaitTime": {
                return this.checkNull(item.getTotalWaitTime());
            }
            case "totalAbandonedAtAgent": {
                return this.checkNull((Object)item.getTotalAbandonedAtAgent());
            }
            case "answerWaitSecond10": {
                return this.checkNull((Object)item.getAnswerWaitSecond10());
            }
            case "answerWaitSecond20": {
                return this.checkNull((Object)item.getAnswerWaitSecond20());
            }
            case "answerWaitSecond30": {
                return this.checkNull((Object)item.getAnswerWaitSecond30());
            }
            case "answerWaitSecond40": {
                return this.checkNull((Object)item.getAnswerWaitSecond40());
            }
            case "answerWaitSecond50": {
                return this.checkNull((Object)item.getAnswerWaitSecond50());
            }
            case "answerWaitSecond60": {
                return this.checkNull((Object)item.getAnswerWaitSecond60());
            }
            case "greaterAnswerWaitSecond60": {
                return this.checkNull((Object)item.getGreaterAnswerWaitSecond60());
            }
            case "abandonedWaitSecond10": {
                return this.checkNull((Object)item.getAbandonedWaitSecond10());
            }
            case "abandonedWaitSecond20": {
                return this.checkNull((Object)item.getAbandonedWaitSecond20());
            }
            case "abandonedWaitSecond30": {
                return this.checkNull((Object)item.getAbandonedWaitSecond30());
            }
            case "abandonedWaitSecond40": {
                return this.checkNull((Object)item.getAbandonedWaitSecond40());
            }
            case "abandonedWaitSecond50": {
                return this.checkNull((Object)item.getAbandonedWaitSecond50());
            }
            case "abandonedWaitSecond60": {
                return this.checkNull((Object)item.getAbandonedWaitSecond60());
            }
            case "greaterAbandonedWaitSecond60": {
                return this.checkNull((Object)item.getGreaterAbandonedWaitSecond60());
            }
            case "averageNumberAgent": {
                return this.checkNull((Object)item.getAverageNumberAgent());
            }
            case "totalAbandonedWaitTime": {
                return this.checkNull(item.getTotalAbandonedWaitTime());
            }
            case "totalAnswerWaitTime": {
                return this.checkNull(item.getTotalAnswerWaitTime());
            }
            case "averageAnswerWaitTime": {
                return this.checkNull((Object)item.getAverageAnswerWaitTime());
            }
            case "averageAbandonedWaitTime": {
                return this.checkNull((Object)item.getAverageAbandonedWaitTime());
            }
            case "averageTalkTime": {
                return this.checkNull((Object)item.getAverageTalkTime());
            }
            case "servicePercentage": {
                return this.checkNull((Object)item.getServicePercentage());
            }
            case "abandonedPercentage": {
                return this.checkNull((Object)item.getAbandonedPercentage());
            }
        }
        return null;
    }

    private String checkNull(Object value) {
        return value != null ? value.toString() : "";
    }

    private long getDurationInSeconds(String duration) {
        if (duration == null || duration.isEmpty()) {
            return 0L;
        }
        String[] parts = duration.split(":");
        long hours = Long.parseLong(parts[0]);
        long minutes = Long.parseLong(parts[1]);
        long seconds = Long.parseLong(parts[2]);
        return hours * 3600L + minutes * 60L + seconds;
    }

    private long getDurationOrZero(Long duration) {
        return duration != null ? duration : 0L;
    }

    @PostMapping(value={"/generateAndDownloadPdf"})
    public CompletableFuture<ResponseEntity<?>> generateAndDownloadPdf(@RequestParam String reportType, @RequestBody SearchRequest searchRequestData, Principal principal) {
        String folderPath = "/tmp/";
        File folder = new File(folderPath);
        String fileNamePrefix = reportType + "_";
        File[] files = folder.listFiles((dir, name) -> name.startsWith(fileNamePrefix));
        if (files != null) {
            for (File file : files) {
                if (file.delete()) {
                    logger.info("Deleted existing report: {}" + file.getName());
                    continue;
                }
                logger.error("Failed to delete existing report: {}" + file.getName());
            }
        }
        String filePath = "/tmp/" + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        CompletableFuture generationFuture = this.dynamicReportThreadServiceTest.startGeneratingReportAsync(reportType, id, searchRequestData, filePath, principal);
        return generationFuture.thenApply(response -> {
            if (response.getStatus().equals((Object)Constants.Error.OK)) {
                ResponseEntity downloadResponse = this.pdfDownloadService.getPdfFile(filePath);
                if (downloadResponse.getStatusCode().is2xxSuccessful()) {
                    return ResponseEntity.ok().body(downloadResponse.getBody());
                }
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to download PDF. Reason: " + downloadResponse.getStatusCode()));
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(response);
        });
    }

    private long toLong(Object obj) {
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        if (obj instanceof String) {
            try {
                return Long.parseLong((String)obj);
            }
            catch (NumberFormatException e) {
                return 0L;
            }
        }
        return 0L;
    }

    @PostMapping(value={"/downloadCSV1"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSV1(@RequestBody SearchResultModel searchRequestData, Principal principal) {
        try {
            logger.info("CSV file download started for queue performance--");
            Specification filters = QueuePerformanceSpecificationNew.buildSpecification((SearchResultModel)searchRequestData);
            List filteredData = this.queuePerformanceRepository.findAll(filters);
            List allAgentCdrs = (List)this.agentCDRRepository.findAll();
            Map<String, Integer> agentCountMap = allAgentCdrs.stream().filter(cdr -> cdr.getStartTime() != null && cdr.getQueue() != null && cdr.getCallDirection() != null && cdr.getAgentName() != null).collect(Collectors.groupingBy(cdr -> {
                LocalDate date = Instant.ofEpochSecond(cdr.getStartTime()).atZone(ZoneId.systemDefault()).toLocalDate();
                return date + "|" + cdr.getQueue() + "|" + cdr.getCallDirection();
            }, Collectors.collectingAndThen(Collectors.mapping(AgentCDR::getAgentName, Collectors.toSet()), Set::size)));
            Map aggregatedData = this.aggregateDataByQueue(filteredData, agentCountMap);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getSelectedColumns());
                List displayNames = searchRequestData.getSelectedColumns().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (QueuePerformanceSummaryModel item : aggregatedData.values()) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName2 : searchRequestData.getSelectedColumns()) {
                        values.add(this.getColumnValue(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for queue performance csv", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading queue performance  CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    static {
        columnMappings.put("queue", "Queue ID");
        columnMappings.put("queueName", "Queue Name");
        columnMappings.put("callDirection", "Call Direction");
        columnMappings.put("recordEpoch", "Record DateTime");
        columnMappings.put("totalJoined", "Total Call Offered");
        columnMappings.put("totalConnectedWithAgent", "Total Call Answered");
        columnMappings.put("totalAbandonedAtQueue", "ABD At ACD");
        columnMappings.put("totalCustomerAgentTalkTime", "Total Talk Time");
        columnMappings.put("totalCustomerTime", "Total Customer Time");
        columnMappings.put("totalNoContact", "Total No Answered");
        columnMappings.put("totalWaitTime", "Total Wait Time");
        columnMappings.put("totalAbandonedAtAgent", "ABD At Agent");
        columnMappings.put("answerWaitSecond10", "Ans Wait 10 Second");
        columnMappings.put("answerWaitSecond20", "Ans Wait 20 Second");
        columnMappings.put("answerWaitSecond30", "Ans Wait 30 Second");
        columnMappings.put("answerWaitSecond40", "Ans Wait 40 Second");
        columnMappings.put("answerWaitSecond50", "Ans Wait 50 Second");
        columnMappings.put("answerWaitSecond60", "Ans Wait 60 Second");
        columnMappings.put("greaterAnswerWaitSecond60", "Ans Wait >60 Second");
        columnMappings.put("abandonedWaitSecond10", "ABD Wait 10 Second");
        columnMappings.put("abandonedWaitSecond20", "ABD Wait 20 Second");
        columnMappings.put("abandonedWaitSecond30", "ABD Wait 30 Second");
        columnMappings.put("abandonedWaitSecond40", "ABD Wait 40 Second");
        columnMappings.put("abandonedWaitSecond50", "ABD Wait 50 Second");
        columnMappings.put("abandonedWaitSecond60", "ABD Wait 60 Second");
        columnMappings.put("greaterAbandonedWaitSecond60", "ABD Wait >60 Second");
        columnMappings.put("averageNumberAgent", "Avg No of Agent");
        columnMappings.put("averageAnswerWaitTime", "Avg Ans Wait Time");
        columnMappings.put("totalAbandonedWaitTime", "Total ABD Wait Time");
        columnMappings.put("totalAnswerWaitTime", "Total Ans Wait Time");
        columnMappings.put("averageAbandonedWaitTime", "Avg ABD Wait Time");
        columnMappings.put("averageTalkTime", "Avg Talk Time");
        columnMappings.put("servicePercentage", "Service %");
        columnMappings.put("abandonedPercentage", "Abandoned %");
    }
}

