/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.locationCategoryService.service;

import com.coraltele.db.telemetry.main.entity.LocationCategoryService;
import com.coraltele.db.telemetry.main.repository.LocationCategoryServiceRepository;
import com.coraltele.db.telemetry.main.specification.LocationCategoryServiceSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.main.locationCategoryService.model.LocationCategoryServiceModel;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class LocationCategoryServiceService {
    private static final Logger logger = LogManager.getLogger(LocationCategoryServiceService.class);
    @Autowired
    LocationCategoryServiceRepository locationCategoryServiceRepository;

    public RequestResponse createCategoryService(LocationCategoryServiceModel data) {
        logger.debug("create new LocationCategoryServiceModel : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            LocationCategoryService locationCategoryService = new LocationCategoryService();
            locationCategoryService.setCategory(data.getCategory());
            locationCategoryService.setDisableNotification(Boolean.valueOf(data.getDisableNotification() != false));
            locationCategoryService.setEscalationLevel0MailId(data.getEscalationLevel0MailId());
            locationCategoryService.setEscalationLevel0SmsId(data.getEscalationLevel0SmsId());
            locationCategoryService.setEscalationLevel1Duration(data.getEscalationLevel1Duration());
            locationCategoryService.setEscalationLevel1MailId(data.getEscalationLevel1MailId());
            locationCategoryService.setEscalationLevel1SmsId(data.getEscalationLevel1SmsId());
            locationCategoryService.setEscalationLevel2Duration(data.getEscalationLevel2Duration());
            locationCategoryService.setEscalationLevel2MailId(data.getEscalationLevel2MailId());
            locationCategoryService.setEscalationLevel2SmsId(data.getEscalationLevel2SmsId());
            locationCategoryService.setEscalationLevel3Duration(data.getEscalationLevel3Duration());
            locationCategoryService.setEscalationLevel3MailId(data.getEscalationLevel3MailId());
            locationCategoryService.setEscalationLevel3SmsId(data.getEscalationLevel3SmsId());
            locationCategoryService.setLocation(data.getLocation());
            this.locationCategoryServiceRepository.save((Object)locationCategoryService);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("LocationCategoryService created successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to create LocationCategoryService");
            returnValue.setMessageDetail("Contact with administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateById(LocationCategoryServiceModel data) {
        logger.debug("Update LocationCategoryServiceModel {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional categoryServiceOptional = this.locationCategoryServiceRepository.findById((Object)data.getId());
        if (!categoryServiceOptional.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("LocationCategoryServiceModel not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        LocationCategoryService locationCategoryService = (LocationCategoryService)categoryServiceOptional.get();
        locationCategoryService.setCategory(data.getCategory());
        locationCategoryService.setDisableNotification(Boolean.valueOf(data.getDisableNotification() != false));
        locationCategoryService.setEscalationLevel0MailId(data.getEscalationLevel0MailId());
        locationCategoryService.setEscalationLevel0SmsId(data.getEscalationLevel0SmsId());
        locationCategoryService.setEscalationLevel1Duration(data.getEscalationLevel1Duration());
        locationCategoryService.setEscalationLevel1MailId(data.getEscalationLevel1MailId());
        locationCategoryService.setEscalationLevel1SmsId(data.getEscalationLevel1SmsId());
        locationCategoryService.setEscalationLevel2Duration(data.getEscalationLevel2Duration());
        locationCategoryService.setEscalationLevel2MailId(data.getEscalationLevel2MailId());
        locationCategoryService.setEscalationLevel2SmsId(data.getEscalationLevel2SmsId());
        locationCategoryService.setEscalationLevel3Duration(data.getEscalationLevel3Duration());
        locationCategoryService.setEscalationLevel3MailId(data.getEscalationLevel3MailId());
        locationCategoryService.setEscalationLevel3SmsId(data.getEscalationLevel3SmsId());
        locationCategoryService.setLocation(data.getLocation());
        this.locationCategoryServiceRepository.save((Object)locationCategoryService);
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("LocationCategoryService Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteCategoryServiceById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Long ids : data.getId()) {
            Optional categoryService = this.locationCategoryServiceRepository.findById((Object)ids);
            if (categoryService.isPresent()) {
                addValue.add(categoryService.get());
                this.locationCategoryServiceRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getCategoryServiceByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = LocationCategoryServiceSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.locationCategoryServiceRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.locationCategoryServiceRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

