/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.agentIntervalReport.service;

import com.coraltele.db.telemetry.main.entity.view.AgentHourlyIntervalView;
import com.coraltele.db.telemetry.main.entity.view.AgentTimeIntervalThirtyView;
import com.coraltele.db.telemetry.main.repository.AgentHourlyIntervalViewRepository;
import com.coraltele.db.telemetry.main.repository.AgentTimeIntervalThirtyViewRepository;
import com.coraltele.db.telemetry.main.specification.AgentHourlyIntervalViewSpecification;
import com.coraltele.db.telemetry.main.specification.AgentTimeIntervalThirtyViewSpecification;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.main.agentIntervalReport.model.AgentTimeIntervalThirtyModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class AgentIntervalServices {
    private static final Logger logger = LogManager.getLogger(AgentIntervalServices.class);
    @Autowired
    AgentTimeIntervalThirtyViewRepository agentTimeIntervalThirtyViewRepository;
    @Autowired
    AgentHourlyIntervalViewSpecification agentHourlyIntervalViewSpecification;
    @Autowired
    AgentHourlyIntervalViewRepository agentHourlyIntervalViewRepository;

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = AgentTimeIntervalThirtyViewSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "queue" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "queue" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.agentTimeIntervalThirtyViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.agentTimeIntervalThirtyViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<AgentTimeIntervalThirtyModel> entityToModelConversion(List<AgentTimeIntervalThirtyView> viewList) {
        ArrayList<AgentTimeIntervalThirtyModel> result = new ArrayList<AgentTimeIntervalThirtyModel>();
        for (AgentTimeIntervalThirtyView row : viewList) {
            AgentTimeIntervalThirtyModel data = new AgentTimeIntervalThirtyModel();
            data.setSt(this.formateDateString(row.getSt().toString()));
            data.setEt(this.formateDateString(row.getEt().toString()));
            data.setAgentName(row.getAgentName());
            data.setFullName(row.getFullName());
            data.setQueue(row.getQueue());
            data.setCallOffered(row.getCallOffered());
            data.setAnswered(row.getAnswered());
            data.setNoAnswer(row.getNoAnswer());
            data.setInTalkTime(row.getInTalkTime());
            data.setCallDialed(row.getCallDialed());
            data.setConnected(row.getConnected());
            data.setNotConnected(row.getNotConnected());
            data.setOutTalkTime(row.getOutTalkTime());
            result.add(data);
        }
        return result;
    }

    public RequestResponse getAllSixtyByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = AgentHourlyIntervalViewSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "queue" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "queue" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.agentHourlyIntervalViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.agentHourlyIntervalViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversionSixty(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<AgentTimeIntervalThirtyModel> entityToModelConversionSixty(List<AgentHourlyIntervalView> viewList) {
        ArrayList<AgentTimeIntervalThirtyModel> result = new ArrayList<AgentTimeIntervalThirtyModel>();
        for (AgentHourlyIntervalView row : viewList) {
            AgentTimeIntervalThirtyModel data = new AgentTimeIntervalThirtyModel();
            data.setSt(this.formateDateString(row.getSt().toString()));
            data.setEt(this.formateDateString(row.getEt().toString()));
            data.setAgentName(row.getAgentName());
            data.setFullName(row.getFullName());
            data.setQueue(row.getQueue());
            data.setCallOffered(row.getCallOffered());
            data.setAnswered(row.getAnswered());
            data.setNoAnswer(row.getNoAnswer());
            data.setInTalkTime(row.getInTalkTime());
            data.setCallDialed(row.getCallDialed());
            data.setConnected(row.getConnected());
            data.setNotConnected(row.getNotConnected());
            data.setOutTalkTime(row.getOutTalkTime());
            result.add(data);
        }
        return result;
    }

    private String formateDateString(String dateString) {
        if (dateString == null) {
            return "";
        }
        return dateString.replace("T", " ");
    }
}

