/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.agentIntervalReport.service;

import com.coraltele.db.billing.main.entity.PdfReportFilters;
import com.coraltele.db.billing.main.repository.PdfReportRepository;
import com.coraltele.db.telemetry.main.entity.view.AgentHourlyIntervalView;
import com.coraltele.db.telemetry.main.repository.AgentHourlyIntervalViewRepository;
import com.coraltele.db.telemetry.main.specification.AgentHourlyIntervalViewSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.PdfPageNumberEvent;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.AdvanceFilter;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.background.PdfGeneratorService;
import com.coraltele.service.coralApps.callcenter.queueTL.service.QueueTLService;
import com.coraltele.service.telemetry.main.agentIntervalReport.service.AgentTimeIntervalThirtyPdf;
import com.coraltele.service.user.service.UserService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.itextpdf.text.BadElementException;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Principal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service(value="AgentTimeIntervalHourlyPdf")
public class AgentHourlyIntervalPdf
implements PdfGeneratorService {
    private static String reportFileName = "Agent-Time-hourly-Interval";
    private static String reportFileNameDateFormat = "dd_MMMM_yyyy";
    private static String localDateFormat = "dd-MM-yyyy hh:mm:ss a";
    LocalDateTime currentTime = null;
    private static String logoImgPath = "/var/www/html/apple-icon.png";
    private static int noOfColumns = 0;
    private static final Logger logger = LogManager.getLogger(AgentTimeIntervalThirtyPdf.class);
    @Autowired
    AgentHourlyIntervalViewRepository AgentHourlyIntervalViewRepository;
    @Autowired
    DynamicPdfThreadService generatingReports;
    @Autowired
    private PdfReportRepository pdfReportRepository;
    @Autowired
    PdfPageNumberEvent pageNumberEvent;
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    UserService userService;
    @Autowired
    QueueTLService queueTLService;
    private static Font COURIER = new Font(Font.FontFamily.COURIER, 20.0f, 1);
    private static Font COURIER_SMALL = new Font(Font.FontFamily.COURIER, 14.0f, 1);
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();

    public void init(LocalDateTime currentTime) {
        try {
            this.pageNumberEvent.initialize(logoImgPath, reportFileName, localDateFormat, currentTime);
        }
        catch (BadElementException | IOException e) {
            e.printStackTrace();
        }
    }

    public RequestResponse generatePdfReport(SearchRequest searchRequestData, String filePath, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        this.currentTime = LocalDateTime.now();
        this.init(this.currentTime);
        logger.info("Start generating pdf for matched columns:");
        try {
            noOfColumns = searchRequestData.getColumnNames().size();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Document document = noOfColumns > 5 ? new Document(PageSize.A3.rotate()) : new Document(PageSize.A4);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
            writer.setPageEvent((PdfPageEvent)this.pageNumberEvent);
            document.open();
            this.addLogoAndDocTitle(document, searchRequestData, Integer.valueOf(noOfColumns));
            if (searchRequestData.advancedFilters != null && !searchRequestData.advancedFilters.isEmpty()) {
                AgentHourlyIntervalPdf.addAdvanceFilterRequest((Document)document, (SearchRequest)searchRequestData);
            }
            document.newPage();
            this.createTable(document, noOfColumns, searchRequestData);
            document.close();
            byte[] pdfBytes = byteArrayOutputStream.toByteArray();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
            String filename = this.getPdfNameWithDate();
            this.savePdfToDestination(pdfBytes, filePath);
            headers.setContentDispositionFormData(filename, filename);
            headers.setCacheControl("must-revalidate, post-check=0, pre-check=0");
            logger.info("PDF generated successfully and saved to: {}", (Object)filePath);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("File generated and saved successfully");
            returnValue.setData((Object)filePath);
            logger.info("NMS report generated and saved successfully");
            return returnValue;
        }
        catch (DocumentException e) {
            e.printStackTrace();
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("failed to download");
            logger.info("NMS report failed to download");
            return returnValue;
        }
    }

    private void addLogoAndDocTitle(Document document, SearchRequest filterRequest, Integer columns) {
        try {
            logger.info("finding logo from location");
            PdfPTable table = new PdfPTable(1);
            table.setWidthPercentage(100.0f);
            PdfPCell logoCell = new PdfPCell();
            logoCell.setHorizontalAlignment(1);
            logoCell.setBorder(0);
            Image img = Image.getInstance((String)logoImgPath);
            if (columns > 5) {
                img.scaleAbsolute(document.getPageSize().getWidth() * 0.5f, document.getPageSize().getHeight() * 0.4f);
                img.setAlignment(1);
                logoCell.addElement((Element)img);
            } else {
                img.scaleAbsolute(document.getPageSize().getWidth() * 0.7f, document.getPageSize().getHeight() * 0.4f);
                img.setAlignment(1);
                logoCell.addElement((Element)img);
            }
            PdfPCell reportNameCell = new PdfPCell();
            reportNameCell.setHorizontalAlignment(1);
            reportNameCell.setBorder(0);
            Paragraph p1 = new Paragraph(reportFileName, COURIER);
            reportNameCell.addElement((Element)p1);
            PdfPCell dateTimeCell = new PdfPCell();
            dateTimeCell.setHorizontalAlignment(1);
            dateTimeCell.setBorder(0);
            String localDateString = this.currentTime.format(DateTimeFormatter.ofPattern(localDateFormat));
            Paragraph p2 = new Paragraph("Report generated on " + localDateString, COURIER_SMALL);
            dateTimeCell.addElement((Element)p2);
            table.addCell(logoCell);
            table.addCell(reportNameCell);
            table.addCell(dateTimeCell);
            document.add((Element)table);
            logger.info("successfully found logo for pdf");
        }
        catch (DocumentException | IOException e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
    }

    private void createTable(Document document, int noOfColumns, SearchRequest searchRequestData) throws DocumentException {
        try {
            logger.info("Starting creation of table for pdf");
            Specification filters = AgentHourlyIntervalViewSpecification.generateFilters((SearchRequest)searchRequestData);
            String sortBy = searchRequestData.getSortBy();
            String sortDir = searchRequestData.getSortDirection();
            if (sortBy == null || sortBy.trim().isEmpty()) {
                sortBy = "st";
            }
            if (sortDir == null || sortDir.trim().isEmpty()) {
                sortDir = "asc";
            }
            Sort sort = null;
            if ("asc".equalsIgnoreCase(sortDir)) {
                sort = Sort.by((String[])new String[]{sortBy}).ascending();
            } else if ("desc".equalsIgnoreCase(sortDir)) {
                sort = Sort.by((String[])new String[]{sortBy}).descending();
            }
            List filteredData = sort != null ? this.AgentHourlyIntervalViewRepository.findAll(filters, sort) : this.AgentHourlyIntervalViewRepository.findAll(filters);
            PdfPTable table = new PdfPTable(searchRequestData.getColumnNames().size());
            for (String columnName : searchRequestData.getColumnNames()) {
                BaseColor lightBlue = new BaseColor(2, 111, 194);
                PdfPCell cell = new PdfPCell(new Phrase((String)columnMappings.get(columnName), new Font(Font.FontFamily.HELVETICA, 12.0f, 1, BaseColor.WHITE)));
                cell.setHorizontalAlignment(1);
                cell.setBackgroundColor(lightBlue);
                cell.setBorder(0);
                table.addCell(cell);
            }
            table.setHeaderRows(1);
            this.getDbData(table, filteredData, searchRequestData.getColumnNames());
            document.add((Element)table);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
    }

    private void getDbData(PdfPTable table, List<AgentHourlyIntervalView> filteredData, List<String> columnNames) {
        if (filteredData == null || filteredData.isEmpty()) {
            return;
        }
        BaseColor lightBackground = new BaseColor(230, 230, 230);
        for (int rowIndex = 0; rowIndex < filteredData.size(); ++rowIndex) {
            AgentHourlyIntervalView v = filteredData.get(rowIndex);
            table.getDefaultCell().setHorizontalAlignment(1);
            table.getDefaultCell().setVerticalAlignment(5);
            table.getDefaultCell().setBorder(0);
            table.getDefaultCell().setBackgroundColor(rowIndex % 2 == 0 ? BaseColor.WHITE : lightBackground);
            Iterator<String> iterator = columnNames.iterator();
            block31: while (iterator.hasNext()) {
                String column;
                switch (column = iterator.next()) {
                    case "st": {
                        table.addCell(this.safe((Object)this.formateDateString(v.getSt().toString())));
                        continue block31;
                    }
                    case "et": {
                        table.addCell(this.safe((Object)this.formateDateString(v.getEt().toString())));
                        continue block31;
                    }
                    case "agentName": {
                        table.addCell(this.safe((Object)v.getAgentName()));
                        continue block31;
                    }
                    case "fullName": {
                        table.addCell(this.safe((Object)v.getFullName()));
                        continue block31;
                    }
                    case "queue": {
                        table.addCell(this.safe((Object)v.getQueue()));
                        continue block31;
                    }
                    case "callOffered": {
                        table.addCell(this.safe((Object)v.getCallOffered()));
                        continue block31;
                    }
                    case "answered": {
                        table.addCell(this.safe((Object)v.getAnswered()));
                        continue block31;
                    }
                    case "noAnswer": {
                        table.addCell(this.safe((Object)v.getNoAnswer()));
                        continue block31;
                    }
                    case "inTalkTime": {
                        table.addCell(this.safe((Object)v.getInTalkTime()));
                        continue block31;
                    }
                    case "callDialed": {
                        table.addCell(this.safe((Object)v.getCallDialed()));
                        continue block31;
                    }
                    case "connected": {
                        table.addCell(this.safe((Object)v.getConnected()));
                        continue block31;
                    }
                    case "notConnected": {
                        table.addCell(this.safe((Object)v.getNotConnected()));
                        continue block31;
                    }
                    case "outTalkTime": {
                        table.addCell(this.safe((Object)v.getOutTalkTime()));
                        continue block31;
                    }
                }
                table.addCell("");
            }
        }
    }

    private String formateDateString(String dateString) {
        if (dateString == null) {
            return "";
        }
        return dateString.replace("T", " ");
    }

    private String safe(Object value) {
        return value == null ? "" : value.toString();
    }

    private String getPdfNameWithDate() {
        String localDateString = LocalDateTime.now().format(DateTimeFormatter.ofPattern(reportFileNameDateFormat));
        return reportFileName + "-" + localDateString + ".pdf";
    }

    private static void addAdvanceFilterRequest(Document document, SearchRequest searchRequestData) throws DocumentException {
        List advancedFilters = searchRequestData.getAdvancedFilters();
        if (advancedFilters != null && !advancedFilters.isEmpty()) {
            Paragraph advancedFilterParagraph = new Paragraph();
            Font boldFont = new Font(Font.FontFamily.HELVETICA, 14.0f, 1);
            for (AdvanceFilter advanceFilter : advancedFilters) {
                advancedFilterParagraph.setFont(boldFont);
                if ("from".equals(advanceFilter.getDirection())) {
                    advancedFilterParagraph.add("Record on the basis of " + (String)columnMappings.get(advanceFilter.getFieldName()) + ": From " + advanceFilter.getValue());
                    continue;
                }
                if (!"to".equals(advanceFilter.getDirection())) continue;
                advancedFilterParagraph.add(" to " + advanceFilter.getValue());
                advancedFilterParagraph.add((Element)new Paragraph(""));
            }
            document.add((Element)advancedFilterParagraph);
        }
    }

    private void savePdfToDestination(byte[] pdfBytes, String destinationPath) {
        try (FileOutputStream fos = new FileOutputStream(destinationPath);){
            fos.write(pdfBytes);
            logger.info("PDF saved to: {}", (Object)destinationPath);
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("Failed to save PDF to: {}", (Object)destinationPath);
        }
    }

    public void createPdfReportRecord(String id, SearchRequest data, String filePath) {
        try {
            PdfReportFilters pdfReportFilters = new PdfReportFilters();
            ObjectMapper objectMapper = new ObjectMapper();
            pdfReportFilters.setId(id);
            pdfReportFilters.setReportName(reportFileName);
            pdfReportFilters.setFilterParameters(objectMapper.writeValueAsString((Object)data));
            pdfReportFilters.setCreatedOnDate(this.currentTime);
            pdfReportFilters.setPdfLocation(filePath);
            pdfReportFilters.setStatus("InProgress");
            this.pdfReportRepository.save((Object)pdfReportFilters);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

    static {
        columnMappings.put("st", "Start Interval");
        columnMappings.put("et", "End Interval");
        columnMappings.put("agentName", "Agent Name");
        columnMappings.put("fullName", "Full Name");
        columnMappings.put("queue", "Queue");
        columnMappings.put("callOffered", "Total Call Offered");
        columnMappings.put("answered", "Total Call Answered");
        columnMappings.put("noAnswer", "Total Call Abandoned");
        columnMappings.put("inTalkTime", "Total In Talk Time");
        columnMappings.put("callDialed", "Total Call Dialed");
        columnMappings.put("connected", "Total Call Connected");
        columnMappings.put("notConnected", "Total Call Not Connected");
        columnMappings.put("outTalkTime", "Total Out Talk Time");
    }
}

