/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.agentIntervalReport.controller;

import com.coraltele.db.telemetry.main.entity.view.AgentHourlyIntervalView;
import com.coraltele.db.telemetry.main.entity.view.AgentTimeIntervalThirtyView;
import com.coraltele.db.telemetry.main.repository.AgentHourlyIntervalViewRepository;
import com.coraltele.db.telemetry.main.repository.AgentTimeIntervalThirtyViewRepository;
import com.coraltele.db.telemetry.main.specification.AgentHourlyIntervalViewSpecification;
import com.coraltele.db.telemetry.main.specification.AgentTimeIntervalThirtyViewSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DownloadPdfService;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.telemetry.main.agentIntervalReport.model.AgentTimeIntervalThirtyModel;
import com.coraltele.service.telemetry.main.agentIntervalReport.service.AgentIntervalServices;
import java.io.File;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/agentTimeInterval"})
public class AgentIntervalController {
    private static final Logger logger = LogManager.getLogger(AgentIntervalController.class);
    @Autowired
    AgentIntervalServices agentIntervalService;
    @Autowired
    AgentHourlyIntervalViewSpecification agentHourlyIntervalViewSpecification;
    @Autowired
    AgentTimeIntervalThirtyViewSpecification agentTimeIntervalThirtyViewSpecification;
    @Autowired
    AgentHourlyIntervalViewRepository agentHourlyIntervalViewRepo;
    @Autowired
    AgentHourlyIntervalViewSpecification agentHourlyIntervalSpecification;
    @Autowired
    AgentTimeIntervalThirtyViewRepository agentTimeIntervalThirtyViewRepository;
    @Autowired
    AgentHourlyIntervalViewRepository agentHourlyIntervalViewRepository;
    @Autowired
    DownloadPdfService pdfDownloadService;
    @Autowired
    private DynamicPdfThreadService dynamicReportThreadServiceTest;
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();

    @PostMapping(value={"/thirtyList"})
    public ResponseEntity<RequestResponse> getAllByFilter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.agentIntervalService.getAllByFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"thirty/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSV(@RequestBody SearchRequest request, Principal principal) {
        try {
            Specification filters = AgentTimeIntervalThirtyViewSpecification.generateFilters((SearchRequest)request);
            Sort sort = null;
            if ("asc".equalsIgnoreCase(request.getSortDirection())) {
                sort = Sort.by((String[])new String[]{request.getSortBy() == null || request.getSortBy().isEmpty() ? "queue" : request.getSortBy()}).ascending();
            } else if ("desc".equalsIgnoreCase(request.getSortDirection())) {
                sort = Sort.by((String[])new String[]{request.getSortBy() == null || request.getSortBy().isEmpty() ? "queue" : request.getSortBy()}).descending();
            }
            List views = sort != null ? this.agentTimeIntervalThirtyViewRepository.findAll(filters, sort) : this.agentTimeIntervalThirtyViewRepository.findAll(filters);
            List data = views.stream().map(arg_0 -> this.mapToModel(arg_0)).collect(Collectors.toList());
            StringWriter writer = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)writer, CSVFormat.DEFAULT);){
                List headers = request.getColumnNames().stream().map(c -> columnMappings.getOrDefault(c, c)).collect(Collectors.toList());
                csvPrinter.printRecord(headers);
                for (AgentTimeIntervalThirtyModel item : data) {
                    ArrayList<Object> row = new ArrayList<Object>();
                    for (String col : request.getColumnNames()) {
                        row.add(this.getColumnValue(item, col));
                    }
                    csvPrinter.printRecord(row);
                }
            }
            byte[] csvBytes = writer.toString().getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "agent_interval_30min.csv");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Object getColumnValue(AgentTimeIntervalThirtyModel item, String column) {
        switch (column) {
            case "st": {
                return this.checkNull((Object)item.getSt());
            }
            case "et": {
                return this.checkNull((Object)item.getEt());
            }
            case "agentName": {
                return this.checkNull((Object)item.getAgentName());
            }
            case "fullName": {
                return this.checkNull((Object)item.getFullName());
            }
            case "queue": {
                return this.checkNull((Object)item.getQueue());
            }
            case "callOffered": {
                return this.checkNull((Object)item.getCallOffered());
            }
            case "answered": {
                return this.checkNull((Object)item.getAnswered());
            }
            case "noAnswer": {
                return this.checkNull((Object)item.getNoAnswer());
            }
            case "inTalkTime": {
                return this.checkNull((Object)item.getInTalkTime());
            }
            case "callDialed": {
                return this.checkNull((Object)item.getCallDialed());
            }
            case "connected": {
                return this.checkNull((Object)item.getConnected());
            }
            case "notConnected": {
                return this.checkNull((Object)item.getNotConnected());
            }
            case "outTalkTime": {
                return this.checkNull((Object)item.getOutTalkTime());
            }
        }
        return "";
    }

    private String checkNull(Object value) {
        return value == null ? "" : value.toString();
    }

    private AgentTimeIntervalThirtyModel mapToModel(AgentTimeIntervalThirtyView v) {
        AgentTimeIntervalThirtyModel m = new AgentTimeIntervalThirtyModel();
        m.setSt(this.formateDateString(v.getSt().toString()));
        m.setEt(this.formateDateString(v.getEt().toString()));
        m.setAgentName(v.getAgentName());
        m.setFullName(v.getFullName());
        m.setQueue(v.getQueue());
        m.setCallOffered(v.getCallOffered());
        m.setAnswered(v.getAnswered());
        m.setNoAnswer(v.getNoAnswer());
        m.setInTalkTime(v.getInTalkTime());
        m.setCallDialed(v.getCallDialed());
        m.setConnected(v.getConnected());
        m.setNotConnected(v.getNotConnected());
        m.setOutTalkTime(v.getOutTalkTime());
        return m;
    }

    @PostMapping(value={"/generateAndDownloadPdf"})
    public CompletableFuture<ResponseEntity<?>> generateAndDownloadPdf(@RequestParam String reportType, @RequestBody SearchRequest searchRequestData, Principal principal) {
        String folderPath = "/tmp/";
        File folder = new File(folderPath);
        String fileNamePrefix = reportType + "_";
        File[] files = folder.listFiles((dir, name) -> name.startsWith(fileNamePrefix));
        if (files != null) {
            for (File file : files) {
                if (file.delete()) {
                    logger.info("Deleted existing report: {}" + file.getName());
                    continue;
                }
                logger.error("Failed to delete existing report: {}" + file.getName());
            }
        }
        String filePath = "/tmp/" + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        CompletableFuture generationFuture = this.dynamicReportThreadServiceTest.startGeneratingReportAsync(reportType, id, searchRequestData, filePath, principal);
        return generationFuture.thenApply(response -> {
            if (response.getStatus().equals((Object)Constants.Error.OK)) {
                ResponseEntity downloadResponse = this.pdfDownloadService.getPdfFile(filePath);
                if (downloadResponse.getStatusCode().is2xxSuccessful()) {
                    return ResponseEntity.ok().body(downloadResponse.getBody());
                }
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to download PDF. Reason: " + downloadResponse.getStatusCode()));
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(response);
        });
    }

    @PostMapping(value={"/sixtyList"})
    public ResponseEntity<RequestResponse> getAllSixtyByFilter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.agentIntervalService.getAllSixtyByFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/sixty/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredSixtyDataToCSV(@RequestBody SearchRequest request, Principal principal) {
        try {
            Specification filters = AgentHourlyIntervalViewSpecification.generateFilters((SearchRequest)request);
            Sort sort = null;
            if ("asc".equalsIgnoreCase(request.getSortDirection())) {
                sort = Sort.by((String[])new String[]{request.getSortBy() == null || request.getSortBy().isEmpty() ? "queue" : request.getSortBy()}).ascending();
            } else if ("desc".equalsIgnoreCase(request.getSortDirection())) {
                sort = Sort.by((String[])new String[]{request.getSortBy() == null || request.getSortBy().isEmpty() ? "queue" : request.getSortBy()}).descending();
            }
            List views = sort != null ? this.agentHourlyIntervalViewRepo.findAll(filters, sort) : this.agentHourlyIntervalViewRepo.findAll(filters);
            List data = views.stream().map(arg_0 -> this.mapToSixtyModel(arg_0)).collect(Collectors.toList());
            StringWriter writer = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)writer, CSVFormat.DEFAULT);){
                List headers = request.getColumnNames().stream().map(c -> columnMappings.getOrDefault(c, c)).collect(Collectors.toList());
                csvPrinter.printRecord(headers);
                for (AgentTimeIntervalThirtyModel item : data) {
                    ArrayList<Object> row = new ArrayList<Object>();
                    for (String col : request.getColumnNames()) {
                        row.add(this.getColumnValue(item, col));
                    }
                    csvPrinter.printRecord(row);
                }
            }
            byte[] csvBytes = writer.toString().getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "agent_interval_60min.csv");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private AgentTimeIntervalThirtyModel mapToSixtyModel(AgentHourlyIntervalView v) {
        AgentTimeIntervalThirtyModel m = new AgentTimeIntervalThirtyModel();
        m.setSt(this.formateDateString(v.getSt().toString()));
        m.setEt(this.formateDateString(v.getEt().toString()));
        m.setAgentName(v.getAgentName());
        m.setFullName(v.getFullName());
        m.setQueue(v.getQueue());
        m.setCallOffered(v.getCallOffered());
        m.setAnswered(v.getAnswered());
        m.setNoAnswer(v.getNoAnswer());
        m.setInTalkTime(v.getInTalkTime());
        m.setCallDialed(v.getCallDialed());
        m.setConnected(v.getConnected());
        m.setNotConnected(v.getNotConnected());
        m.setOutTalkTime(v.getOutTalkTime());
        return m;
    }

    private String formateDateString(String dateString) {
        if (dateString == null) {
            return "";
        }
        return dateString.replace("T", " ");
    }

    static {
        columnMappings.put("st", "Start Interval");
        columnMappings.put("et", "End Interval");
        columnMappings.put("agentName", "Agent Name");
        columnMappings.put("fullName", "Full Name");
        columnMappings.put("queue", "Queue");
        columnMappings.put("callOffered", "Total Call Offered");
        columnMappings.put("answered", "Total Call Answered");
        columnMappings.put("noAnswer", "Total Call Abandoned");
        columnMappings.put("inTalkTime", "Total In Talk Time");
        columnMappings.put("callDialed", "Total Call Dialed");
        columnMappings.put("connected", "Total Call Connected");
        columnMappings.put("notConnected", "Total Call Not Connected");
        columnMappings.put("outTalkTime", "Total Out Talk Time");
    }
}

