/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.operator.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.pbx.operator.model.OperatorModel;
import com.coraltele.service.pbx.operator.service.OperatorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/v2/operator"})
public class OperatorController {
    @Autowired
    private OperatorService operatorService;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> createOperator(@RequestBody OperatorModel operatorModel) {
        RequestResponse response = this.operatorService.createOperator(operatorModel);
        return response.getStatus().equals((Object)Constants.Error.OK) ? ResponseEntity.ok((Object)response) : new ResponseEntity((Object)response, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/allOperator"})
    public ResponseEntity<RequestResponse> getAllOperators() {
        RequestResponse response = this.operatorService.getAllOperators();
        return response.getStatus().equals((Object)Constants.Error.OK) ? ResponseEntity.ok((Object)response) : new ResponseEntity((Object)response, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/extensions/ocgroup"})
    public ResponseEntity<RequestResponse> getAllExtension() {
        RequestResponse response = this.operatorService.getAllExtension();
        return response.getStatus().equals((Object)Constants.Error.OK) ? ResponseEntity.ok((Object)response) : new ResponseEntity((Object)response, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/users/role/ocadmin"})
    public ResponseEntity<RequestResponse> getUserRoleWithOcAdmin() {
        RequestResponse response = this.operatorService.getUserRoleWithOcAdmin();
        return response.getStatus().equals((Object)Constants.Error.OK) ? ResponseEntity.ok((Object)response) : new ResponseEntity((Object)response, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/extensions/phone"})
    public ResponseEntity<RequestResponse> getExtensionWithPhoneExtension() {
        RequestResponse response = this.operatorService.getExtensionWithPhoneExtension();
        return response.getStatus().equals((Object)Constants.Error.OK) ? ResponseEntity.ok((Object)response) : new ResponseEntity((Object)response, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateOperator(@RequestBody OperatorModel operatorModel) {
        RequestResponse response = this.operatorService.updateOperator(operatorModel);
        return response.getStatus().equals((Object)Constants.Error.OK) ? ResponseEntity.ok((Object)response) : new ResponseEntity((Object)response, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteCampaignById(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.operatorService.deleteOperator(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getFilteredExtensions(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.operatorService.getFilteredOperatorMaster(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

