/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.cos.service;

import com.coraltele.db.telephony.pbx.entity.CLIServerCommandLog;
import com.coraltele.db.telephony.pbx.entity.InboundCos;
import com.coraltele.db.telephony.pbx.repository.InboundCosRepository;
import com.coraltele.db.telephony.pbx.specification.InboundCosSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.CliCommandData;
import com.coraltele.model.InputAction;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.cLIServerCommandLog.service.CLIServerCommandLogService;
import com.coraltele.service.pbx.cos.model.InboundCosModel;
import com.coraltele.service.pbx.cos.model.InboundCosMultipleUpdates;
import com.coraltele.service.pbx.cos.model.SingleCosModel;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class InboundCosService {
    private static final Logger logger = LogManager.getLogger(InboundCosService.class);
    @Autowired
    private InboundCosRepository inboundCosRepository;
    @Autowired
    private CLIServerCommandLogService cLIServerCommandLogService;

    public boolean checkInboundCosWithZerosCos() {
        Optional inboundCos = this.inboundCosRepository.findByCos("0");
        return inboundCos.isPresent();
    }

    public void createInboundCosWithZerosCos() {
        InboundCos inboundData = new InboundCos();
        inboundData.setCos("0");
        this.inboundCosRepository.save((Object)inboundData);
    }

    public RequestResponse createInboundCos(InboundCosModel data) {
        logger.debug("create new inboundCos : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional info = this.inboundCosRepository.findByCos(data.getCos());
            if (info.isPresent()) {
                returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
                returnValue.setMessage("Cos already exists");
                returnValue.setMessageDetail("Please enter different cos");
                return returnValue;
            }
            InboundCos inboundCos = new InboundCos();
            if (data.getAcr() != null) {
                inboundCos.setAcr(data.getAcr());
            } else {
                inboundCos.setAcr(Boolean.valueOf(false));
            }
            if (data.getAllowgd() != null) {
                inboundCos.setAllowgd(data.getAllowgd());
            } else {
                inboundCos.setAllowgd(Boolean.valueOf(true));
            }
            if (data.getAllowTrunkInwardCall() != null) {
                inboundCos.setAllowTrunkInwardCall(data.getAllowTrunkInwardCall());
            } else {
                inboundCos.setAllowTrunkInwardCall(Boolean.valueOf(true));
            }
            if (data.getBusyIndication() != null) {
                inboundCos.setBusyIndication(data.getBusyIndication());
            } else {
                inboundCos.setBusyIndication(Boolean.valueOf(true));
            }
            if (data.getCFNA() != null) {
                inboundCos.setCFNA(data.getCFNA());
            } else {
                inboundCos.setCFNA(Boolean.valueOf(false));
            }
            if (data.getCaf() != null) {
                inboundCos.setCaf(data.getCaf());
            } else {
                inboundCos.setCaf(Boolean.valueOf(false));
            }
            if (data.getCallbackOnBusy() != null) {
                inboundCos.setCallbackOnBusy(data.getCallbackOnBusy());
            } else {
                inboundCos.setCallbackOnBusy(Boolean.valueOf(true));
            }
            if (data.getCallbackOnNoAnswer() != null) {
                inboundCos.setCallbackOnNoAnswer(data.getCallbackOnNoAnswer());
            } else {
                inboundCos.setCallbackOnNoAnswer(Boolean.valueOf(true));
            }
            if (data.getCallbackOnNotRegistered() != null) {
                inboundCos.setCallbackOnNotRegistered(data.getCallbackOnNotRegistered());
            } else {
                inboundCos.setCallbackOnNotRegistered(Boolean.valueOf(false));
            }
            if (data.getCampOn() != null) {
                inboundCos.setCampOn(data.getCampOn());
            } else {
                inboundCos.setCampOn(Boolean.valueOf(true));
            }
            if (data.getCb() != null) {
                inboundCos.setCb(data.getCb());
            } else {
                inboundCos.setCb(Boolean.valueOf(false));
            }
            if (data.getCfa() != null) {
                inboundCos.setCfa(data.getCfa());
            } else {
                inboundCos.setCfa(Boolean.valueOf(false));
            }
            if (data.getCfb() != null) {
                inboundCos.setCfb(data.getCfb());
            } else {
                inboundCos.setCfb(Boolean.valueOf(false));
            }
            inboundCos.setCos(data.getCos());
            if (data.getDnd() != null) {
                inboundCos.setDnd(data.getDnd());
            } else {
                inboundCos.setDnd(Boolean.valueOf(false));
            }
            if (data.getFm() != null) {
                inboundCos.setFm(data.getFm());
            } else {
                inboundCos.setFm(Boolean.valueOf(false));
            }
            if (data.getOverrideIBedTmf() != null) {
                inboundCos.setOverrideIBedTmf(data.getOverrideIBedTmf());
            } else {
                inboundCos.setOverrideIBedTmf(Boolean.valueOf(false));
            }
            if (data.getPr() != null) {
                inboundCos.setPr(data.getPr());
            } else {
                inboundCos.setPr(Boolean.valueOf(false));
            }
            if (data.getRestrictFeatureAccess() != null) {
                inboundCos.setRestrictFeatureAccess(data.getRestrictFeatureAccess());
            } else {
                inboundCos.setRestrictFeatureAccess(Boolean.valueOf(false));
            }
            if (data.getUNMA() != null) {
                inboundCos.setUNMA(data.getUNMA());
            } else {
                inboundCos.setUNMA(Boolean.valueOf(false));
            }
            inboundCos.setSNMPTrapEnabledOn(data.getSNMPTrapEnabledOn());
            if (data.getVm() != null) {
                inboundCos.setVm(data.getVm());
            } else {
                inboundCos.setVm(Boolean.valueOf(true));
            }
            if (data.getAllowBossOnly() != null) {
                inboundCos.setAllowBossOnly(data.getAllowBossOnly());
            } else {
                inboundCos.setAllowBossOnly(Boolean.valueOf(false));
            }
            if (data.getAutoRepeatDial() != null) {
                inboundCos.setAutoRepeatDial(data.getAutoRepeatDial());
            } else {
                inboundCos.setAutoRepeatDial(Boolean.valueOf(false));
            }
            this.inboundCosRepository.save((Object)inboundCos);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("InboundCos Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to create inboundCos");
            returnValue.setMessageDetail("Contact with administrator");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getById(int id) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional inboundCos = this.inboundCosRepository.findById(id);
            if (inboundCos.isPresent()) {
                InboundCosModel data = new InboundCosModel();
                data.setId(((InboundCos)inboundCos.get()).getId().intValue());
                data.setAcr(((InboundCos)inboundCos.get()).getAcr());
                data.setAllowgd(((InboundCos)inboundCos.get()).getAllowgd());
                data.setAllowTrunkInwardCall(((InboundCos)inboundCos.get()).getAllowTrunkInwardCall());
                data.setBusyIndication(((InboundCos)inboundCos.get()).getBusyIndication());
                data.setCFNA(((InboundCos)inboundCos.get()).getCFNA());
                data.setCaf(((InboundCos)inboundCos.get()).getCaf());
                data.setCallbackOnBusy(((InboundCos)inboundCos.get()).getCallbackOnBusy());
                data.setCallbackOnNoAnswer(((InboundCos)inboundCos.get()).getCallbackOnNoAnswer());
                data.setCallbackOnNotRegistered(((InboundCos)inboundCos.get()).getCallbackOnNotRegistered());
                data.setCampOn(((InboundCos)inboundCos.get()).getCampOn());
                data.setCb(((InboundCos)inboundCos.get()).getCb());
                data.setCfa(((InboundCos)inboundCos.get()).getCfa());
                data.setCfb(((InboundCos)inboundCos.get()).getCfb());
                data.setCos(((InboundCos)inboundCos.get()).getCos());
                data.setDnd(((InboundCos)inboundCos.get()).getDnd());
                data.setFm(((InboundCos)inboundCos.get()).getFm());
                data.setOverrideIBedTmf(((InboundCos)inboundCos.get()).getOverrideIBedTmf());
                data.setPr(((InboundCos)inboundCos.get()).getPr());
                data.setRestrictFeatureAccess(((InboundCos)inboundCos.get()).getRestrictFeatureAccess());
                data.setSNMPTrapEnabledOn(((InboundCos)inboundCos.get()).getSNMPTrapEnabledOn());
                data.setUNMA(((InboundCos)inboundCos.get()).getUNMA());
                data.setVm(((InboundCos)inboundCos.get()).getVm());
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("InboundCos Found");
                returnValue.setData((Object)data);
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Unable to return value");
                returnValue.setMessageDetail("Records not found");
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to return value");
            returnValue.setMessageDetail("contact with administrator");
        }
        return returnValue;
    }

    public RequestResponse updateInboundCosById(HttpServletRequest request, InboundCosModel data, Principal principal) throws IOException {
        logger.debug("Update InboundCos {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional inboundCos = this.inboundCosRepository.findById(data.getId());
        if (!inboundCos.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("InboundCos not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getAcr() != null) {
            ((InboundCos)inboundCos.get()).setAcr(data.getAcr());
        }
        if (data.getAllowgd() != null) {
            ((InboundCos)inboundCos.get()).setAllowgd(data.getAllowgd());
        }
        if (data.getAllowTrunkInwardCall() != null) {
            ((InboundCos)inboundCos.get()).setAllowTrunkInwardCall(data.getAllowTrunkInwardCall());
        }
        if (data.getBusyIndication() != null) {
            ((InboundCos)inboundCos.get()).setBusyIndication(data.getBusyIndication());
        }
        if (data.getCFNA() != null) {
            ((InboundCos)inboundCos.get()).setCFNA(data.getCFNA());
        }
        if (data.getCaf() != null) {
            ((InboundCos)inboundCos.get()).setCaf(data.getCaf());
        }
        if (data.getCallbackOnBusy() != null) {
            ((InboundCos)inboundCos.get()).setCallbackOnBusy(data.getCallbackOnBusy());
        }
        if (data.getCallbackOnNoAnswer() != null) {
            ((InboundCos)inboundCos.get()).setCallbackOnNoAnswer(data.getCallbackOnNoAnswer());
        }
        if (data.getCallbackOnNotRegistered() != null) {
            ((InboundCos)inboundCos.get()).setCallbackOnNotRegistered(data.getCallbackOnNotRegistered());
        }
        if (data.getCampOn() != null) {
            ((InboundCos)inboundCos.get()).setCampOn(data.getCampOn());
        }
        if (data.getCb() != null) {
            ((InboundCos)inboundCos.get()).setCb(data.getCb());
        }
        if (data.getCfa() != null) {
            ((InboundCos)inboundCos.get()).setCfa(data.getCfa());
        }
        if (data.getCfb() != null) {
            ((InboundCos)inboundCos.get()).setCfb(data.getCfb());
        }
        if (data.getCos() != null && !data.getCos().equals("")) {
            ((InboundCos)inboundCos.get()).setCos(data.getCos());
        }
        if (data.getDnd() != null) {
            ((InboundCos)inboundCos.get()).setDnd(data.getDnd());
        }
        if (data.getFm() != null) {
            ((InboundCos)inboundCos.get()).setFm(data.getFm());
        }
        if (data.getOverrideIBedTmf() != null) {
            ((InboundCos)inboundCos.get()).setOverrideIBedTmf(data.getOverrideIBedTmf());
        }
        if (data.getPr() != null) {
            ((InboundCos)inboundCos.get()).setPr(data.getPr());
        }
        if (data.getRestrictFeatureAccess() != null) {
            ((InboundCos)inboundCos.get()).setRestrictFeatureAccess(data.getRestrictFeatureAccess());
        }
        if (data.getSNMPTrapEnabledOn() != null && !data.getSNMPTrapEnabledOn().equals("")) {
            ((InboundCos)inboundCos.get()).setSNMPTrapEnabledOn(data.getSNMPTrapEnabledOn());
        }
        if (data.getUNMA() != null) {
            ((InboundCos)inboundCos.get()).setUNMA(data.getUNMA());
        }
        if (data.getVm() != null) {
            ((InboundCos)inboundCos.get()).setVm(data.getVm());
        }
        if (data.getAutoRepeatDial() != null) {
            ((InboundCos)inboundCos.get()).setAutoRepeatDial(data.getAutoRepeatDial());
        }
        if (data.getAllowBossOnly() != null) {
            ((InboundCos)inboundCos.get()).setAllowBossOnly(data.getAllowBossOnly());
        }
        this.inboundCosRepository.save(inboundCos.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("InboundCos Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateAll(HttpServletRequest request, InboundCosMultipleUpdates data, Authentication authentication) throws IOException {
        RequestResponse returnValue = new RequestResponse();
        for (Integer id : data.getIds()) {
            Optional inboundCos = this.inboundCosRepository.findById((Object)id);
            if (!inboundCos.isPresent()) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("InboundCos not found");
                logger.info(returnValue.getMessage());
                return returnValue;
            }
            this.saveData(request, (InboundCos)inboundCos.get(), authentication);
            if (data.getAcr() != null) {
                ((InboundCos)inboundCos.get()).setAcr(data.getAcr());
            }
            if (data.getAllowgd() != null) {
                ((InboundCos)inboundCos.get()).setAllowgd(data.getAllowgd());
            }
            if (data.getAllowTrunkInwardCall() != null) {
                ((InboundCos)inboundCos.get()).setAllowTrunkInwardCall(data.getAllowTrunkInwardCall());
            }
            if (data.getBusyIndication() != null) {
                ((InboundCos)inboundCos.get()).setBusyIndication(data.getBusyIndication());
            }
            if (data.getCFNA() != null) {
                ((InboundCos)inboundCos.get()).setCFNA(data.getCFNA());
            }
            if (data.getCallbackOnBusy() != null) {
                ((InboundCos)inboundCos.get()).setCallbackOnBusy(data.getCallbackOnBusy());
            }
            if (data.getCaf() != null) {
                ((InboundCos)inboundCos.get()).setCaf(data.getCaf());
            }
            if (data.getCallbackOnNoAnswer() != null) {
                ((InboundCos)inboundCos.get()).setCallbackOnNoAnswer(data.getCallbackOnNoAnswer());
            }
            if (data.getCallbackOnNotRegistered() != null) {
                ((InboundCos)inboundCos.get()).setCallbackOnNotRegistered(data.getCallbackOnNotRegistered());
            }
            if (data.getCampOn() != null) {
                ((InboundCos)inboundCos.get()).setCampOn(data.getCampOn());
            }
            if (data.getCb() != null) {
                ((InboundCos)inboundCos.get()).setCb(data.getCb());
            }
            if (data.getCfa() != null) {
                ((InboundCos)inboundCos.get()).setCfa(data.getCfa());
            }
            if (data.getCfb() != null) {
                ((InboundCos)inboundCos.get()).setCfb(data.getCfb());
            }
            if (data.getCos() != null) {
                ((InboundCos)inboundCos.get()).setCos(data.getCos());
            }
            if (data.getDnd() != null) {
                ((InboundCos)inboundCos.get()).setDnd(data.getDnd());
            }
            if (data.getFm() != null) {
                ((InboundCos)inboundCos.get()).setFm(data.getFm());
            }
            if (data.getOverrideIBedTmf() != null) {
                ((InboundCos)inboundCos.get()).setOverrideIBedTmf(data.getOverrideIBedTmf());
            }
            if (data.getPr() != null) {
                ((InboundCos)inboundCos.get()).setPr(data.getPr());
            }
            if (data.getRestrictFeatureAccess() != null) {
                ((InboundCos)inboundCos.get()).setRestrictFeatureAccess(data.getRestrictFeatureAccess());
            }
            if (data.getSNMPTrapEnabledOn() != null) {
                ((InboundCos)inboundCos.get()).setSNMPTrapEnabledOn(data.getSNMPTrapEnabledOn());
            }
            if (data.getUNMA() != null) {
                ((InboundCos)inboundCos.get()).setUNMA(data.getUNMA());
            }
            if (data.getVm() != null) {
                ((InboundCos)inboundCos.get()).setVm(data.getVm());
            }
            this.inboundCosRepository.save(inboundCos.get());
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("InboundCos Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse delete(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Long ids : data.getId()) {
            Optional inboundCos = this.inboundCosRepository.findById(ids.intValue());
            if (inboundCos.isPresent()) {
                addValue.add(inboundCos.get());
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        this.inboundCosRepository.deleteAll(addValue);
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records deleted successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public void saveData(HttpServletRequest request, InboundCos data, Authentication authentication) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper().findAndRegisterModules();
        Map newMap = (Map)new ObjectMapper().readValue((InputStream)request.getInputStream(), Map.class);
        Set entrySet = newMap.entrySet();
        Iterator iterator = entrySet.iterator();
        ArrayList<InputAction> addValue = new ArrayList<InputAction>();
        CliCommandData cliCommandData = new CliCommandData();
        try {
            if (data.getId() != null && this.inboundCosRepository.findById((Object)data.getId()).isPresent()) {
                Optional oldData = this.inboundCosRepository.findById((Object)data.getId());
                Map oldMap = (Map)objectMapper.convertValue(oldData.get(), Map.class);
                while (iterator.hasNext()) {
                    Map.Entry mapEntry = iterator.next();
                    InputAction inputValue = new InputAction();
                    inputValue.setFieldName(mapEntry.getKey());
                    inputValue.setNewValue(mapEntry.getValue());
                    for (Map.Entry compare : oldMap.entrySet()) {
                        if (!mapEntry.getKey().equals(compare.getKey())) continue;
                        inputValue.setOldValue(compare.getValue());
                    }
                    addValue.add(inputValue);
                }
                cliCommandData.setData(addValue);
                cliCommandData.setEntity("inboundcos");
                String dataReceived = objectMapper.writeValueAsString(addValue);
                CLIServerCommandLog dataLogs = new CLIServerCommandLog();
                dataLogs.setCLICommand(dataReceived);
                dataLogs.setRecordSource("dl");
                dataLogs.setServerCode("");
                dataLogs.setRecordCreatedBy(authentication.getName());
                dataLogs.setRecordCreatedOn(LocalDateTime.now());
                dataLogs.setOutputFileName("Name");
                dataLogs.setOutputFilePath("");
                this.cLIServerCommandLogService.save(dataLogs);
            }
        }
        catch (JsonProcessingException e) {
            logger.info((Object)e);
        }
    }

    public RequestResponse getInboundCosByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = InboundCosSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.inboundCosRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.inboundCosRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllCos() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<SingleCosModel> addValue = new ArrayList<SingleCosModel>();
        List inboundCos = this.inboundCosRepository.findAll();
        if (inboundCos.isEmpty()) {
            returnValue.setMessage("List is empty");
            logger.error("unable to fetch data: ", (Object)returnValue.getMessage());
        } else {
            for (InboundCos row : inboundCos) {
                SingleCosModel data = new SingleCosModel();
                data.setCos(row.getCos());
                data.setId(row.getId());
                addValue.add(data);
            }
        }
        returnValue.setData(addValue);
        returnValue.setMessage("List of Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

