/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.cos.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.pbx.cos.model.OutboundCosModel;
import com.coraltele.service.pbx.cos.model.OutboundCosMultipleUpdates;
import com.coraltele.service.pbx.cos.service.OutboundCosService;
import java.io.IOException;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/outboundCos"})
@RestController
public class OutboundCosController {
    @Autowired
    private OutboundCosService outboundCosService;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> addOutboundCos(@RequestBody OutboundCosModel data) {
        RequestResponse returnValue = this.outboundCosService.createOutboundCos(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/{id}"})
    public ResponseEntity<RequestResponse> getOutboundCosById(@PathVariable(value="id") int id) {
        RequestResponse returnValue = this.outboundCosService.getById(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllOutboundCos(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.outboundCosService.getOutboundCosByFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateOutboundCos(HttpServletRequest request, @RequestBody OutboundCosModel data, Authentication authentication) throws IOException {
        RequestResponse returnValue = this.outboundCosService.updateOutboundCosById(request, data, (Principal)authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/multiUpdate"})
    public ResponseEntity<RequestResponse> partialUpdateOutboundCos(HttpServletRequest request, @RequestBody OutboundCosMultipleUpdates data, Authentication authentication) throws IOException {
        RequestResponse returnValue = this.outboundCosService.updateAll(request, data, authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteOutboundCos(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.outboundCosService.delete(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list/cos"})
    public ResponseEntity<RequestResponse> listOfCos() {
        RequestResponse returnValue = this.outboundCosService.getAllCos();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

