/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.configJson.service;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class ConfigJsonService {
    private static final Logger logger = LogManager.getLogger(ConfigJsonService.class);
    private static final String DIRECTORY_PATH = "/etc/coraltele/forms/config.json";
    private static final String GEOMETRY_DATA_PATH = "/etc/coraltele/forms/geometryData.json";

    public RequestResponse saveConfig(Object config) throws IOException {
        RequestResponse returnValue = new RequestResponse();
        ObjectMapper objectMapper = new ObjectMapper();
        File file = new File(DIRECTORY_PATH);
        try {
            file.getParentFile().mkdirs();
            if (file.exists()) {
                boolean deleted = file.delete();
                if (!deleted) {
                    throw new IOException("Failed to delete existing file: /etc/coraltele/forms/config.json");
                }
                logger.info("Existing JSON file deleted successfully at: /etc/coraltele/forms/config.json");
            }
            objectMapper.writeValue(file, config);
            logger.info("JSON file created successfully at: /etc/coraltele/forms/config.json");
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Config JSON created successfully");
        }
        catch (IOException e) {
            logger.error("Error occurred while writing JSON file: " + e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Failed to create config JSON");
            throw e;
        }
        return returnValue;
    }

    public RequestResponse getConfigJsonFile() {
        RequestResponse returnValue = new RequestResponse();
        ObjectMapper objectMapper = new ObjectMapper();
        File file = new File(DIRECTORY_PATH);
        try {
            if (!file.exists()) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Config file does not exist: /etc/coraltele/forms/config.json");
                return returnValue;
            }
            Object jsonData = objectMapper.readValue(file, Object.class);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Retrieved");
            returnValue.setMessageDetail("Data Retrieved Successfully");
            returnValue.setData(jsonData);
        }
        catch (IOException e) {
            logger.error("Error occurred while reading JSON file: " + e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Failed to retrieve config JSON");
        }
        return returnValue;
    }

    public RequestResponse saveGeometryData(Object config) throws IOException {
        RequestResponse returnValue = new RequestResponse();
        ObjectMapper objectMapper = new ObjectMapper();
        File file = new File(GEOMETRY_DATA_PATH);
        try {
            file.getParentFile().mkdirs();
            if (file.exists()) {
                boolean deleted = file.delete();
                if (!deleted) {
                    throw new IOException("Failed to delete existing file: /etc/coraltele/forms/geometryData.json");
                }
                logger.info("Existing JSON file deleted successfully at: /etc/coraltele/forms/geometryData.json");
            }
            objectMapper.writeValue(file, config);
            logger.info("JSON file created successfully at: /etc/coraltele/forms/geometryData.json");
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Config JSON created successfully");
        }
        catch (IOException e) {
            logger.error("Error occurred while writing JSON file: " + e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Failed to create config JSON");
            throw e;
        }
        return returnValue;
    }

    public RequestResponse getGeometryData() {
        RequestResponse returnValue = new RequestResponse();
        ObjectMapper objectMapper = new ObjectMapper();
        File file = new File(GEOMETRY_DATA_PATH);
        try {
            if (!file.exists()) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Config file does not exist: /etc/coraltele/forms/geometryData.json");
                return returnValue;
            }
            Object jsonData = objectMapper.readValue(file, Object.class);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Retrieved");
            returnValue.setMessageDetail("Data Retrieved Successfully");
            returnValue.setData(jsonData);
        }
        catch (IOException e) {
            logger.error("Error occurred while reading JSON file: " + e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Failed to retrieve config JSON");
        }
        return returnValue;
    }
}

