/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.conferenceMailText.service;

import com.coraltele.db.telephony.pbx.entity.ConferenceMailText;
import com.coraltele.db.telephony.pbx.repository.ConferenceMailTextRepository;
import com.coraltele.db.telephony.pbx.specification.ConferenceMailTextSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.conferenceMailText.model.ConferenceMailTextModel;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class ConferenceMailTextService {
    private static final Logger logger = LogManager.getLogger(ConferenceMailTextService.class);
    @Autowired
    ConferenceMailTextRepository conferenceMailTextRepository;

    public RequestResponse createData(ConferenceMailTextModel data, Authentication authentication) {
        logger.debug("Create New ConferenceMailText : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            ConferenceMailText conferenceMailText = new ConferenceMailText();
            conferenceMailText.setCreatedBy(authentication.getName());
            conferenceMailText.setCreatedOn(LocalDateTime.now());
            conferenceMailText.setEmailBody(data.getEmailBody());
            conferenceMailText.setEmailGreeting(data.getEmailGreeting());
            conferenceMailText.setEmailSignature(data.getEmailSignature());
            conferenceMailText.setSmsBody(data.getSmsBody());
            conferenceMailText.setSubject(data.getSubject());
            conferenceMailText.setType(data.getType());
            this.conferenceMailTextRepository.save((Object)conferenceMailText);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("ConferenceMailText Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable To Create ConferenceMailText");
            returnValue.setMessageDetail("Contact With Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateById(ConferenceMailTextModel data) {
        logger.debug("Update ConferenceMailText {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional conferenceMailText = this.conferenceMailTextRepository.findById((Object)data.getId());
        if (!conferenceMailText.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found");
            returnValue.setMessageDetail("ConferenceMailText Not Found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getCreatedBy() != null) {
            ((ConferenceMailText)conferenceMailText.get()).setCreatedBy(data.getCreatedBy());
        }
        if (data.getEmailBody() != null) {
            ((ConferenceMailText)conferenceMailText.get()).setEmailBody(data.getEmailBody());
        }
        if (data.getEmailGreeting() != null) {
            ((ConferenceMailText)conferenceMailText.get()).setEmailGreeting(data.getEmailGreeting());
        }
        if (data.getEmailSignature() != null) {
            ((ConferenceMailText)conferenceMailText.get()).setEmailSignature(data.getEmailSignature());
        }
        if (data.getSmsBody() != null) {
            ((ConferenceMailText)conferenceMailText.get()).setSmsBody(data.getSmsBody());
        }
        if (data.getSubject() != null) {
            ((ConferenceMailText)conferenceMailText.get()).setSubject(data.getSubject());
        }
        if (data.getType() != null) {
            ((ConferenceMailText)conferenceMailText.get()).setType(data.getType());
        }
        this.conferenceMailTextRepository.save(conferenceMailText.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("ConferenceMailText Updated Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional conferenceMailText = this.conferenceMailTextRepository.findById((Object)ids);
            if (conferenceMailText.isPresent()) {
                addValue.add(conferenceMailText.get());
                this.conferenceMailTextRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records Not Found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = ConferenceMailTextSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.conferenceMailTextRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.conferenceMailTextRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAll() {
        List list = (List)this.conferenceMailTextRepository.findAll();
        ArrayList<ConferenceMailTextModel> addValue = new ArrayList<ConferenceMailTextModel>();
        RequestResponse returnValue = new RequestResponse();
        for (ConferenceMailText conferenceMailText : list) {
            ConferenceMailTextModel data = new ConferenceMailTextModel();
            data.setCreatedBy(conferenceMailText.getCreatedBy());
            data.setCreatedOn(conferenceMailText.getCreatedOn());
            data.setEmailBody(conferenceMailText.getEmailBody());
            data.setEmailGreeting(conferenceMailText.getEmailGreeting());
            data.setEmailSignature(conferenceMailText.getEmailSignature());
            data.setId(conferenceMailText.getId());
            data.setSmsBody(conferenceMailText.getSmsBody());
            data.setSubject(conferenceMailText.getSubject());
            data.setType(conferenceMailText.getType());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

