/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.company.service;

import com.coraltele.db.telephony.billing.entity.Company;
import com.coraltele.db.telephony.billing.repository.CompanyRepository;
import com.coraltele.db.telephony.billing.specification.CompanySpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.company.model.CompanyModel;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class CompanyService {
    private static final Logger logger = LogManager.getLogger(CompanyService.class);
    @Autowired
    CompanyRepository companyRepository;

    public RequestResponse createData(CompanyModel data, Principal principal) {
        logger.debug("create new company : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Company company = new Company();
            company.setAddress(data.getAddress());
            company.setCode(data.getCode());
            company.setCreatedBy(principal.getName());
            company.setCreatedOn(LocalDateTime.now());
            company.setDescription(data.getDescription());
            company.setEmail(data.getEmail());
            this.companyRepository.save((Object)company);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("Company Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to Create Company");
            returnValue.setMessageDetail("Contact with Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse deleteById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional company = this.companyRepository.findById(Integer.valueOf(ids));
            if (company.isPresent()) {
                addValue.add(company.get());
                this.companyRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateById(CompanyModel data) {
        logger.debug("Update Company {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional company = this.companyRepository.findById(data.getId());
        if (!company.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("Company not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getAddress() != null) {
            ((Company)company.get()).setAddress(data.getAddress());
        }
        if (data.getCode() != null) {
            ((Company)company.get()).setCode(data.getCode());
        }
        if (data.getDescription() != null) {
            ((Company)company.get()).setDescription(data.getDescription());
        }
        if (data.getEmail() != null) {
            ((Company)company.get()).setEmail(data.getEmail());
        }
        this.companyRepository.save(company.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("Company Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = CompanySpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "channelLimit" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "channelLimit" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.companyRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.companyRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAll() {
        List list = (List)this.companyRepository.findAll();
        ArrayList<CompanyModel> addValue = new ArrayList<CompanyModel>();
        RequestResponse returnValue = new RequestResponse();
        for (Company data : list) {
            CompanyModel companyModel = new CompanyModel();
            companyModel.setAddress(data.getAddress());
            companyModel.setCode(data.getCode());
            companyModel.setCreatedBy(data.getCreatedBy());
            companyModel.setCreatedOn(data.getCreatedOn());
            companyModel.setDescription(data.getDescription());
            companyModel.setEmail(data.getEmail());
            companyModel.setId(data.getId());
            addValue.add(companyModel);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

