/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.coralApps.callcenter.IVRLanguage.controller;

import com.coraltele.db.coralapps.callcenter.entity.IVRLanguage;
import com.coraltele.db.coralapps.callcenter.repository.IVRLanguageRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.FileModel;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.coralApps.callcenter.IVRLanguage.model.IVRLanguageModel;
import com.coraltele.service.coralApps.callcenter.IVRLanguage.service.IVRLanguageService;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"/api/v2/ivr"})
@RestController
public class IVRLanguageController {
    @Autowired
    IVRLanguageService ivrLanguageService;
    @Autowired
    IVRLanguageRepository ivrLanguageRepository;

    @PostMapping(value={"/languages"})
    public ResponseEntity<RequestResponse> listOfLanguages() {
        RequestResponse returnValue = this.ivrLanguageService.getIvrLanguages();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> getAllLanguage(@RequestBody IVRLanguageModel data) {
        RequestResponse returnValue = this.ivrLanguageService.createData(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateById(@RequestBody IVRLanguageModel data) {
        RequestResponse returnValue = this.ivrLanguageService.updateById(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllLanguage(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.ivrLanguageService.getAllLanguage(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteById(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.ivrLanguageService.deleteIVRLanguageById(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/upload"})
    public ResponseEntity<RequestResponse> upload(@RequestParam(value="file") MultipartFile file, @RequestParam(value="language", required=true) String language) {
        RequestResponse returnValue = this.ivrLanguageService.uploadWavMP3File(file, language);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/deleteFile"})
    public ResponseEntity<RequestResponse> deleteFile(@RequestBody FileModel data) {
        RequestResponse returnValue = this.ivrLanguageService.deleteFile(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/allFiles"})
    public ResponseEntity<Map<String, Map<String, String>>> getFileInfo() {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        List languages = this.ivrLanguageRepository.findAll();
        for (IVRLanguage row : languages) {
            String pathToDir = "/usr/local/freeswitch/sounds/" + row.getLanguageName();
            Path dirPath = Paths.get(pathToDir, new String[0]);
            if (!Files.exists(dirPath, new LinkOption[0]) || !Files.isDirectory(dirPath, new LinkOption[0])) {
                result.put(row.getLanguageName(), Collections.singletonMap("error", "Directory not found"));
                continue;
            }
            try {
                Optional<Path> wavFile = Files.list(dirPath).filter(path -> path.toString().endsWith(".wav")).findFirst();
                if (wavFile.isPresent()) {
                    HashMap<String, String> fileInfo = new HashMap<String, String>();
                    fileInfo.put("fileName", wavFile.get().getFileName().toString());
                    result.put(row.getLanguageName(), fileInfo);
                    continue;
                }
                result.put(row.getLanguageName(), Collections.singletonMap("error", "No .wav file found"));
            }
            catch (IOException e) {
                result.put(row.getLanguageName(), Collections.singletonMap("error", "Failed to retrieve files"));
            }
        }
        return ResponseEntity.ok(result);
    }

    @GetMapping(value={"/download/audio"})
    public ResponseEntity<Resource> downloadFile(@RequestBody FileModel data) {
        String pathToFile = "/usr/local/freeswitch/sounds/" + data.getLanguage() + "/" + data.getFileName();
        Path filePath = Paths.get(pathToFile, new String[0]);
        if (!Files.exists(filePath, new LinkOption[0]) || !Files.isReadable(filePath)) {
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body(null);
        }
        try {
            UrlResource resource = new UrlResource(filePath.toUri());
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.APPLICATION_OCTET_STREAM).header("Content-Disposition", new String[]{"attachment; filename=\"" + data.getFileName() + "\""})).body((Object)resource);
        }
        catch (MalformedURLException e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PostMapping(value={"/save/mediaCenterJson"})
    public ResponseEntity<RequestResponse> createFile(@RequestBody Object config) throws Exception {
        RequestResponse returnValue = this.ivrLanguageService.saveMediaCenterJson(config);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/get/mediaCenterJson"})
    public ResponseEntity<RequestResponse> getConfigJsonFile() throws IOException {
        RequestResponse returnValue = this.ivrLanguageService.getMediaCenterJson();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

