/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.helper;

import com.coraltele.db.users.main.entity.ChangePassword;
import com.coraltele.db.users.main.entity.PasswordConfig;
import com.coraltele.db.users.main.repository.ChangePasswordRepository;
import com.coraltele.db.users.main.repository.PasswordConfigRepository;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ws.commons.util.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class PasswordConversion {
    private static final Logger logger = LogManager.getLogger(PasswordConversion.class);
    @Autowired
    ChangePasswordRepository changePasswordRepository;
    @Autowired
    private PasswordEncoder bcryptEncoder;
    @Autowired
    PasswordConfigRepository passwordConfigRepository;

    public String encryptContains(String keyvalue) {
        String rtrVal = "";
        if (!keyvalue.isEmpty()) {
            String privatekey;
            MessageDigest sha = null;
            String passwordKey = privatekey = "9221375a0cd0-5adb3f6d--f6ea-4d1e-81ed-a719175d-1e40-dd24b91a7c87-c5600ed3";
            try {
                byte[] key = passwordKey.getBytes("UTF-8");
                sha = MessageDigest.getInstance("SHA-1");
                key = sha.digest(key);
                key = Arrays.copyOf(key, 16);
                SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
                Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
                cipher.init(1, secretKey);
                byte[] rtv = cipher.doFinal(keyvalue.getBytes("UTF-8"));
                rtrVal = Base64.encode((byte[])rtv);
            }
            catch (NoSuchAlgorithmException e) {
                logger.error("Error at encryptContains(); " + e.getMessage());
            }
            catch (UnsupportedEncodingException e) {
                logger.error("Error at encryptContains(); " + e.getMessage());
            }
            catch (Exception e) {
                logger.error("Error at encryptContains(); " + e.getMessage());
            }
        }
        return rtrVal;
    }

    public boolean changePasswordValid(Integer userId, String password) {
        List passwordConfigs = this.passwordConfigRepository.findAll();
        List lastPasswords = this.changePasswordRepository.findAllByUserIdOrderByIdDesc(Long.valueOf(userId.intValue()));
        if (lastPasswords.size() < ((PasswordConfig)passwordConfigs.get(0)).getAcceptLastPassword()) {
            return true;
        }
        for (ChangePassword lastPassword : lastPasswords.subList(0, ((PasswordConfig)passwordConfigs.get(0)).getAcceptLastPassword())) {
            if (!this.bcryptEncoder.matches((CharSequence)password, lastPassword.getPassword())) continue;
            return false;
        }
        return true;
    }

    public String decryptContains(String encryptedValue) {
        String decryptedValue = "";
        if (!encryptedValue.isEmpty()) {
            String privatekey;
            MessageDigest sha = null;
            String passwordKey = privatekey = "9221375a0cd0-5adb3f6d--f6ea-4d1e-81ed-a719175d-1e40-dd24b91a7c87-c5600ed3";
            try {
                byte[] key = passwordKey.getBytes("UTF-8");
                sha = MessageDigest.getInstance("SHA-1");
                key = sha.digest(key);
                key = Arrays.copyOf(key, 16);
                SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
                Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
                cipher.init(2, secretKey);
                char[] encodedChars = encryptedValue.toCharArray();
                byte[] decodedValue = Base64.decode((char[])encodedChars);
                byte[] decryptedBytes = cipher.doFinal(decodedValue);
                decryptedValue = new String(decryptedBytes, "UTF-8");
            }
            catch (Exception e) {
                logger.error("Error at decryptContains(); " + e.getMessage());
            }
        }
        return decryptedValue;
    }
}

