/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.db.telemetry.main.repository;

import com.coraltele.db.telemetry.main.entity.BillingCDR;
import com.coraltele.service.telemetry.main.billingCDR.model.BillingCDRGatewayModel;
import java.time.LocalDate;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface BillingCDRRepository
extends JpaRepository<BillingCDR, Long>,
JpaSpecificationExecutor<BillingCDR> {
    public Page<BillingCDR> findAll(Specification<BillingCDR> var1, Pageable var2);

    public List<BillingCDR> findAll(Specification<BillingCDR> var1, Sort var2);

    public List<BillingCDR> findAll(Specification<BillingCDR> var1);

    @Query(value="SELECT DISTINCT new com.coraltele.service.telemetry.main.billingCDR.model.BillingCDRGatewayModel(b.coralGateway) FROM BillingCDR b WHERE b.coralGateway IS NOT NULL AND TRIM(b.coralGateway) <> ''")
    public List<BillingCDRGatewayModel> findDistinctGateways();

    @Query(value="SELECT DISTINCT new com.coraltele.service.telemetry.main.billingCDR.model.BillingCDRGatewayModel(b.coralInBoundGateway) FROM BillingCDR b WHERE b.coralInBoundGateway IS NOT NULL AND TRIM(b.coralInBoundGateway) <> ''")
    public List<BillingCDRGatewayModel> findDistinctInboundGateways();

    @Query(value="select department_code, department_name, caller_id_number,        sum(IntercomCall) as IntercomCall,        sum(IntercomCost) as IntercomCost,        sum(LocalCall) as LocalCall,        sum(LocalCost) as LocalCost,        sum(STDCall) as STDCall,        sum(STDCost) as STDCost,        sum(ISDCall) as ISDCall,        sum(ISDCost) as ISDCost,        sum(TotalCall) as TotalCall,        sum(TotalCost) as TotalCost from (      SELECT department_code, department_name, caller_id_number,             CAST(to_timestamp(start_epoch) AS date) AS call_date,             COUNT(CASE WHEN call_type = 'INTERCOM' THEN 1 END) AS IntercomCall,             SUM(CASE WHEN call_type = 'INTERCOM' THEN cost ELSE 0 END) AS IntercomCost,             COUNT(CASE WHEN call_type = 'LOCAL' THEN 1 END) AS LocalCall,             SUM(CASE WHEN call_type = 'LOCAL' THEN cost ELSE 0 END) AS LocalCost,             COUNT(CASE WHEN call_type = 'STD' THEN 1 END) AS STDCall,             SUM(CASE WHEN call_type = 'STD' THEN cost ELSE 0 END) AS STDCost,             COUNT(CASE WHEN call_type = 'ISD' THEN 1 END) AS ISDCall,             SUM(CASE WHEN call_type = 'ISD' THEN cost ELSE 0 END) AS ISDCost,             COUNT(CASE WHEN call_type IS NOT NULL THEN 1 END) AS TotalCall,             SUM(CASE WHEN call_type IS NOT NULL THEN cost ELSE 0 END) AS TotalCost      FROM billing_cdr      WHERE coral_call_direction in ('OUT','INT')        AND caller_extension_type = 'phone'        AND (coral_featurecode is null or coral_featurecode='')     AND (:deptCode IS NULL OR LOWER(department_code) LIKE LOWER(CONCAT('%', :deptCode, '%')))      AND (:deptName IS NULL OR LOWER(department_name) LIKE LOWER(CONCAT('%', :deptName, '%')))      AND (:callerIdNumber IS NULL OR caller_id_number LIKE CONCAT('%', :callerIdNumber, '%'))        AND (CAST(:fromDate AS date) IS NULL OR CAST(to_timestamp(start_epoch) AS date) >= CAST(:fromDate AS date))        AND (CAST(:toDate AS date) IS NULL OR CAST(to_timestamp(start_epoch) AS date) <= CAST(:toDate AS date))      GROUP BY department_code, department_name, caller_id_number, call_date ) a group by department_code, department_name, caller_id_number", nativeQuery=true)
    public List<Object[]> getDepartmentSummaryReport(@Param(value="deptCode") String var1, @Param(value="deptName") String var2, @Param(value="callerIdNumber") String var3, @Param(value="fromDate") LocalDate var4, @Param(value="toDate") LocalDate var5);

    @Query(value="SELECT  id, department_code AS departmentCode, department_name AS departmentName, caller_id_number AS callerIdNumber,  to_char(to_timestamp(start_epoch), 'DDMMYY HH24MISS') AS datetimeIst,  destination_number AS destinationNumber,  call_type AS callType, coral_call_direction AS coralCallDirection,  talk_duration AS talkDuration, pulse, cost FROM billing_cdr WHERE coral_call_direction IN ('OUT','INT') AND caller_extension_type = 'phone' AND (coral_featurecode IS NULL OR coral_featurecode = '') AND call_type IS NOT NULL AND (:departmentCode IS NULL OR LOWER(department_code) LIKE LOWER(CONCAT('%', :departmentCode, '%'))) AND (:departmentName IS NULL OR LOWER(department_name) LIKE LOWER(CONCAT('%', :departmentName, '%'))) AND (:callerId IS NULL OR caller_id_number LIKE CONCAT('%', :callerId, '%')) AND (:callType IS NULL OR call_type = :callType) AND (:destinationNumber IS NULL OR destination_number LIKE CONCAT('%', :destinationNumber, '%')) AND (CAST(:fromDate AS date) IS NULL OR CAST(to_timestamp(start_epoch) AS date) >= CAST(:fromDate AS date)) AND (CAST(:toDate AS date) IS NULL OR CAST(to_timestamp(start_epoch) AS date) <= CAST(:toDate AS date)) ORDER BY department_code, department_name, caller_id_number, start_epoch desc", nativeQuery=true)
    public List<Object[]> getDepartmentDetailsReport(@Param(value="departmentCode") String var1, @Param(value="departmentName") String var2, @Param(value="callerId") String var3, @Param(value="callType") String var4, @Param(value="destinationNumber") String var5, @Param(value="fromDate") LocalDate var6, @Param(value="toDate") LocalDate var7);
}

