/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.config;

import com.coraltele.db.coralapps.callcenter.entity.Queue;
import com.coraltele.db.coralapps.main.entity.Agent;
import com.coraltele.db.coralapps.main.entity.Tiers;
import com.coraltele.db.coralapps.pbx.view.CDR;
import com.coraltele.db.coralapps.users.entity.Users;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
@EnableJpaRepositories(basePackages={"com.coraltele.db.coralapps.callcenter.repository", "com.coraltele.db.coralapps.main.repository", "com.coraltele.db.coralapps.pbx.repository", "com.coraltele.db.coralapps.users.repository"}, entityManagerFactoryRef="coralAppsEntityManagerFactory", transactionManagerRef="coralAppsTransactionManager")
public class CoralAppsDataSourceConfiguration {
    @Bean
    @ConfigurationProperties(value="spring.datasource.coralapps")
    public DataSourceProperties coralAppsDataSourceProperties() {
        return new DataSourceProperties();
    }

    @Bean
    public DataSource coralAppsDataSource(@Qualifier(value="coralAppsDataSourceProperties") DataSourceProperties coralAppsDataSourceProperties) {
        return this.coralAppsDataSourceProperties().initializeDataSourceBuilder().build();
    }

    @Bean(name={"coralAppsEntityManagerFactory"})
    public LocalContainerEntityManagerFactoryBean coralAppsEntityManagerFactory(@Qualifier(value="coralAppsDataSource") DataSource coralAppsDataSource, EntityManagerFactoryBuilder builder) {
        return builder.dataSource(coralAppsDataSource).packages(new Class[]{Queue.class, Agent.class, Tiers.class, CDR.class, Users.class}).build();
    }

    @Bean
    public PlatformTransactionManager coralAppsTransactionManager(@Qualifier(value="coralAppsEntityManagerFactory") LocalContainerEntityManagerFactoryBean entityManagerFactory) {
        return new JpaTransactionManager(entityManagerFactory.getObject());
    }
}

