/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.user.userDepartment.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.user.userDepartment.model.CreateUserDepartment;
import com.coraltele.service.user.userDepartment.service.UserDepartmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/userDepartment"})
@RestController
public class UserDepartmentController {
    @Autowired
    private UserDepartmentService userDepartmentService;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> create(@RequestBody CreateUserDepartment data) {
        RequestResponse returnValue = this.userDepartmentService.associateUserDepartment(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteByUsername(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.userDepartmentService.deleteByUsername(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list/userDepartment"})
    public ResponseEntity<RequestResponse> getGroupedDepartments() {
        RequestResponse returnValue = this.userDepartmentService.getGroupedDepartments();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list/userDepartmentFilter"})
    public ResponseEntity<RequestResponse> getGroupedDepartmentsFlter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.userDepartmentService.getGroupedDepartmentsFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

