/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.trainAlert.service;

import com.coraltele.db.telemetry.main.entity.TrainAlert;
import com.coraltele.db.telemetry.main.repository.TainAlertRepository;
import com.coraltele.db.telemetry.main.specification.TrainAlertSpecification;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.main.trainAlert.model.TrainAlertModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class TrainAlertService {
    private static final Logger logger = LogManager.getLogger(TrainAlertService.class);
    @Autowired
    TainAlertRepository trainAlertRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;

    public void create(TrainAlert data) {
        this.trainAlertRepository.save((Object)data);
    }

    public RequestResponse getAll(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = TrainAlertSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "event_epoch" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "event_epoch" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.trainAlertRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.trainAlertRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<TrainAlertModel> entityToModelConversion(List<TrainAlert> trainAlert) {
        ArrayList<TrainAlertModel> addValue = new ArrayList<TrainAlertModel>();
        for (TrainAlert row : trainAlert) {
            TrainAlertModel data = new TrainAlertModel();
            data.setId(row.getId());
            data.setAccessCode(row.getAccessCode());
            data.setCreatedBy(row.getCreatedBy());
            data.setCreatedOn(DateFormatUtility.epochToLocalDateTimeAsStringForSecond((Long)row.getCreatedOn()));
            data.setDescription(row.getDescription());
            data.setDidMapping(row.getDidMapping());
            data.setEventSeverity(row.getEventSeverity());
            data.setEventType(row.getEventType());
            data.setRoomName(row.getRoomName());
            data.setType(row.getType());
            data.setUuid(row.getUuid());
            data.setZone(row.getZone());
            addValue.add(data);
        }
        return addValue;
    }
}

