/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.queueTimeIntervalView.service;

import com.coraltele.db.telemetry.main.repository.QueueTimeIntervalFifteenViewRepository;
import com.coraltele.db.telemetry.main.repository.QueueTimeIntervalFortyFiveViewRepository;
import com.coraltele.db.telemetry.main.repository.QueueTimeIntervalSixtyViewRepository;
import com.coraltele.db.telemetry.main.repository.QueueTimeIntervalViewRepository;
import com.coraltele.db.telemetry.main.specification.QueueTimeIntervalFifteenViewSpecification;
import com.coraltele.db.telemetry.main.specification.QueueTimeIntervalFortyFiveViewSpecification;
import com.coraltele.db.telemetry.main.specification.QueueTimeIntervalSixtyViewSpecification;
import com.coraltele.db.telemetry.main.specification.QueueTimeIntervalViewSpecification;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.coralApps.callcenter.queueTL.service.QueueTLService;
import com.coraltele.service.user.service.UserService;
import java.security.Principal;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class QueueTimeIntervalService {
    private static final Logger logger = LogManager.getLogger(QueueTimeIntervalService.class);
    @Autowired
    QueueTimeIntervalViewRepository queueTimeIntervalViewRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    QueueTimeIntervalFifteenViewRepository queueTimeIntervalFifteenViewRepository;
    @Autowired
    QueueTimeIntervalFortyFiveViewRepository queueTimeIntervalFortyFiveViewRepository;
    @Autowired
    QueueTimeIntervalSixtyViewRepository queueTimeIntervalSixtyViewRepository;
    @Autowired
    UserService userService;
    @Autowired
    QueueTLService queueTLService;

    public RequestResponse getAllByFilter(SearchRequest searchRequestData, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        boolean teamLeaderUser = false;
        if (this.userService.checkRoleTL(principal.getName())) {
            teamLeaderUser = true;
        }
        List queueId = null;
        if (teamLeaderUser) {
            queueId = this.queueTLService.getQueueListByTeamLeader(principal.getName());
        }
        Specification filters = QueueTimeIntervalViewSpecification.generateFilters((SearchRequest)searchRequestData, (boolean)teamLeaderUser, queueId);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "queue" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "queue" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.queueTimeIntervalViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.queueTimeIntervalViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllByFilterForFifteenTimeInterval(SearchRequest searchRequestData, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        boolean teamLeaderUser = false;
        if (this.userService.checkRoleTL(principal.getName())) {
            teamLeaderUser = true;
        }
        List queueId = null;
        if (teamLeaderUser) {
            queueId = this.queueTLService.getQueueListByTeamLeader(principal.getName());
        }
        Specification filters = QueueTimeIntervalFifteenViewSpecification.generateFilters((SearchRequest)searchRequestData, (boolean)teamLeaderUser, queueId);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "queue" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "queue" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.queueTimeIntervalFifteenViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.queueTimeIntervalFifteenViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllByFilterForFortyFive(SearchRequest searchRequestData, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        boolean teamLeaderUser = false;
        if (this.userService.checkRoleTL(principal.getName())) {
            teamLeaderUser = true;
        }
        List queueId = null;
        if (teamLeaderUser) {
            queueId = this.queueTLService.getQueueListByTeamLeader(principal.getName());
        }
        Specification filters = QueueTimeIntervalFortyFiveViewSpecification.generateFilters((SearchRequest)searchRequestData, (boolean)teamLeaderUser, queueId);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "queue" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "queue" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.queueTimeIntervalFortyFiveViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.queueTimeIntervalFortyFiveViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllByFilterForSixty(SearchRequest searchRequestData, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        boolean teamLeaderUser = false;
        if (this.userService.checkRoleTL(principal.getName())) {
            teamLeaderUser = true;
        }
        List queueId = null;
        if (teamLeaderUser) {
            queueId = this.queueTLService.getQueueListByTeamLeader(principal.getName());
        }
        Specification filters = QueueTimeIntervalSixtyViewSpecification.generateFilters((SearchRequest)searchRequestData, (boolean)teamLeaderUser, queueId);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "queue" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "queue" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.queueTimeIntervalSixtyViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.queueTimeIntervalSixtyViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

