/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.escalation.service;

import com.coraltele.db.telemetry.main.entity.Escalation;
import com.coraltele.db.telemetry.main.repository.EscalationRepository;
import com.coraltele.db.telemetry.main.specification.EscalationSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.main.escalation.model.EscalationModel;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class EscalationService {
    private static final Logger logger = LogManager.getLogger(EscalationService.class);
    @Autowired
    EscalationRepository escalationRepository;

    public RequestResponse createData(EscalationModel data) {
        logger.debug("Create New Escalation : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Escalation escalation = new Escalation();
            escalation.setLevel1HoldTime(Long.valueOf(DateFormatUtility.convertLocalTimeToSeconds((LocalTime)data.getLevel1HoldTime())));
            escalation.setLevel2HoldTime(Long.valueOf(DateFormatUtility.convertLocalTimeToSeconds((LocalTime)data.getLevel2HoldTime())));
            escalation.setLevel3HoldTime(Long.valueOf(DateFormatUtility.convertLocalTimeToSeconds((LocalTime)data.getLevel3HoldTime())));
            escalation.setLevel1MailId(data.getLevel1MailId());
            escalation.setLevel2MailId(data.getLevel2MailId());
            escalation.setLevel3MailId(data.getLevel3MailId());
            this.escalationRepository.save((Object)escalation);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Escalation Created");
            returnValue.setMessageDetail("Escalation Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable To Create Escalation");
            returnValue.setMessageDetail("Contact With Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateById(EscalationModel data) {
        logger.debug("Update Escalation {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional escalation = this.escalationRepository.findById((Object)data.getId());
        if (!escalation.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found");
            returnValue.setMessageDetail("Escalation Not Found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        Escalation escalation2 = (Escalation)escalation.get();
        if (data.getLevel1HoldTime() != null) {
            escalation2.setLevel1HoldTime(Long.valueOf(DateFormatUtility.convertLocalTimeToSeconds((LocalTime)data.getLevel1HoldTime())));
        }
        if (data.getLevel2HoldTime() != null) {
            escalation2.setLevel2HoldTime(Long.valueOf(DateFormatUtility.convertLocalTimeToSeconds((LocalTime)data.getLevel2HoldTime())));
        }
        if (data.getLevel3HoldTime() != null) {
            escalation2.setLevel3HoldTime(Long.valueOf(DateFormatUtility.convertLocalTimeToSeconds((LocalTime)data.getLevel3HoldTime())));
        }
        if (data.getLevel1MailId() != null) {
            escalation2.setLevel1MailId(data.getLevel1MailId());
        }
        if (data.getLevel2MailId() != null) {
            escalation2.setLevel2MailId(data.getLevel2MailId());
        }
        if (data.getLevel3MailId() != null) {
            escalation2.setLevel3MailId(data.getLevel3MailId());
        }
        this.escalationRepository.save((Object)escalation2);
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("Escalation Updated Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteLocationTypeById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional escalationOptional = this.escalationRepository.findById((Object)ids);
            if (escalationOptional.isPresent()) {
                addValue.add(escalationOptional.get());
                this.escalationRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records Not Found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllLocationTypeByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = EscalationSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.escalationRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.escalationRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<EscalationModel> entityToModelConversion(List<Escalation> lastAgent) {
        ArrayList<EscalationModel> addValue = new ArrayList<EscalationModel>();
        for (Escalation row : lastAgent) {
            EscalationModel data = new EscalationModel();
            data.setId(row.getId());
            data.setLevel1HoldTime(DateFormatUtility.convertSecondsToLocalTime((Long)row.getLevel1HoldTime()));
            data.setLevel2HoldTime(DateFormatUtility.convertSecondsToLocalTime((Long)row.getLevel2HoldTime()));
            data.setLevel3HoldTime(DateFormatUtility.convertSecondsToLocalTime((Long)row.getLevel3HoldTime()));
            data.setLevel1MailId(row.getLevel1MailId());
            data.setLevel2MailId(row.getLevel2MailId());
            data.setLevel3MailId(row.getLevel3MailId());
            addValue.add(data);
        }
        return addValue;
    }
}

