/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.discoverSubnet.service;

import com.coraltele.db.telemetry.main.entity.DiscoverSubnet;
import com.coraltele.db.telemetry.main.repository.DiscoverSubnetRepository;
import com.coraltele.db.telemetry.main.specification.DiscoverSubnetSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.main.discoverSubnet.model.DiscoverSubnetModel;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class DiscoverSubnetService {
    public static final Logger logger = LogManager.getLogger(DiscoverSubnetService.class);
    @Autowired
    DiscoverSubnetRepository discoverSubnetRepository;

    public RequestResponse createSubnet(DiscoverSubnetModel data) {
        logger.debug("create new subnet : {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            DiscoverSubnet discoverSubnet = new DiscoverSubnet();
            discoverSubnet.setIp(data.getIp());
            discoverSubnet.setIpType(data.getIpType());
            discoverSubnet.setLocation(data.getLocation());
            discoverSubnet.setSubnet(data.getSubnet());
            this.discoverSubnetRepository.save((Object)discoverSubnet);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("subnet created successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("unable to create subnet");
            returnValue.setMessageDetail("contact with administrator");
            logger.error(returnValue.getMessage(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateById(DiscoverSubnetModel data) {
        logger.debug("update subnet:{}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional discoverSubnet = this.discoverSubnetRepository.findById(data.getId());
        if (!discoverSubnet.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("subnet not found");
        } else {
            if (data.getIp() != null) {
                ((DiscoverSubnet)discoverSubnet.get()).setIp(data.getIp());
            }
            if (data.getIpType() != null) {
                ((DiscoverSubnet)discoverSubnet.get()).setIpType(data.getIpType());
            }
            if (data.getLocation() != null) {
                ((DiscoverSubnet)discoverSubnet.get()).setLocation(data.getLocation());
            }
            if (data.getSubnet() != null) {
                ((DiscoverSubnet)discoverSubnet.get()).setSubnet(data.getSubnet());
            }
            this.discoverSubnetRepository.save(discoverSubnet.get());
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("updated");
        returnValue.setMessageDetail("subnet updated successfully");
        return returnValue;
    }

    public RequestResponse deleteSubnetById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Long id : data.getId()) {
            Optional discoverSubnet = this.discoverSubnetRepository.findById(Long.valueOf(id));
            if (discoverSubnet.isPresent()) {
                addValue.add(discoverSubnet.get());
                this.discoverSubnetRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("deleted");
        returnValue.setMessageDetail("subnet deleted successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getSubnetByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = DiscoverSubnetSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.discoverSubnetRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.discoverSubnetRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

