/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.agentPerformanceSummary.service;

import com.coraltele.db.telemetry.main.entity.AgentPerformanceSummary;
import com.coraltele.db.telemetry.main.repository.AgentPerformanceSummaryRepository;
import com.coraltele.db.telemetry.main.specification.AgentPerformanceSummarySpecification;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.coralApps.callcenter.queueTL.service.QueueTLService;
import com.coraltele.service.telemetry.main.agentPerformanceSummary.model.DailyPerformanceReportModel;
import com.coraltele.service.telemetry.main.agentPerformanceSummary.model.DailyReportModel;
import com.coraltele.service.telemetry.main.agentPerformanceSummary.service.AgentPerformanceSummaryService;
import com.coraltele.service.user.service.UserService;
import java.security.Principal;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class AgentPerformanceService {
    private static final Logger logger = LogManager.getLogger(AgentPerformanceSummaryService.class);
    @Autowired
    AgentPerformanceSummaryRepository agentPerformanceSummaryRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    UserService userService;
    @Autowired
    QueueTLService queueTLService;

    public RequestResponse getAllByFilterForDailyReport(SearchRequest searchRequestData, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        boolean adminUser = false;
        boolean teamLeaderUser = false;
        boolean managerUser = false;
        if (this.userService.checkAdminUser(principal.getName())) {
            adminUser = true;
        } else if (this.userService.checkRoleTL(principal.getName())) {
            teamLeaderUser = true;
        } else if (this.userService.checkManagerUser(principal.getName())) {
            managerUser = true;
        }
        Specification filters = AgentPerformanceSummarySpecification.generateFilters((SearchRequest)searchRequestData, (String)principal.getName(), (boolean)adminUser, (boolean)teamLeaderUser, (boolean)managerUser, (List)this.queueTLService.getAgentListByTL(principal.getName()));
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "startDate" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "startDate" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.agentPerformanceSummaryRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.agentPerformanceSummaryRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversionForDailyReport(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<DailyReportModel> entityToModelConversionForDailyReport(List<AgentPerformanceSummary> agentSummary) {
        ArrayList<DailyReportModel> addValue = new ArrayList<DailyReportModel>();
        for (AgentPerformanceSummary row : agentSummary) {
            Duration netLoginTime;
            Duration unServiceDuration;
            DailyReportModel data = new DailyReportModel();
            data.setAgentName(row.getAgentName());
            if (row.getAverageTalkDuration() != null) {
                data.setAverageTalkDuration(DateFormatUtility.findLocalTime((Long)row.getAverageTalkDuration()));
            } else {
                data.setAverageTalkDuration("00:00:00");
            }
            if (row.getTotalAcwDuration() != null) {
                data.setTotalAcwDuration(DateFormatUtility.findLocalTime((Long)row.getTotalAcwDuration().longValue()));
            } else {
                data.setTotalAcwDuration("00:00:00");
            }
            Duration totalUnServiceDuration = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(row.getUnServiceDuration().longValue())));
            if (row.getStartCallTime() == null && row.getUnLoginTime() != null) {
                unServiceDuration = Duration.between(row.getUnLoginTime(), LocalDateTime.now());
                unServiceDuration = unServiceDuration.plus(totalUnServiceDuration);
            } else {
                unServiceDuration = totalUnServiceDuration;
            }
            data.setUnServiceDuration(DateFormatUtility.findLocalTime((Long)unServiceDuration.getSeconds()));
            data.setTotalAnswered(row.getTotalAnswered());
            Duration totalLoginDuration = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(row.getTotalLoginDuration().longValue())));
            if (row.getLogoutTime() != null) {
                netLoginTime = totalLoginDuration;
            } else {
                netLoginTime = Duration.between(row.getLoginTime(), LocalDateTime.now());
                netLoginTime = netLoginTime.plus(totalLoginDuration);
            }
            data.setNetLoginTime(DateFormatUtility.findLocalTime((Long)netLoginTime.getSeconds()));
            Duration totalDialedDuration = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(row.getTotalDialedDuration().longValue())));
            Duration totalTalkDuration = Duration.ofSeconds(this.getDurationOrZero(row.getTotalTalkDuration()));
            Duration totalRingDuration = Duration.ofSeconds(this.getDurationOrZero(row.getTotalRingDuration()));
            Duration totalAcwDuration = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(row.getTotalAcwDuration().longValue())));
            Duration totalBreakDuration = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(row.getTotalBreakDuration().longValue())));
            Duration netRingDuration = totalRingDuration.plus(totalDialedDuration);
            Duration totalIdleDuration = netLoginTime.minus(netRingDuration).minus(totalAcwDuration).minus(totalTalkDuration).minus(totalBreakDuration).minus(unServiceDuration);
            data.setTotalIdleDuration(DateFormatUtility.findLocalTime((Long)totalIdleDuration.getSeconds()));
            data.setTotalNoAnswered(row.getTotalNoAnswered());
            data.setTotalOffered(row.getTotalOffered());
            data.setFullName(row.getFullname());
            if (row.getTotalBreakDuration() != null) {
                data.setTotalBreakDuration(DateFormatUtility.findLocalTime((Long)row.getTotalBreakDuration().longValue()));
            } else {
                data.setTotalBreakDuration("00:00:00");
            }
            Duration totalTime = netLoginTime.minus(totalBreakDuration).minus(unServiceDuration);
            data.setTotalLoginDuration(DateFormatUtility.findLocalTime((Long)totalTime.getSeconds()));
            data.setStartDate(DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)row.getStartDate()));
            data.setTotalRingDuration(DateFormatUtility.findLocalTime((Long)netRingDuration.getSeconds()));
            if (row.getTotalTalkDuration() != null) {
                data.setTotalTalkDuration(DateFormatUtility.findLocalTime((Long)row.getTotalTalkDuration()));
            } else {
                data.setTotalTalkDuration("00:00:00");
            }
            addValue.add(data);
        }
        return addValue;
    }

    public RequestResponse getAllByFilterForDailyPerformance(SearchRequest searchRequestData, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        boolean adminUser = false;
        boolean managerUser = false;
        boolean teamLeaderUser = false;
        if (this.userService.checkAdminUser(principal.getName())) {
            adminUser = true;
        } else if (this.userService.checkManagerUser(principal.getName())) {
            managerUser = true;
        } else if (this.userService.checkRoleTL(principal.getName())) {
            teamLeaderUser = true;
        }
        Specification filters = AgentPerformanceSummarySpecification.generateFilters((SearchRequest)searchRequestData, (String)principal.getName(), (boolean)adminUser, (boolean)teamLeaderUser, (boolean)managerUser, (List)this.queueTLService.getAgentListByTL(principal.getName()));
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "totalAnswered" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "totalAnswered" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.agentPerformanceSummaryRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.agentPerformanceSummaryRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversionForDailyPerformance(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<DailyPerformanceReportModel> entityToModelConversionForDailyPerformance(List<AgentPerformanceSummary> agentSummary) {
        ArrayList<DailyPerformanceReportModel> addValue = new ArrayList<DailyPerformanceReportModel>();
        for (AgentPerformanceSummary row : agentSummary) {
            DailyPerformanceReportModel data = new DailyPerformanceReportModel();
            data.setRecordEpoch(row.getStartDate());
            data.setStartDate(this.dateFormatUtility.epochToLocalDateForLocalTimeZone(row.getStartDate()));
            data.setStartDateTimeLocal(DateFormatUtility.epochToLocalDateTimeForLocalTimeZone((Long)row.getStartDate()));
            data.setStartDateTimeUtc(DateFormatUtility.epochToLocalDateTimeInUTC((Long)row.getStartDate()));
            data.setAgentName(row.getAgentName());
            if (row.getAverageTalkDuration() != null) {
                data.setAverageTalkDuration(DateFormatUtility.findLocalTime((Long)row.getAverageTalkDuration()));
            } else {
                data.setAverageTalkDuration("00:00:00");
            }
            data.setTotalAnswered(Integer.valueOf(row.getTotalAnswered() + row.getTotalConnected()));
            data.setInAnswered(row.getTotalAnswered());
            data.setOutAnswered(row.getTotalConnected());
            data.setTotalNoAnswered(Integer.valueOf(row.getTotalNoAnswered() + row.getTotalNotConnected()));
            data.setInNoAnswered(row.getTotalNoAnswered().toString());
            data.setOutNoAnswered(row.getTotalNotConnected().toString());
            data.setTotalOffered(row.getTotalOffered());
            data.setTotalDialed(row.getTotalDialed());
            if (row.getTotalTalkDuration() != null) {
                data.setTotalTalkDuration(DateFormatUtility.findLocalTime((Long)row.getTotalTalkDuration()));
            } else {
                data.setTotalTalkDuration("00:00:00");
            }
            if (row.getTotalAcwDuration() != null) {
                data.setTotalAcwDuration(DateFormatUtility.findLocalTime((Long)row.getTotalAcwDuration().longValue()));
            } else {
                data.setTotalAcwDuration("00:00:00");
            }
            data.setInRingDuration(row.getTotalRingDuration() != null ? DateFormatUtility.findLocalTime((Long)row.getTotalRingDuration()) : "00:00:00");
            data.setOutRingDuration(row.getRealTotalDialedDuration() != null ? DateFormatUtility.findLocalTime((Long)row.getRealTotalDialedDuration().longValue()) : "00:00:00");
            data.setInTalkDuration(row.getTotalOfferedTalkDuration() != null ? DateFormatUtility.findLocalTime((Long)row.getTotalOfferedTalkDuration()) : "00:00:00");
            data.setOutTalkDuration(row.getTotalDialedTalkDuration() != null ? DateFormatUtility.findLocalTime((Long)row.getTotalDialedTalkDuration()) : "00:00:00");
            data.setSecond10(row.getSecond10());
            data.setSecond20(row.getSecond20());
            data.setSecond30(row.getSecond30());
            data.setSecond40(row.getSecond40());
            data.setSecond50(row.getSecond50());
            data.setSecond60(row.getSecond60());
            data.setFullname(row.getFullname());
            Duration totalLoginDuration = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(row.getTotalLoginDuration().longValue())));
            if (row.getLoginTime() == null && row.getLogoutTime() == null) {
                data.setNetLoginTime("00:00:00");
                data.setUnServiceDuration("00:00:00");
                data.setTotalLoginDuration("00:00:00");
                data.setTotalIdleDuration("00:00:00");
                data.setTotalBreakDuration("00:00:00");
                data.setTotalRingDuration("00:00:00");
            } else {
                Duration unServiceDuration;
                if (row.getLoginTime() != null && row.getLogoutTime() == null) {
                    Duration totalLogin = Duration.between(row.getLoginTime(), LocalDateTime.now());
                    totalLoginDuration = totalLoginDuration.plus(totalLogin);
                }
                data.setNetLoginTime(DateFormatUtility.findLocalTime((Long)totalLoginDuration.getSeconds()));
                Duration totalUnServiceDuration = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(row.getUnServiceDuration().longValue())));
                if (row.getStartCallTime() == null && row.getUnLoginTime() != null) {
                    unServiceDuration = Duration.between(row.getUnLoginTime(), LocalDateTime.now());
                    unServiceDuration = unServiceDuration.plus(totalUnServiceDuration);
                } else {
                    unServiceDuration = totalUnServiceDuration;
                }
                data.setUnServiceDuration(DateFormatUtility.findLocalTime((Long)unServiceDuration.getSeconds()));
                Duration realTotalDialedDuration = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(row.getRealTotalDialedDuration().longValue())));
                Duration totalTalkDuration = Duration.ofSeconds(this.getDurationOrZero(row.getTotalTalkDuration()));
                Duration totalRingDuration = Duration.ofSeconds(this.getDurationOrZero(row.getTotalRingDuration()));
                Duration totalAcwDuration = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(row.getTotalAcwDuration().longValue())));
                Duration totalBreakDuration = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(row.getTotalBreakDuration().longValue())));
                if (row.getBreakTime() != null && row.getLogoutTime() == null) {
                    Duration totalBreakTime = Duration.between(row.getBreakTime(), LocalDateTime.now());
                    totalBreakDuration = totalBreakDuration.plus(totalBreakTime);
                }
                data.setTotalBreakDuration(DateFormatUtility.findLocalTime((Long)totalBreakDuration.getSeconds()));
                Duration netRingDuration = totalRingDuration.plus(realTotalDialedDuration);
                Duration totalIdleDuration = totalLoginDuration.minus(netRingDuration).minus(totalAcwDuration).minus(totalTalkDuration).minus(totalBreakDuration).minus(unServiceDuration);
                data.setTotalIdleDuration(DateFormatUtility.findLocalTime((Long)totalIdleDuration.getSeconds()));
                Duration totalTime = totalLoginDuration.minus(totalBreakDuration).minus(unServiceDuration);
                data.setTotalLoginDuration(DateFormatUtility.findLocalTime((Long)totalTime.getSeconds()));
                data.setTotalRingDuration(DateFormatUtility.findLocalTime((Long)netRingDuration.getSeconds()));
            }
            addValue.add(data);
        }
        return addValue;
    }

    private long getDurationOrZero(Long duration) {
        return duration != null ? duration : 0L;
    }
}

