/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.designation.service;

import com.coraltele.db.telephony.billing.entity.Designation;
import com.coraltele.db.telephony.billing.repository.DesignationRepository;
import com.coraltele.db.telephony.billing.specification.DesignationSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.designation.model.DesignationModel;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class DesignationService {
    private static final Logger logger = LogManager.getLogger(DesignationService.class);
    @Autowired
    DesignationRepository designationRepository;

    public RequestResponse createData(DesignationModel data, Principal principal) {
        logger.debug("create new designation : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Designation designation = new Designation();
            designation.setCreatedBy(principal.getName());
            designation.setCode(data.getCode());
            if (data.getActive().booleanValue()) {
                designation.setActive(data.getActive());
            } else {
                designation.setActive(Boolean.valueOf(false));
            }
            designation.setCreatedOn(LocalDateTime.now());
            designation.setDescription(data.getDescription());
            this.designationRepository.save((Object)designation);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("Designation Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to Create Designation");
            returnValue.setMessageDetail("Contact with Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse deleteById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional designation = this.designationRepository.findById(Integer.valueOf(ids));
            if (designation.isPresent()) {
                addValue.add(designation.get());
                this.designationRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateById(DesignationModel data) {
        logger.debug("Update designation {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional designation = this.designationRepository.findById(data.getId());
        if (!designation.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("designation not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getCode() != null) {
            ((Designation)designation.get()).setCode(data.getCode());
        }
        if (data.getActive() != null) {
            ((Designation)designation.get()).setActive(data.getActive());
        }
        if (data.getDescription() != null) {
            ((Designation)designation.get()).setDescription(data.getDescription());
        }
        this.designationRepository.save(designation.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("Designation Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = DesignationSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "code" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "code" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.designationRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.designationRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllDesignation() {
        List list = (List)this.designationRepository.findAll();
        ArrayList<DesignationModel> addValue = new ArrayList<DesignationModel>();
        RequestResponse returnValue = new RequestResponse();
        for (Designation data : list) {
            DesignationModel designationModel = new DesignationModel();
            designationModel.setActive(data.getActive());
            designationModel.setCode(data.getCode());
            designationModel.setCreatedBy(data.getCreatedBy());
            designationModel.setCreatedOn(data.getCreatedOn());
            designationModel.setId(data.getId());
            designationModel.setDescription(data.getDescription());
            addValue.add(designationModel);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

