/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.actionCodeList.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.pbx.actionCodeList.model.ActionCodeListModel;
import com.coraltele.service.pbx.actionCodeList.service.ActionCodeListService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/actionCodeMaster"})
@RestController
public class ActionCodeListController {
    @Autowired
    ActionCodeListService actionCodeListService;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> create(@RequestBody ActionCodeListModel data) {
        RequestResponse returnValue = this.actionCodeListService.createData(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllByFilter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.actionCodeListService.getAllByFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateById(@RequestBody ActionCodeListModel data) {
        RequestResponse returnValue = this.actionCodeListService.updateById(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteById(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.actionCodeListService.deleteAgentById(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAll/{codeType}"})
    public ResponseEntity<RequestResponse> getAllByCodetype(@PathVariable(value="codeType") String codeType) {
        RequestResponse returnValue = this.actionCodeListService.getAllByCodetype(codeType);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

